/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.resource;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.mojang.bridge.game.GameVersion;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class ExperimentalResourcePack
implements class_3262 {
    private static final String PACK_DESC = "Experimental Resource Pack for Enhanced Block Entities";
    public final String PACK_META = String.format("{\"pack\":{\"pack_format\":%s,\"description\":\"%s\"}}", class_3264.field_14188.method_31438((GameVersion)class_155.method_16673()), "Experimental Resource Pack for Enhanced Block Entities");
    private final Map<class_2960, byte[]> resources = new Object2ObjectOpenHashMap();
    private final Set<String> namespaces = new HashSet<String>();

    public void put(class_2960 id, byte[] resource) {
        this.resources.put(id, resource);
        this.namespaces.add(id.method_12836());
    }

    public InputStream method_14410(String fileName) throws IOException {
        if ("pack.mcmeta".equals(fileName)) {
            return IOUtils.toInputStream((String)this.PACK_META, (Charset)Charsets.UTF_8);
        }
        throw new FileNotFoundException("No such file '" + fileName + "' in EBE experimental resources");
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        if (type == class_3264.field_14188 && this.resources.containsKey(id)) {
            return new ByteArrayInputStream(this.resources.get(id));
        }
        throw new FileNotFoundException("No such resource '" + id.toString() + "' of type '" + type.toString() + "' in EBE experimental resources");
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        if (type == class_3264.field_14188) {
            ImmutableList.Builder r = ImmutableList.builder();
            this.resources.keySet().forEach(id -> {
                if (id.method_12836().equals(namespace) && id.method_12832().startsWith(prefix) && pathFilter.test(id.method_12832()) && id.method_12832().split("[/\\\\]").length <= maxDepth) {
                    r.add(id);
                }
            });
        }
        return Collections.emptyList();
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        if (type == class_3264.field_14188) {
            return this.resources.containsKey(id);
        }
        return false;
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        return (T)class_3255.method_14392(metaReader, (InputStream)this.method_14410("pack.mcmeta"));
    }

    public String method_14409() {
        return "ebe:exp_resources";
    }

    public void close() {
    }
}

