/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EBESetup;
import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.render.SignRenderManager;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EnhancedBlockEntities
implements ClientModInitializer {
    public static final Logger LOG = LogManager.getLogger((String)"Enhanced Block Entities");
    public static final EBEConfig CONFIG = new EBEConfig();

    public void onInitializeClient() {
        WorldRenderEvents.END.register(SignRenderManager::endFrame);
        ModelIdentifiers.init();
        EBESetup.setupResourceProviders();
        FabricModelPredicateProviderRegistry.register((class_1792)class_1802.field_8106, (class_2960)new class_2960("is_christmas"), (stack, world, entity, seed) -> DateUtil.isChristmas() ? 1.0f : 0.0f);
        EnhancedBlockEntities.load();
    }

    public static void reload(ReloadType type) {
        EnhancedBlockEntities.load();
        if (type == ReloadType.WORLD) {
            class_310.method_1551().field_1769.method_3279();
        } else if (type == ReloadType.RESOURCES) {
            class_310.method_1551().method_1521();
        }
    }

    public static void load() {
        CONFIG.load();
        EnhancedBlockEntityRegistry.clear();
        ResourceUtil.resetPack();
        if (EnhancedBlockEntities.CONFIG.renderEnhancedChests) {
            EBESetup.setupChests();
            EBESetup.setupRRPChests();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedSigns) {
            EBESetup.setupSigns();
            EBESetup.setupRRPSigns();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBells) {
            EBESetup.setupBells();
            EBESetup.setupRRPBells();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBeds) {
            EBESetup.setupBeds();
            EBESetup.setupRRPBeds();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedShulkerBoxes) {
            EBESetup.setupShulkerBoxes();
            EBESetup.setupRRPShulkerBoxes();
        }
    }
}

