/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.compat;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class OptifineHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle SHADERS_ACTIVE_PROGRAM;
    private static final MethodHandle PROGRAM_GET_NAME;
    private static final MethodHandle CONFIG_IS_SHADERS;
    private static final MethodHandle SHADERS_BEGIN_LEASH;
    private static final MethodHandle SHADERS_END_LEASH;
    private static final MethodHandle SHADERS_IS_SHADOW_PASS;
    private static boolean optifineDisabled;

    public static void doOptifineAwareRender(WorldRenderContext ctx, BiConsumer<WorldRenderContext, Boolean> renderer) {
        if (SHADERS_END_LEASH == null || SHADERS_BEGIN_LEASH == null || CONFIG_IS_SHADERS == null || optifineDisabled) {
            renderer.accept(ctx, false);
            return;
        }
        try {
            boolean shadersEnabled = CONFIG_IS_SHADERS.invoke();
            if (!shadersEnabled) {
                renderer.accept(ctx, false);
            } else if (!SHADERS_IS_SHADOW_PASS.invoke()) {
                SHADERS_BEGIN_LEASH.invoke();
                renderer.accept(ctx, true);
                SHADERS_END_LEASH.invoke();
            }
        }
        catch (Throwable err) {
            optifineDisabled = true;
            LOGGER.error("[WhereIsIt] Failed to render WhereIsIt using OptiFine hooks", err);
        }
    }

    static {
        optifineDisabled = false;
        MethodHandle configIsShaders = null;
        MethodHandle shadersEndLeash = null;
        MethodHandle shadersBeginLeash = null;
        MethodHandle programGetName = null;
        MethodHandle shadersActiveProgram = null;
        MethodHandle shadersIsShadowPass = null;
        try {
            Class<?> config = Class.forName("net.optifine.Config");
            Class<?> shaders = Class.forName("net.optifine.shaders.Shaders");
            Class<?> program = Class.forName("net.optifine.shaders.Program");
            configIsShaders = LOOKUP.findStatic(config, "isShaders", MethodType.methodType(Boolean.TYPE));
            shadersEndLeash = LOOKUP.findStatic(shaders, "endLeash", MethodType.methodType(Void.TYPE));
            shadersBeginLeash = LOOKUP.findStatic(shaders, "beginLeash", MethodType.methodType(Void.TYPE));
            programGetName = LOOKUP.findVirtual(program, "getName", MethodType.methodType(String.class));
            shadersActiveProgram = LOOKUP.findStaticGetter(shaders, "activeProgram", program);
            shadersIsShadowPass = LOOKUP.findStaticGetter(shaders, "isShadowPass", Boolean.TYPE);
            LOGGER.debug("[WhereIsIt] Optifine integration successfully initialized");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ignore) {
            optifineDisabled = true;
        }
        CONFIG_IS_SHADERS = configIsShaders;
        SHADERS_END_LEASH = shadersEndLeash;
        SHADERS_BEGIN_LEASH = shadersBeginLeash;
        PROGRAM_GET_NAME = programGetName;
        SHADERS_ACTIVE_PROGRAM = shadersActiveProgram;
        SHADERS_IS_SHADOW_PASS = shadersIsShadowPass;
    }
}

