/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import red.jackf.whereisit.Searcher;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.client.PositionData;
import red.jackf.whereisit.mixin.AccessorDrawableHelper;
import red.jackf.whereisit.mixin.AccessorHandledScreen;

@Environment(value=EnvType.CLIENT)
public abstract class RenderUtils {
    public static final Map<class_2338, PositionData> FOUND_ITEM_POSITIONS = new HashMap<class_2338, PositionData>();
    public static final Event<RenderLocation> RENDER_LOCATION_EVENT = EventFactory.createArrayBacked(RenderLocation.class, (context, simpleRendering, positionData) -> {}, callbacks -> (context, simpleRendering, positionData) -> {
        for (RenderLocation callback : callbacks) {
            callback.renderLocation(context, simpleRendering, positionData);
        }
    });
    private static final List<class_2338> toRemove = new ArrayList<class_2338>();
    @Nullable
    public static class_1792 lastSearchedItem = null;
    @Nullable
    public static class_2487 lastSearchedTag = null;
    public static boolean lastSearchedIgnoreNbt = false;
    private static long lastSearchTime = 0L;

    public static void setLastSearch(class_1792 item, boolean ignoreNbt, class_2487 nbt) {
        lastSearchedItem = item;
        lastSearchedIgnoreNbt = ignoreNbt;
        lastSearchedTag = nbt;
    }

    public static void clearSearch() {
        FOUND_ITEM_POSITIONS.clear();
        RenderUtils.clearSlotSearch();
    }

    public static void clearSlotSearch() {
        lastSearchedItem = null;
        lastSearchedIgnoreNbt = false;
        lastSearchedTag = null;
        lastSearchTime = -1L;
    }

    public static void renderTexts(WorldRenderContext context, Boolean simpleRendering) {
        if (FOUND_ITEM_POSITIONS.size() == 0) {
            return;
        }
        context.world().method_16107().method_15405("whereisit_text");
        for (Map.Entry<class_2338, PositionData> entry : FOUND_ITEM_POSITIONS.entrySet()) {
            PositionData data = entry.getValue();
            class_243 basePos = class_243.method_24954((class_2382)data.pos);
            if (!context.world().method_8320(data.pos.method_10084()).method_26225()) {
                basePos = basePos.method_1031(0.0, 1.0, 0.0);
            }
            int i = data.getAllText().size() - 1;
            for (class_2561 text : data.getAllText()) {
                class_243 pos = basePos.method_1031(0.0, (double)i * 0.3 * (double)((float)WhereIsIt.CONFIG.getTextSizeModifier() / 100.0f), 0.0);
                RenderUtils.drawTextWithBackground(context, pos, text, 64, true);
                --i;
            }
        }
    }

    public static void renderHighlights(WorldRenderContext context, Boolean simpleRendering) {
        if (lastSearchTime == -1L && lastSearchedItem != null) {
            lastSearchTime = context.world().method_8510();
        } else if (context.world().method_8510() >= lastSearchTime + (long)WhereIsIt.CONFIG.getFadeoutTime()) {
            RenderUtils.clearSlotSearch();
        }
        if (FOUND_ITEM_POSITIONS.size() == 0) {
            return;
        }
        context.world().method_16107().method_15405("whereisit_highlights");
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        class_4587 stack = RenderSystem.getModelViewStack();
        stack.method_22903();
        stack.method_22905(0.998f, 0.998f, 0.998f);
        stack.method_22907(new class_1158(class_1160.field_20703, camera.method_19329(), true));
        stack.method_22907(new class_1158(class_1160.field_20705, camera.method_19330() + 180.0f, true));
        RenderSystem.applyModelViewMatrix();
        for (Map.Entry<class_2338, PositionData> entry : FOUND_ITEM_POSITIONS.entrySet()) {
            PositionData positionData = entry.getValue();
            ((RenderLocation)RENDER_LOCATION_EVENT.invoker()).renderLocation(context, simpleRendering, positionData);
            long timeDiff = context.world().method_8510() - positionData.time;
            float a = (float)((long)WhereIsIt.CONFIG.getFadeoutTime() - timeDiff) / (float)WhereIsIt.CONFIG.getFadeoutTime() * 0.6f;
            class_243 finalPos = cameraPos.method_1023((double)positionData.pos.method_10263(), (double)positionData.pos.method_10264(), (double)positionData.pos.method_10260()).method_22882();
            if (finalPos.method_1027() > 4096.0) {
                finalPos = finalPos.method_1029().method_1021(64.0);
            }
            RenderSystem.disableDepthTest();
            if (!simpleRendering.booleanValue()) {
                RenderSystem.enableDepthTest();
                buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
                RenderUtils.drawShape(buffer, positionData.shape, finalPos.field_1352, finalPos.field_1351, finalPos.field_1350, positionData.r, positionData.g, positionData.b, a);
                tessellator.method_1350();
                RenderSystem.disableDepthTest();
            }
            RenderSystem.depthFunc((int)519);
            buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
            RenderUtils.drawShape(buffer, positionData.shape, finalPos.field_1352, finalPos.field_1351, finalPos.field_1350, positionData.r, positionData.g, positionData.b, simpleRendering != false ? a : a * 0.8f);
            tessellator.method_1350();
            RenderSystem.depthFunc((int)515);
            if (timeDiff < (long)WhereIsIt.CONFIG.getFadeoutTime()) continue;
            toRemove.add(entry.getKey());
        }
        stack.method_22909();
        RenderSystem.applyModelViewMatrix();
        ListIterator<class_2338> iter = toRemove.listIterator();
        while (iter.hasNext()) {
            FOUND_ITEM_POSITIONS.remove(iter.next());
            iter.remove();
        }
    }

    private static void drawShape(class_287 buffer, class_265 shape, double x, double y, double z, float r, float g, float b, float a) {
        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            double lowX = x1 + x;
            double lowY = y1 + y;
            double lowZ = z1 + z;
            double highX = x2 + x;
            double highY = y2 + y;
            double highZ = z2 + z;
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, highZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, lowY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(lowX, highY, lowZ).method_22915(r, g, b, a).method_1344();
            buffer.method_22912(highX, highY, lowZ).method_22915(r, g, b, a).method_1344();
        });
    }

    public static void drawLastSlot(class_4587 matrixStack, class_437 screen) {
        if (WhereIsIt.CONFIG.disableSlotHighlight() || lastSearchedItem == null || lastSearchTime == -1L) {
            return;
        }
        if (screen instanceof class_465) {
            class_465 handledScreen = (class_465)screen;
            handledScreen.method_17577().field_7761.forEach(slot -> {
                class_1799 stack = slot.method_7677();
                if (slot.method_7681() && Searcher.areStacksEqual(stack.method_7909(), stack.method_7969(), lastSearchedItem, lastSearchedTag, lastSearchedIgnoreNbt)) {
                    int x = slot.field_7873 + ((AccessorHandledScreen)screen).getX();
                    int y = slot.field_7872 + ((AccessorHandledScreen)screen).getY();
                    int colour = -2130706688;
                    RenderSystem.disableDepthTest();
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    ((AccessorDrawableHelper)screen).whereisit$fillGradient(matrixStack, x - 2, y - 2, x, y + 18, -2130706688, -2130706688);
                    ((AccessorDrawableHelper)screen).whereisit$fillGradient(matrixStack, x + 16, y - 2, x + 18, y + 18, -2130706688, -2130706688);
                    ((AccessorDrawableHelper)screen).whereisit$fillGradient(matrixStack, x, y - 2, x + 16, y, -2130706688, -2130706688);
                    ((AccessorDrawableHelper)screen).whereisit$fillGradient(matrixStack, x, y + 16, x + 16, y + 18, -2130706688, -2130706688);
                    RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    RenderSystem.enableDepthTest();
                }
            });
        }
    }

    public static void drawTextWithBackground(WorldRenderContext context, class_243 pos, class_2561 text, int maxDistance, boolean seeThrough) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_243 finalPos = pos.method_1020(context.camera().method_19326()).method_1031(0.5, 0.5, 0.5);
        float textScale = (float)WhereIsIt.CONFIG.getTextSizeModifier() / 100.0f;
        if (finalPos.method_1027() <= (double)(maxDistance * maxDistance)) {
            class_4587 matrices = context.matrixStack();
            matrices.method_22903();
            matrices.method_22904(finalPos.field_1352, finalPos.field_1351, finalPos.field_1350);
            matrices.method_22907(dispatcher.method_24197());
            matrices.method_22905(-0.025f * textScale, -0.025f * textScale, 0.025f * textScale);
            class_1159 matrix4f = matrices.method_23760().method_23761();
            int backgroundColour = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
            class_327 textRenderer = class_310.method_1551().field_1772;
            float xOffset = -textRenderer.method_27525((class_5348)text) / 2;
            textRenderer.method_30882(text, xOffset, 0.0f, 0x20FFFFFF, false, matrix4f, context.consumers(), true, backgroundColour, 0xF000F0);
            textRenderer.method_30882(text, xOffset, 0.0f, -1, false, matrix4f, context.consumers(), seeThrough, 0, 0xF000F0);
            matrices.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static class_1160 hueToColour(float hue) {
        hue = (hue % 360.0f + 360.0f) % 360.0f;
        float factor = 1.0f - Math.abs(class_3532.method_15341((float)(hue / 60.0f), (float)2.0f) - 1.0f);
        switch ((int)(hue / 60.0f)) {
            case 0: {
                return new class_1160(1.0f, factor, 0.0f);
            }
            case 1: {
                return new class_1160(factor, 1.0f, 0.0f);
            }
            case 2: {
                return new class_1160(0.0f, 1.0f, factor);
            }
            case 3: {
                return new class_1160(0.0f, factor, 1.0f);
            }
            case 4: {
                return new class_1160(factor, 0.0f, 1.0f);
            }
            case 5: {
                return new class_1160(1.0f, 0.0f, factor);
            }
        }
        throw new RuntimeException("Exhausted switch statement?");
    }

    @FunctionalInterface
    public static interface RenderLocation {
        public void renderLocation(WorldRenderContext var1, Boolean var2, PositionData var3);
    }
}

