/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import org.jetbrains.annotations.Nullable;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.utilities.FoundType;

@Environment(value=EnvType.CLIENT)
public class PositionData {
    public final class_2338 pos;
    public final long time;
    public final class_265 shape;
    public float r;
    public float g;
    public float b;
    private List<class_2561> texts = null;

    public PositionData(class_2338 pos, long time, class_265 shape, float r, float g, float b, @Nullable class_2561 initialName) {
        this.pos = pos;
        this.time = time;
        this.shape = shape;
        this.r = r;
        this.g = g;
        this.b = b;
        if (initialName != null) {
            this.assertTextList();
            this.addText(initialName);
        }
    }

    public static PositionData from(class_2338 pos, long time, class_265 shape, FoundType type, @Nullable class_2561 name) {
        if (type == FoundType.FOUND_DEEP) {
            return new PositionData(pos, time, shape, (float)(WhereIsIt.CONFIG.getAlternateColour() >> 16 & 0xFF) / 255.0f, (float)(WhereIsIt.CONFIG.getAlternateColour() >> 8 & 0xFF) / 255.0f, (float)(WhereIsIt.CONFIG.getAlternateColour() & 0xFF) / 255.0f, name);
        }
        return new PositionData(pos, time, shape, (float)(WhereIsIt.CONFIG.getColour() >> 16 & 0xFF) / 255.0f, (float)(WhereIsIt.CONFIG.getColour() >> 8 & 0xFF) / 255.0f, (float)(WhereIsIt.CONFIG.getColour() & 0xFF) / 255.0f, name);
    }

    private void assertTextList() {
        if (this.texts == null) {
            this.texts = new ArrayList<class_2561>();
        }
    }

    public List<class_2561> getAllText() {
        return this.texts == null ? Collections.emptyList() : this.texts;
    }

    public void removeText(int index) {
        if (this.texts != null) {
            this.texts.remove(index);
        }
    }

    public void setText(int index, class_2561 text) {
        this.assertTextList();
        this.texts.set(index, text);
    }

    public void addText(int index, class_2561 text) {
        this.assertTextList();
        this.texts.add(index, text);
    }

    public void addText(class_2561 text) {
        this.assertTextList();
        this.texts.add(text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionData that = (PositionData)o;
        return Objects.equals(this.pos, that.pos);
    }

    public int hashCode() {
        return Objects.hash(this.pos);
    }
}

