/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.client.events.v0.ClothClientHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.client.ItemSearchCallback;
import red.jackf.whereisit.client.PositionData;
import red.jackf.whereisit.client.RenderUtils;
import red.jackf.whereisit.compat.OptifineHooks;
import red.jackf.whereisit.network.FoundS2C;
import red.jackf.whereisit.network.SearchC2S;
import red.jackf.whereisit.utilities.FoundType;
import red.jackf.whereisit.utilities.SearchResult;

@Environment(value=EnvType.CLIENT)
public class WhereIsItClient
implements ClientModInitializer {
    public static final class_304 FIND_ITEMS = new class_304("key.whereisit.finditem", class_3675.class_307.field_1668, 89, "key.categories.whereisit");
    public static final Event<ItemSearchCallback> SEARCH_FOR_ITEM = EventFactory.createArrayBacked(ItemSearchCallback.class, listeners -> (item, matchNbt, tag) -> {
        for (ItemSearchCallback callback : listeners) {
            callback.searchForItem(item, matchNbt, tag);
        }
    });

    public static void searchForItem(@NotNull class_1792 item, boolean matchNbt, class_2487 tag) {
        ((ItemSearchCallback)SEARCH_FOR_ITEM.invoker()).searchForItem(item, matchNbt, tag);
        RenderUtils.setLastSearch(item, matchNbt, tag);
    }

    public static void handleFoundItems(Collection<PositionData> results) {
        for (PositionData result : results) {
            RenderUtils.FOUND_ITEM_POSITIONS.put(result.pos, result);
        }
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)FIND_ITEMS);
        SEARCH_FOR_ITEM.register((item, matchNbt, tag) -> ClientPlayNetworking.send((class_2960)SearchC2S.ID, (class_2540)new SearchC2S(item, matchNbt, tag, WhereIsIt.CONFIG.getMaximumResults() == 0 ? Integer.MAX_VALUE : WhereIsIt.CONFIG.getMaximumResults())));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FoundS2C.ID, (client, handler, buf, responseSender) -> {
            Map<class_2338, SearchResult> results = FoundS2C.read(buf);
            client.execute(() -> {
                class_638 world = handler.method_2890();
                List<PositionData> found = results.entrySet().stream().map(arg_0 -> WhereIsItClient.lambda$onInitializeClient$4((class_1937)world, arg_0)).collect(Collectors.toList());
                WhereIsItClient.handleFoundItems(found);
            });
        });
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            OptifineHooks.doOptifineAwareRender(context, (context1, simple) -> {
                RenderUtils.renderHighlights(context1, simple != false || WhereIsIt.CONFIG.forceSimpleRender());
                if (WhereIsIt.CONFIG.shouldShowResultLabels()) {
                    RenderUtils.renderTexts(context1, simple != false || WhereIsIt.CONFIG.forceSimpleRender());
                }
            });
            return true;
        });
        ClothClientHooks.SCREEN_LATE_RENDER.register((stack, client, screen, x, y, tickDelta) -> RenderUtils.drawLastSlot(stack, screen));
        RenderUtils.RENDER_LOCATION_EVENT.register((context, simpleRendering, positionData) -> {
            if (!WhereIsIt.CONFIG.isRainbowMode()) {
                return;
            }
            class_1160 colour = RenderUtils.hueToColour(3L * context.world().method_8510() + (long)(positionData.pos.method_10263() + positionData.pos.method_10264() + positionData.pos.method_10260()) * 8L);
            positionData.r = colour.method_4943();
            positionData.g = colour.method_4945();
            positionData.b = colour.method_4947();
        });
    }

    private static /* synthetic */ PositionData lambda$onInitializeClient$4(class_1937 world, Map.Entry entry) {
        class_2338 pos = (class_2338)entry.getKey();
        FoundType type = ((SearchResult)entry.getValue()).foundType();
        class_2561 name = ((SearchResult)entry.getValue()).name();
        return PositionData.from(pos, world.method_8510(), world.method_8320(pos).method_26218((class_1922)world, pos), type, name);
    }

    static {
        SEARCH_FOR_ITEM.register((item, matchNbt, tag) -> RenderUtils.clearSearch());
    }
}

