/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1278;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3715;
import net.minecraft.class_3722;
import net.minecraft.class_3954;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.utilities.FoundType;
import red.jackf.whereisit.utilities.SearchResult;

public abstract class Searcher {
    public static Map<class_2338, SearchResult> searchWorld(class_2338 playerPos, class_3218 world, class_1792 toFind, class_2487 toFindTag, int maximumCount) {
        HashMap<class_2338, SearchResult> positions = new HashMap<class_2338, SearchResult>();
        int radius = WhereIsIt.CONFIG.getSearchRadius();
        int checkedBECount = 0;
        int minChunkX = -radius + playerPos.method_10263() >> 4;
        int maxChunkX = radius + 1 + playerPos.method_10263() >> 4;
        int minChunkZ = -radius + playerPos.method_10260() >> 4;
        int maxChunkZ = radius + 1 + playerPos.method_10260() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                class_2818 chunk = world.method_8497(chunkX, chunkZ);
                if (chunk == null) continue;
                checkedBECount += chunk.method_12214().size();
                for (Map.Entry entry : chunk.method_12214().entrySet()) {
                    class_1278 inv;
                    class_1275 name;
                    class_2338 pos = (class_2338)entry.getKey();
                    class_2586 be = (class_2586)entry.getValue();
                    if (!pos.method_19771((class_2382)playerPos, (double)radius)) continue;
                    class_2680 state = chunk.method_8320(pos);
                    FoundType foundType = FoundType.NOT_FOUND;
                    class_2561 invName = null;
                    if (be instanceof class_1275 && (name = (class_1275)be).method_16914()) {
                        invName = name.method_5797();
                    }
                    if (state.method_26204() instanceof class_3715 && ((Boolean)state.method_11654((class_2769)class_3715.field_17366)).booleanValue()) {
                        foundType = Searcher.searchItemStack(((class_3722)be).method_17520(), toFind, toFindTag, true);
                    } else if (be instanceof class_1263) {
                        foundType = Searcher.invContains((class_1263)be, toFind, toFindTag, true);
                    } else if (state.method_26204() instanceof class_3954 && (inv = ((class_3954)state.method_26204()).method_17680(state, (class_1936)world, pos)) != null) {
                        foundType = Searcher.invContains((class_1263)inv, toFind, toFindTag, true);
                    }
                    if (foundType == FoundType.NOT_FOUND) continue;
                    positions.put(pos.method_10062(), new SearchResult(foundType, invName));
                }
            }
        }
        if (WhereIsIt.CONFIG.printSearchTime()) {
            WhereIsIt.log("Checked " + checkedBECount + " BlockEntities");
        }
        if (positions.size() > maximumCount) {
            return positions.entrySet().stream().sorted((e1, e2) -> {
                double e1distance = ((class_2338)e1.getKey()).method_33106((class_2382)playerPos, false);
                double e2distance = ((class_2338)e2.getKey()).method_33106((class_2382)playerPos, false);
                return Double.compare(e1distance, e2distance);
            }).limit(maximumCount).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (result1, result2) -> result1, LinkedHashMap::new));
        }
        return positions;
    }

    public static FoundType searchItemStack(class_1799 itemStack, class_1792 toFind, class_2487 toFindTag, boolean deepSearch) {
        class_2487 tag;
        if (itemStack.method_7909() == toFind && (toFindTag == null || toFindTag.equals((Object)itemStack.method_7969()))) {
            return FoundType.FOUND;
        }
        if (!itemStack.method_7960() && WhereIsIt.CONFIG.doDeepSearch() && deepSearch && itemStack.method_7909() instanceof class_1747 && ((class_1747)itemStack.method_7909()).method_7711() instanceof class_2480 && (tag = itemStack.method_7941("BlockEntityTag")) != null && tag.method_10573("Items", 9)) {
            class_2499 items = tag.method_10554("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                class_1799 containedStack = class_1799.method_7915((class_2487)items.method_10602(i));
                if (containedStack.method_7909() != toFind || toFindTag != null && !toFindTag.equals((Object)containedStack.method_7969())) continue;
                return FoundType.FOUND_DEEP;
            }
        }
        return FoundType.NOT_FOUND;
    }

    public static FoundType invContains(class_1263 inv, class_1792 searchingFor, class_2487 searchingForNbt, boolean deepSearch) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            FoundType result = Searcher.searchItemStack(inv.method_5438(i), searchingFor, searchingForNbt, deepSearch);
            if (result == FoundType.NOT_FOUND) continue;
            return result;
        }
        return FoundType.NOT_FOUND;
    }

    public static boolean areStacksEqual(class_1792 item1, class_2487 tag1, class_1792 item2, class_2487 tag2, boolean ignoreNbt) {
        return Objects.equals(item1, item2) && (ignoreNbt || Objects.equals(tag1, tag2));
    }
}

