/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.biome;

import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5281;
import net.minecraft.class_5470;
import net.minecraft.class_6686;
import ru.bclib.api.biomes.BCLBiomeBuilder;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.surface.SurfaceRuleBuilder;
import ru.bclib.interfaces.SurfaceMaterialProvider;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.biomes.BCLBiomeSettings;
import ru.betterend.BetterEnd;
import ru.betterend.interfaces.StructureFeaturesAccessor;
import ru.betterend.registry.EndBlocks;
import ru.betterend.registry.EndFeatures;
import ru.betterend.registry.EndSounds;

public class EndBiome
extends BCLBiome
implements SurfaceMaterialProvider {
    private SurfaceMaterialProvider surfMatProv = Config.DEFAULT_MATERIAL;

    public EndBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    public static EndBiome create(Config biomeConfig) {
        BCLBiomeBuilder builder = BCLBiomeBuilder.start((class_2960)biomeConfig.ID).category(class_1959.class_1961.field_9360).music(class_3417.field_14631).waterColor(4159204).waterFogColor(329011).fogColor(0xA080A0).skyColor(0).mood(EndSounds.AMBIENT_DUST_WASTELANDS).temperature(0.5f).wetness(0.5f).precipitation(class_1959.class_1963.field_9384).surface(biomeConfig.surfaceMaterial().surface().build());
        biomeConfig.addCustomBuildData(builder);
        EndFeatures.addDefaultFeatures(builder, biomeConfig.hasCaves());
        EndBiome biome = (EndBiome)builder.build(biomeConfig.getSupplier());
        biome.addCustomData("has_caves", biomeConfig.hasCaves());
        biome.setSurfaceMaterial(biomeConfig.surfaceMaterial());
        return biome;
    }

    private void setSurfaceMaterial(SurfaceMaterialProvider prov) {
        this.surfMatProv = prov;
    }

    public class_2680 getTopMaterial() {
        return this.surfMatProv.getTopMaterial();
    }

    public class_2680 getUnderMaterial() {
        return this.surfMatProv.getUnderMaterial();
    }

    public class_2680 getAltTopMaterial() {
        return this.surfMatProv.getAltTopMaterial();
    }

    public boolean generateFloorRule() {
        return this.surfMatProv.generateFloorRule();
    }

    public SurfaceRuleBuilder surface() {
        return this.surfMatProv.surface();
    }

    public static class_2680 findTopMaterial(BCLBiome biome) {
        return BiomeAPI.findTopMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static class_2680 findTopMaterial(class_1959 biome) {
        return EndBiome.findTopMaterial(BiomeAPI.getBiome((class_1959)biome));
    }

    public static class_2680 findTopMaterial(class_5281 world, class_2338 pos) {
        return EndBiome.findTopMaterial(BiomeAPI.getBiome((class_1959)world.method_23753(pos)));
    }

    public static class_2680 findUnderMaterial(BCLBiome biome) {
        return BiomeAPI.findUnderMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static class_2680 findUnderMaterial(class_5281 world, class_2338 pos) {
        return EndBiome.findUnderMaterial(BiomeAPI.getBiome((class_1959)world.method_23753(pos)));
    }

    public static abstract class Config {
        public static final SurfaceMaterialProvider DEFAULT_MATERIAL = new DefaultSurfaceMaterialProvider();
        protected static final StructureFeaturesAccessor VANILLA_FEATURES = (StructureFeaturesAccessor)new class_5470();
        protected static final class_6686.class_6708 END_STONE = class_6686.method_39047((class_2680)DefaultSurfaceMaterialProvider.END_STONE);
        protected static final class_6686.class_6708 END_MOSS = class_6686.method_39047((class_2680)EndBlocks.END_MOSS.method_9564());
        protected static final class_6686.class_6708 ENDSTONE_DUST = class_6686.method_39047((class_2680)EndBlocks.ENDSTONE_DUST.method_9564());
        protected static final class_6686.class_6708 END_MYCELIUM = class_6686.method_39047((class_2680)EndBlocks.END_MYCELIUM.method_9564());
        protected static final class_6686.class_6708 FLAVOLITE = class_6686.method_39047((class_2680)EndBlocks.FLAVOLITE.stone.method_9564());
        protected static final class_6686.class_6708 SULPHURIC_ROCK = class_6686.method_39047((class_2680)EndBlocks.SULPHURIC_ROCK.stone.method_9564());
        protected static final class_6686.class_6708 BRIMSTONE = class_6686.method_39047((class_2680)EndBlocks.BRIMSTONE.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_FULL = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_FULL.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_HEAVY = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_HEAVY.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_THIN = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_THIN.method_9564());
        protected static final class_6686.class_6708 PALLIDIUM_TINY = class_6686.method_39047((class_2680)EndBlocks.PALLIDIUM_TINY.method_9564());
        protected static final class_6686.class_6708 UMBRALITH = class_6686.method_39047((class_2680)EndBlocks.UMBRALITH.stone.method_9564());
        public final class_2960 ID;

        protected Config(String name) {
            this.ID = BetterEnd.makeID(name);
        }

        protected abstract void addCustomBuildData(BCLBiomeBuilder var1);

        public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
            return EndBiome::new;
        }

        protected boolean hasCaves() {
            return true;
        }

        protected SurfaceMaterialProvider surfaceMaterial() {
            return DEFAULT_MATERIAL;
        }
    }

    public static class DefaultSurfaceMaterialProvider
    implements SurfaceMaterialProvider {
        public static final class_2680 END_STONE = class_2246.field_10471.method_9564();

        public class_2680 getTopMaterial() {
            return this.getUnderMaterial();
        }

        public class_2680 getAltTopMaterial() {
            return this.getTopMaterial();
        }

        public class_2680 getUnderMaterial() {
            return END_STONE;
        }

        public boolean generateFloorRule() {
            return true;
        }

        public SurfaceRuleBuilder surface() {
            SurfaceRuleBuilder builder = SurfaceRuleBuilder.start();
            if (this.generateFloorRule() && this.getTopMaterial() != this.getUnderMaterial()) {
                if (this.getTopMaterial() != this.getAltTopMaterial()) {
                    builder.floor(this.getTopMaterial());
                } else {
                    builder.chancedFloor(this.getTopMaterial(), this.getAltTopMaterial());
                }
            }
            return builder.filler(this.getUnderMaterial());
        }
    }
}

