/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.statuseffects;

import java.awt.Color;
import lekavar.lma.drinkbeer.DrinkBeer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_4081;

public class DrunkStatusEffect
extends class_1291 {
    public static final int MAX_DRUNK_AMPLIFIER = 4;
    public static final int MIN_DRUNK_AMPLIFIER = 0;
    private static final int BASE_DURATION = 1200;
    private static final boolean visible = false;
    private static final int[] drunkDurations = new int[]{3600, 3000, 2400, 1800, 1200};
    private static final int[] nauseaDurations = new int[]{160, 160, 200, 300, 600};
    private static final int[] slownessDurations = new int[]{0, 80, 160, 200, 600};
    private static final int[] harmulStatusEffectsIntervals = new int[]{200, 160, 200, 300, 20};

    public DrunkStatusEffect() {
        super(class_4081.field_18272, new Color(255, 222, 173, 255).getRGB());
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }

    public static void addStatusEffect(class_1309 user, int value) {
        if (value == 0) {
            return;
        }
        class_1293 statusEffectInstance = user.method_6112(DrinkBeer.DRUNK);
        int currentDrunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.method_5578();
        int newDrunkAmplifier = currentDrunkAmplifier + value;
        newDrunkAmplifier = Math.min(newDrunkAmplifier, 4);
        if (currentDrunkAmplifier < 0 && newDrunkAmplifier < 0) {
            return;
        }
        if (currentDrunkAmplifier >= 0 && newDrunkAmplifier < 0) {
            user.method_6016(DrinkBeer.DRUNK);
        } else if (currentDrunkAmplifier < 0) {
            user.method_6092(new class_1293(DrinkBeer.DRUNK, DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier > currentDrunkAmplifier) {
            user.method_6092(new class_1293(DrinkBeer.DRUNK, DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier < currentDrunkAmplifier) {
            for (int tempDrunkAmplifier = currentDrunkAmplifier - newDrunkAmplifier; tempDrunkAmplifier > 0; --tempDrunkAmplifier) {
                DrunkStatusEffect.decreaseDrunkStatusEffefct(user, currentDrunkAmplifier);
                --currentDrunkAmplifier;
            }
        }
    }

    public static void addStatusEffect(class_1309 user) {
        DrunkStatusEffect.addStatusEffect(user, 1);
    }

    public void method_5572(class_1309 entity, int amplifier) {
        int time = entity.method_6112(DrinkBeer.DRUNK).method_5584();
        this.giveHarmfulStatusEffects(entity, amplifier, time);
        if (time == 1) {
            DrunkStatusEffect.decreaseDrunkStatusEffefct(entity, amplifier);
        }
    }

    private void giveHarmfulStatusEffects(class_1309 entity, int amplifier, int time) {
        if (amplifier >= 4) {
            int duration = entity.method_6112(DrinkBeer.DRUNK).method_5584();
            entity.method_6092(new class_1293(class_1294.field_5916, duration, 0, false, false));
            entity.method_6092(new class_1293(class_1294.field_5909, duration, 3, false, false));
        } else if (time % harmulStatusEffectsIntervals[amplifier] == 0) {
            int nauseaDuration = nauseaDurations[amplifier];
            int slownessDuration = slownessDurations[amplifier];
            entity.method_6092(new class_1293(class_1294.field_5916, nauseaDuration, 0, false, false));
            if (amplifier > 0) {
                entity.method_6092(new class_1293(class_1294.field_5909, slownessDuration, amplifier - 1, false, false));
            }
        }
    }

    private static void decreaseDrunkStatusEffefct(class_1309 entity, int amplifier) {
        if (!entity.method_5770().method_8608()) {
            entity.method_6016(DrinkBeer.DRUNK);
            class_1293 nextDrunkStatusEffect = DrunkStatusEffect.getDecreasedDrunkStatusEffect(amplifier);
            if (nextDrunkStatusEffect != null) {
                entity.method_6092(nextDrunkStatusEffect);
            }
        }
    }

    private static class_1293 getDecreasedDrunkStatusEffect(int currentAmplifier) {
        int nextDrunkAmplifier = currentAmplifier - 1;
        if (nextDrunkAmplifier < 0) {
            return null;
        }
        return new class_1293(DrinkBeer.DRUNK, DrunkStatusEffect.getDrunkDuratioin(nextDrunkAmplifier), nextDrunkAmplifier);
    }

    public static int getNextDrunkAmplifier(class_1309 user) {
        class_1293 statusEffectInstance = user.method_6112(DrinkBeer.DRUNK);
        int drunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.method_5578();
        return drunkAmplifier < 4 ? drunkAmplifier + 1 : drunkAmplifier;
    }

    public static int getDrunkDuratioin(int amplifier) {
        try {
            return drunkDurations[amplifier];
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Amplifier is out of range");
            return 1200;
        }
    }
}

