/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.manager.BeerRecipeManager;
import lekavar.lma.drinkbeer.util.beer.BeerRecipe;
import lekavar.lma.drinkbeer.util.beer.Beers;
import lekavar.lma.drinkbeer.util.beer.BrewingLeftover;
import lekavar.lma.drinkbeer.util.beer.BrewingMaterial;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;

public class BeerBarrelScreenHandler
extends class_1703 {
    private final class_1263 input;
    private final class_1263 output;
    private List<class_1799> getBackResultList;
    private final class_1735 materialSlot1;
    private final class_1735 materialSlot2;
    private final class_1735 materialSlot3;
    private final class_1735 materialSlot4;
    private final class_1735 emptyMugSlot;
    private final class_1735 resultSlot;
    class_3913 propertyDelegate;
    BeerRecipe beerRecipe = null;
    private final class_3914 context;
    private Runnable inventoryChangeListener;
    private class_1657 player;

    public BeerBarrelScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public BeerBarrelScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        this(syncId, playerInventory, context, (class_3913)new class_3919(5));
    }

    public BeerBarrelScreenHandler(int syncId, class_1661 playerInventory, class_3914 context, class_3913 propertyDelegate) {
        super(DrinkBeer.BEER_BARREL_SCREEN_HANDLER, syncId);
        int m;
        this.propertyDelegate = propertyDelegate;
        this.method_17360(propertyDelegate);
        this.input = new class_1277(5){

            public void method_5431() {
                super.method_5431();
                BeerBarrelScreenHandler.this.method_7609((class_1263)this);
                BeerBarrelScreenHandler.this.inventoryChangeListener.run();
            }
        };
        this.output = new class_1277(1){

            public void method_5431() {
                super.method_5431();
                BeerBarrelScreenHandler.this.inventoryChangeListener.run();
            }
        };
        this.inventoryChangeListener = () -> {};
        this.context = context;
        this.player = playerInventory.field_7546;
        this.materialSlot1 = this.method_7621(new class_1735(this.input, 0, 28, 26){

            public boolean method_7680(class_1799 stack) {
                return BeerBarrelScreenHandler.this.canInsertMaterialSlot(stack);
            }
        });
        this.materialSlot2 = this.method_7621(new class_1735(this.input, 1, 46, 26){

            public boolean method_7680(class_1799 stack) {
                return BeerBarrelScreenHandler.this.canInsertMaterialSlot(stack);
            }
        });
        this.materialSlot3 = this.method_7621(new class_1735(this.input, 2, 28, 44){

            public boolean method_7680(class_1799 stack) {
                return BeerBarrelScreenHandler.this.canInsertMaterialSlot(stack);
            }
        });
        this.materialSlot4 = this.method_7621(new class_1735(this.input, 3, 46, 44){

            public boolean method_7680(class_1799 stack) {
                return BeerBarrelScreenHandler.this.canInsertMaterialSlot(stack);
            }
        });
        this.emptyMugSlot = this.method_7621(new class_1735(this.input, 4, 73, 50){

            public boolean method_7680(class_1799 stack) {
                return BeerBarrelScreenHandler.this.canInsertEmptyMugSlot(stack);
            }
        });
        this.resultSlot = this.method_7621(new class_1735(this.output, 0, 128, 34){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return BeerBarrelScreenHandler.this.canTakeItemsResultSlot();
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                BeerBarrelScreenHandler.this.playPouringSound(player, stack);
                BeerBarrelScreenHandler.this.resetBeerBarrel();
                super.method_7667(player, stack);
            }
        });
        if (this.getBeerId() != 0) {
            Beers beer = Beers.byId(this.getBeerId());
            class_1799 resultItemStack = new class_1799((class_1935)beer.getBeerItem(), this.getBeerResultNum());
            this.resultSlot.method_7673(resultItemStack);
        }
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.method_7621(new class_1735((class_1263)playerInventory, m, 8 + m * 18, 142));
        }
    }

    public void resetBeerBarrel() {
        this.setIsMaterialCompleted(false);
        this.setBeerId(0);
        this.setIsBrewing(false);
        this.setBeerResultNum(0);
    }

    public void startBrewing(BeerRecipe beerRecipe) {
        this.setRemainingBrewingTime(beerRecipe.getBrewingTime());
        this.setBeerId(Beers.byItem(beerRecipe.getBeerResult()).getId());
        this.setIsBrewing(true);
        this.setBeerResultNum(beerRecipe.getBeerResultNum());
    }

    public boolean isBrewing() {
        return this.getIsBrewing() == 1;
    }

    public boolean isBrewingTimeRemain() {
        return this.getRemainingBrewingTime() > 0;
    }

    public boolean isMaterialCompleted() {
        return this.getIsMaterialCompleted() != 0;
    }

    public List<class_1799> getBackResult() {
        HashMap<class_1792, Integer> inputMaterialMap = new HashMap<class_1792, Integer>();
        this.getInputMaterialMap(inputMaterialMap);
        ArrayList<class_1799> getBackResultList = new ArrayList<class_1799>();
        List<BrewingLeftover> brewingLeftoverList = BrewingLeftover.getBrewingLeftoverList();
        for (BrewingLeftover brewingLeftover : brewingLeftoverList) {
            if (!inputMaterialMap.containsKey(brewingLeftover.getOriItem())) continue;
            class_1799 itemStackWaterBucket = new class_1799((class_1935)brewingLeftover.getBrewingLeftOverItem(), ((Integer)inputMaterialMap.get(brewingLeftover.getOriItem())).intValue());
            getBackResultList.add(itemStackWaterBucket);
        }
        return getBackResultList;
    }

    private void getInputMaterialMap(Map<class_1792, Integer> inputMaterial) {
        class_1792 materialItem1 = this.materialSlot1.method_7677().method_7909();
        class_1792 materialItem2 = this.materialSlot2.method_7677().method_7909();
        class_1792 materialItem3 = this.materialSlot3.method_7677().method_7909();
        class_1792 materialItem4 = this.materialSlot4.method_7677().method_7909();
        inputMaterial.put(materialItem1, 1);
        if (inputMaterial.containsKey(materialItem2)) {
            inputMaterial.put(materialItem2, inputMaterial.get(materialItem2) + 1);
        } else {
            inputMaterial.put(materialItem2, 1);
        }
        if (inputMaterial.containsKey(materialItem3)) {
            inputMaterial.put(materialItem3, inputMaterial.get(materialItem3) + 1);
        } else {
            inputMaterial.put(materialItem3, 1);
        }
        if (inputMaterial.containsKey(materialItem4)) {
            inputMaterial.put(materialItem4, inputMaterial.get(materialItem4) + 1);
        } else {
            inputMaterial.put(materialItem4, 1);
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.input.method_5443(player);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.input.method_5439() ? !this.method_7616(originalStack, this.input.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.input.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public void updateResultSlot() {
        if (this.isBrewing()) {
            return;
        }
        this.setIsMaterialCompleted(false);
        this.resultSlot.method_7673(class_1799.field_8037);
        HashMap<class_1792, Integer> inputMaterialMap = new HashMap<class_1792, Integer>();
        this.getInputMaterialMap(inputMaterialMap);
        this.beerRecipe = this.getBeerRecipeResult(inputMaterialMap);
        if (this.beerRecipe != null) {
            this.resultSlot.method_7673(new class_1799((class_1935)this.beerRecipe.getBeerResult(), this.beerRecipe.getBeerResultNum()));
            this.setIsMaterialCompleted(true);
            int requiredEmptyMugNum = this.beerRecipe.getBeerResultNum();
            class_1799 emptyMugItemStack = this.emptyMugSlot.method_7677();
            if (emptyMugItemStack.method_7947() >= requiredEmptyMugNum) {
                this.startBrewing(this.beerRecipe);
                this.getBackResultList = this.getBackResult();
                this.materialSlot1.method_7671(1);
                this.materialSlot2.method_7671(1);
                this.materialSlot3.method_7671(1);
                this.materialSlot4.method_7671(1);
                this.emptyMugSlot.method_7671(requiredEmptyMugNum);
                this.resultSlot.method_7668();
            }
        }
    }

    public int getCurrentBrewingTime() {
        return this.beerRecipe != null ? this.beerRecipe.getBrewingTime() : 0;
    }

    private BeerRecipe getBeerRecipeResult(Map<class_1792, Integer> inputMaterialMap) {
        return BeerRecipeManager.matchBeerRecipe(inputMaterialMap, this.player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!player.field_6002.field_9236) {
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (this.isMaterialCompleted() && !this.isBrewing()) {
            this.setIsMaterialCompleted(false);
            this.resultSlot.method_7668();
        }
        this.context.method_17393((world, blockPos) -> {
            this.method_7607(player, this.input);
            if (this.getBackResultList != null && this.getBackResultList.size() > 0) {
                class_1277 getBackInventory = new class_1277(this.getBackResultList.size());
                for (int i = 0; i < this.getBackResultList.size(); ++i) {
                    getBackInventory.method_5447(i, this.getBackResultList.get(i));
                }
                this.method_7607(player, (class_1263)getBackInventory);
            }
        });
    }

    public int getRemainingBrewingTime() {
        return this.propertyDelegate.method_17390(0);
    }

    private int getIsMaterialCompleted() {
        return this.propertyDelegate.method_17390(1);
    }

    private int getBeerId() {
        return this.propertyDelegate.method_17390(2);
    }

    private int getIsBrewing() {
        return this.propertyDelegate.method_17390(3);
    }

    private int getBeerResultNum() {
        return this.propertyDelegate.method_17390(4);
    }

    private void setRemainingBrewingTime(int remainingBrewingTime) {
        this.propertyDelegate.method_17391(0, remainingBrewingTime);
    }

    private void setIsMaterialCompleted(int isMaterialCompleted) {
        this.propertyDelegate.method_17391(1, isMaterialCompleted);
    }

    private void setIsMaterialCompleted(boolean isMaterialCompleted) {
        this.setIsMaterialCompleted(isMaterialCompleted ? 1 : 0);
    }

    private void setBeerId(int beerId) {
        this.propertyDelegate.method_17391(2, beerId);
    }

    private void setIsBrewing(int isBrewing) {
        this.propertyDelegate.method_17391(3, isBrewing);
    }

    private void setIsBrewing(boolean isBrewing) {
        this.setIsBrewing(isBrewing ? 1 : 0);
    }

    private void setBeerResultNum(int beerResultNum) {
        this.propertyDelegate.method_17391(4, beerResultNum);
    }

    private boolean canInsertMaterialSlot(class_1799 stack) {
        if (!this.isBrewing()) {
            return BrewingMaterial.MATERIAL_LIST.contains(stack.method_7909());
        }
        return false;
    }

    private boolean canInsertEmptyMugSlot(class_1799 stack) {
        return stack.method_7909().method_8389() == DrinkBeer.EMPTY_BEER_MUG.method_8389() && this.isMaterialCompleted() && !this.isBrewing();
    }

    private boolean canTakeItemsResultSlot() {
        return this.isBrewing() && !this.isBrewingTimeRemain();
    }

    private void playPouringSound(class_1657 player, class_1799 stack) {
        if (!player.field_6002.field_9236) {
            if (stack.method_7909().equals(DrinkBeer.BEER_MUG_FROTHY_PINK_EGGNOG.method_8389())) {
                player.field_6002.method_8396(null, new class_2338(player.method_19538()), DrinkBeer.POURING_CHRISTMAS_EVENT, class_3419.field_15245, 0.6f, 1.0f);
            }
            player.field_6002.method_8396(null, new class_2338(player.method_19538()), DrinkBeer.POURING_EVENT, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void setInventoryChangeListener(Runnable inventoryChangeListener) {
        this.inventoryChangeListener = inventoryChangeListener;
    }

    public void method_7609(class_1263 inventory) {
        this.updateResultSlot();
        this.method_7623();
    }
}

