/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.screen;

import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.DrinkBeer;
import lekavar.lma.drinkbeer.item.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.item.SpiceBlockItem;
import lekavar.lma.drinkbeer.manager.MixedBeerManager;
import lekavar.lma.drinkbeer.util.beer.Beers;
import lekavar.lma.drinkbeer.util.mixedbeer.Spices;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3914;

public class BartendingTableScreenHandler
extends class_1703 {
    private final class_1263 input;
    private final class_1263 output;
    private final class_1735 beerInputSlot;
    private final class_1735 spiceInputSlot1;
    private final class_1735 spiceInputSlot2;
    private final class_1735 spiceInputSlot3;
    private final class_1735 resultSlot;
    private int[] isUsed;
    private final class_3914 context;
    private Runnable inventoryChangeListener = () -> {};

    public BartendingTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public BartendingTableScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        this(syncId, playerInventory, 0, 0, null, context);
    }

    public BartendingTableScreenHandler(int syncId, class_1661 playerInventory, int beerId, int isMixedBeer, List<Integer> spiceList, class_3914 context) {
        super(DrinkBeer.BARTENDING_TABLE_SCREEN_HANDLER, syncId);
        int m;
        this.context = context;
        class_1799 oriBeerItemStack = isMixedBeer == 1 ? MixedBeerManager.genMixedBeerItemStack(beerId, spiceList) : new class_1799((class_1935)Beers.byId(beerId).getBeerItem(), 1);
        this.isUsed = new int[3];
        this.resetIsUsed();
        this.input = new class_1277(4){

            public void method_5431() {
                super.method_5431();
                BartendingTableScreenHandler.this.method_7609((class_1263)this);
                BartendingTableScreenHandler.this.inventoryChangeListener.run();
            }
        };
        this.output = new class_1277(1){

            public void method_5431() {
                super.method_5431();
                BartendingTableScreenHandler.this.inventoryChangeListener.run();
            }
        };
        this.beerInputSlot = this.method_7621(new class_1735(this.input, 0, 27, 34){

            public boolean method_7680(class_1799 stack) {
                return BartendingTableScreenHandler.this.canInsertBeerInputSlot(stack);
            }
        });
        this.beerInputSlot.method_7673(oriBeerItemStack);
        this.spiceInputSlot1 = this.method_7621(new class_1735(this.input, 1, 67, 16){

            public boolean method_7680(class_1799 stack) {
                return BartendingTableScreenHandler.this.canInsertSpiceInputSlots(stack);
            }
        });
        this.spiceInputSlot2 = this.method_7621(new class_1735(this.input, 2, 67, 34){

            public boolean method_7680(class_1799 stack) {
                return BartendingTableScreenHandler.this.canInsertSpiceInputSlots(stack);
            }
        });
        this.spiceInputSlot3 = this.method_7621(new class_1735(this.input, 3, 67, 52){

            public boolean method_7680(class_1799 stack) {
                return BartendingTableScreenHandler.this.canInsertSpiceInputSlots(stack);
            }
        });
        this.resultSlot = this.method_7621(new class_1735(this.output, 0, 128, 34){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                BartendingTableScreenHandler.this.takeInputStack();
            }
        });
        this.resultSlot.method_7673(oriBeerItemStack);
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.method_7621(new class_1735((class_1263)playerInventory, m, 8 + m * 18, 142));
        }
    }

    private boolean canInsertBeerInputSlot(class_1799 stack) {
        try {
            assert (stack.method_7909().method_7859() != null);
            if (stack.method_7909().method_7859().equals(DrinkBeer.DRINK_BEER)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean canInsertSpiceInputSlots(class_1799 stack) {
        if (this.getBeerInputSpiceList().size() + this.getInputSpicesNum() >= 3) {
            return false;
        }
        return stack.method_7909() instanceof SpiceBlockItem;
    }

    private int getInputSpicesNum() {
        int num = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.getSpiceItemStackInSpiceSlot(i).equals(class_1799.field_8037)) continue;
            ++num;
        }
        return num;
    }

    private class_1799 getSpiceItemStackInSpiceSlot(int index) {
        return switch (index) {
            case 0 -> {
                if (this.spiceInputSlot1 == null) {
                    if (this.spiceInputSlot1.method_7677().method_7909().equals(class_1802.field_8162) || this.spiceInputSlot1.method_7677().equals(class_1799.field_8037)) {
                        yield class_1799.field_8037;
                    }
                    yield this.spiceInputSlot1.method_7677();
                }
                yield this.spiceInputSlot1.method_7677();
            }
            case 1 -> {
                if (this.spiceInputSlot2 == null) {
                    if (this.spiceInputSlot2.method_7677().method_7909().equals(class_1802.field_8162) || this.spiceInputSlot2.method_7677().equals(class_1799.field_8037)) {
                        yield class_1799.field_8037;
                    }
                    yield this.spiceInputSlot2.method_7677();
                }
                yield this.spiceInputSlot2.method_7677();
            }
            case 2 -> {
                if (this.spiceInputSlot3 == null) {
                    if (this.spiceInputSlot3.method_7677().method_7909().equals(class_1802.field_8162) || this.spiceInputSlot3.method_7677().equals(class_1799.field_8037)) {
                        yield class_1799.field_8037;
                    }
                    yield this.spiceInputSlot3.method_7677();
                }
                yield this.spiceInputSlot3.method_7677();
            }
            default -> class_1799.field_8037;
        };
    }

    private boolean isMixedBeer() {
        return this.beerInputSlot.method_7677().method_7909() instanceof MixedBeerBlockItem;
    }

    private List<Integer> getBeerInputSpiceList() {
        ArrayList<Integer> inputSpiceList = new ArrayList<Integer>();
        if (this.isMixedBeer()) {
            return MixedBeerManager.getSpiceList(this.beerInputSlot.method_7677());
        }
        return inputSpiceList;
    }

    private int getBeerInputBeerId() {
        if (this.isMixedBeer()) {
            return MixedBeerManager.getBeerId(this.beerInputSlot.method_7677());
        }
        return Beers.byItem(this.beerInputSlot.method_7677().method_7909()).getId();
    }

    public void takeInputStack() {
        this.beerInputSlot.method_7671(1);
        if (this.beerInputSlot.method_7677().method_7909().equals(class_1802.field_8162)) {
            this.beerInputSlot.method_7673(class_1799.field_8037);
        }
        if (this.isUsed[0] == 1) {
            this.spiceInputSlot1.method_7671(1);
            if (this.spiceInputSlot1.method_7677().method_7909().equals(class_1802.field_8162)) {
                this.spiceInputSlot1.method_7673(class_1799.field_8037);
            }
        }
        if (this.isUsed[1] == 1) {
            this.spiceInputSlot2.method_7671(1);
            if (this.spiceInputSlot2.method_7677().method_7909().equals(class_1802.field_8162)) {
                this.spiceInputSlot2.method_7673(class_1799.field_8037);
            }
        }
        if (this.isUsed[2] == 1) {
            this.spiceInputSlot3.method_7671(1);
            if (this.spiceInputSlot3.method_7677().method_7909().equals(class_1802.field_8162)) {
                this.spiceInputSlot3.method_7673(class_1799.field_8037);
            }
        }
    }

    public void updateResultSlot() {
        class_1799 resultStack;
        if (this.resultSlot == null) {
            return;
        }
        if (this.beerInputSlot.method_7677() == class_1799.field_8037 || this.beerInputSlot.method_7677().method_7909().equals(class_1802.field_8162)) {
            this.resultSlot.method_7673(class_1799.field_8037);
            return;
        }
        this.resetIsUsed();
        int beerId = this.getBeerInputBeerId();
        if (!this.isMixedBeer() && this.getInputSpicesNum() == 0) {
            resultStack = new class_1799((class_1935)Beers.byId(beerId).getBeerItem(), 1);
        } else {
            ArrayList<Integer> oriSpiceList = new ArrayList<Integer>();
            oriSpiceList = this.isMixedBeer() ? this.getBeerInputSpiceList() : oriSpiceList;
            for (int i = 0; i < 3; ++i) {
                class_1799 stack = this.getSpiceItemStackInSpiceSlot(i);
                if (oriSpiceList.size() >= 3 || stack == class_1799.field_8037) continue;
                if (i < oriSpiceList.size()) {
                    oriSpiceList.add(i, Spices.byItem(stack.method_7909()).getId());
                } else {
                    oriSpiceList.add(Spices.byItem(stack.method_7909()).getId());
                }
                this.isUsed[i] = 1;
            }
            resultStack = MixedBeerManager.genMixedBeerItemStack(beerId, oriSpiceList);
        }
        this.resultSlot.method_7673(resultStack);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.input.method_5439() ? !this.method_7616(originalStack, this.input.method_5439(), this.field_7761.size(), true) : !this.method_7616(originalStack, 0, this.input.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7609(class_1263 inventory) {
        this.updateResultSlot();
        this.method_7623();
    }

    @Environment(value=EnvType.CLIENT)
    public void setInventoryChangeListener(Runnable inventoryChangeListener) {
        this.inventoryChangeListener = inventoryChangeListener;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, blockPos) -> this.method_7607(player, this.input));
    }

    public void resetIsUsed() {
        if (this.isUsed != null) {
            this.isUsed[0] = 0;
            this.isUsed[1] = 0;
            this.isUsed[2] = 0;
        }
    }
}

