/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lekavar.lma.drinkbeer.manager.MixedBeerManager;
import lekavar.lma.drinkbeer.util.mixedbeer.FlavorCombinations;
import lekavar.lma.drinkbeer.util.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.util.mixedbeer.MixedBeerOnUsing;
import lekavar.lma.drinkbeer.util.mixedbeer.Spices;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SpiceAndFlavorManager {
    public static String getSpiceToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip";
    }

    public static String getNoFlavorToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip_no_flavor";
    }

    public static String getFlavorToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip_flavor";
    }

    public static String getFlavorTranslationKey(int flavorId) {
        return SpiceAndFlavorManager.getFlavorTranslationKey(Flavors.byId(flavorId));
    }

    public static String getFlavorTranslationKey(Flavors flavor) {
        return "drinkbeer.flavor." + flavor.getName();
    }

    public static String getFlavorToolTipTranslationKey(int flavorId) {
        return SpiceAndFlavorManager.getFlavorTranslationKey(flavorId) + ".tooltip";
    }

    public static class_2400 getLastSpiceFlavorParticle(List<Integer> spiceList) {
        if (spiceList != null && !spiceList.isEmpty()) {
            int lastSpiceId = spiceList.get(spiceList.size() - 1);
            return Spices.byId(lastSpiceId).getFlavor().getParticle();
        }
        return Flavors.DEFAULT_PARTICLE;
    }

    private static List<Flavors> spiceListToFlavorList(@NotNull List<Integer> spiceList) {
        ArrayList<Flavors> flavorList = new ArrayList<Flavors>();
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                flavorList.add(Spices.byId(spiceId).getFlavor());
            }
        }
        return flavorList;
    }

    public static Flavors getCombinedFlavor(List<Integer> spiceList) {
        FlavorCombinations flavorCombination = SpiceAndFlavorManager.matchFlavorCombination(SpiceAndFlavorManager.spiceListToFlavorList(spiceList));
        return flavorCombination != null ? flavorCombination.getCombinedFlavor() : null;
    }

    private static FlavorCombinations matchFlavorCombination(List<Flavors> flavorList) {
        if (flavorList == null) {
            return null;
        }
        for (int i = 0; i < flavorList.size(); ++i) {
            Flavors fatherFlavor = flavorList.get(i).getFatherFlavor();
            if (fatherFlavor == null) continue;
            flavorList.set(i, fatherFlavor);
        }
        for (FlavorCombinations flavorCombination : FlavorCombinations.getFlavorCombinationList()) {
            List<Pair<List<Flavors>, Boolean>> flavorCombinationList = flavorCombination.getFlavorCombination().getFlavorCombinationList();
            try {
                for (Pair<List<Flavors>, Boolean> flavorCombinationPair : flavorCombinationList) {
                    if (((Boolean)flavorCombinationPair.getValue()).booleanValue()) {
                        if (!((List)flavorCombinationPair.getKey()).equals(flavorList)) continue;
                        return flavorCombination;
                    }
                    ArrayList tempFlavorList1 = new ArrayList();
                    ArrayList tempFlavorList2 = new ArrayList();
                    Collections.copy(tempFlavorList1, flavorList);
                    Collections.copy(tempFlavorList2, (List)flavorCombinationPair.getKey());
                    Collections.sort(tempFlavorList1);
                    Collections.sort(tempFlavorList2);
                    if (!tempFlavorList1.equals(tempFlavorList2)) continue;
                    return flavorCombination;
                }
            }
            catch (Exception e) {
                System.out.println("NULL value of FlavorCombination in FlavorCombinations!");
                System.out.println("Found in " + flavorCombination.getCombinedFlavor());
            }
        }
        return null;
    }

    public static void applyFlavorValue(MixedBeerOnUsing mixedBeerOnUsing) {
        if (!mixedBeerOnUsing.getFlavorList().isEmpty()) {
            block11: for (Flavors flavor : mixedBeerOnUsing.getFlavorList()) {
                switch (flavor) {
                    case SPICY: 
                    case FIERY: {
                        SpiceAndFlavorManager.applySpicyFlavorValue(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case AROMITIC: 
                    case AROMITIC1: {
                        SpiceAndFlavorManager.applyAromiticFlavorValue(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case REFRESHING: 
                    case REFRESHING1: {
                        SpiceAndFlavorManager.applyRefreshingFlavorValue(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case NUTTY: {
                        SpiceAndFlavorManager.applyNuttyFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case SWEET: {
                        SpiceAndFlavorManager.applySweetFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case LUSCIOUS: {
                        SpiceAndFlavorManager.applySweetFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case CLOYING: {
                        SpiceAndFlavorManager.applySweetFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case NUTTY1: {
                        SpiceAndFlavorManager.applyNuttyFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                    case MELLOW: {
                        SpiceAndFlavorManager.applyMellowFlavorAction(mixedBeerOnUsing, flavor);
                        continue block11;
                    }
                }
                mixedBeerOnUsing.addAction(flavor);
            }
        }
    }

    public static void applyFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, class_1937 world, class_1309 user) {
        List<Flavors> actionList = mixedBeerOnUsing.getActionList();
        if (!actionList.isEmpty()) {
            block6: for (int i = 0; i < actionList.size(); ++i) {
                Flavors flavor = actionList.get(i);
                switch (flavor) {
                    case SOOOOO_SPICY: {
                        SpiceAndFlavorManager.applySoooooSpicyFlavorAction(user);
                        continue block6;
                    }
                    case STORMY: {
                        if (MixedBeerManager.hasActionAfter(i, Flavors.STORMY, mixedBeerOnUsing.getActionList()) || MixedBeerManager.hasActionAfter(i, Flavors.THE_FALL_OF_THE_GIANT, mixedBeerOnUsing.getActionList())) continue block6;
                        SpiceAndFlavorManager.applyStormyFlavorAction(MixedBeerManager.getActionedTimes(i, Flavors.STORMY, mixedBeerOnUsing.getActionList()), world, user);
                        continue block6;
                    }
                    case THE_FALL_OF_THE_GIANT: {
                        SpiceAndFlavorManager.applyStormyFlavorAction(3, world, user);
                        continue block6;
                    }
                    case DRYING: {
                        if (MixedBeerManager.hasActionAfter(i, Flavors.DRYING, mixedBeerOnUsing.getActionList())) continue block6;
                        SpiceAndFlavorManager.applyDryingFlavorAction(MixedBeerManager.getActionedTimes(i, Flavors.DRYING, mixedBeerOnUsing.getActionList()), world, user);
                    }
                }
            }
        }
    }

    public static void applySpicyFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case SPICY: {
                mixedBeerOnUsing.addHealth(-3.0f);
                mixedBeerOnUsing.multiplyAllStatusEffectDuration(1.8f);
                break;
            }
            case FIERY: {
                mixedBeerOnUsing.addHealth(-4.0f);
                mixedBeerOnUsing.multiplyAllStatusEffectDuration(2.0f);
            }
        }
    }

    public static void applySoooooSpicyFlavorAction(class_1309 user) {
        int fireTicks = 100;
        if (!user.method_5809()) {
            user.method_20803(fireTicks);
        } else {
            user.method_20803(user.method_20802() + fireTicks);
        }
    }

    public static void applyAromiticFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case AROMITIC: {
                mixedBeerOnUsing.addAllStatusEffectDuration(800);
                break;
            }
            case AROMITIC1: {
                mixedBeerOnUsing.addAllStatusEffectDuration(1200);
            }
        }
    }

    public static void applyRefreshingFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case REFRESHING: {
                mixedBeerOnUsing.addDrunkValue(-1);
                break;
            }
            case REFRESHING1: {
                mixedBeerOnUsing.addDrunkValue(-2);
            }
        }
    }

    public static void applyStormyFlavorAction(int actionedTimes, class_1937 world, class_1309 user) {
        int range = 9 + (actionedTimes == 3 ? 22 : actionedTimes * 4);
        int halfRange = (range - 1) / 2;
        int xStart = 0;
        int xEnd = 0;
        int zStart = 0;
        int zEnd = 0;
        class_2350 direction = user.method_5755();
        switch (direction) {
            case field_11043: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zStart = -range;
                break;
            }
            case field_11035: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zEnd = range;
                break;
            }
            case field_11034: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xEnd = range;
                break;
            }
            case field_11039: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xStart = -range;
            }
        }
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = 0; y < range; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    class_2338 pos = user.method_24515().method_10069(x, y, z);
                    class_2680 blockState = world.method_8320(pos);
                    if (!class_3481.field_15475.method_15141((Object)blockState.method_26204()) && !class_3481.field_15503.method_15141((Object)blockState.method_26204())) continue;
                    world.method_22352(pos, true);
                }
            }
        }
    }

    public static void applyNuttyFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case NUTTY: {
                mixedBeerOnUsing.addHunger(4);
                break;
            }
            case NUTTY1: {
                mixedBeerOnUsing.addHunger(5);
            }
        }
    }

    public static void applySweetFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case SWEET: {
                mixedBeerOnUsing.addHealth(3.0f);
                break;
            }
            case LUSCIOUS: {
                mixedBeerOnUsing.addHealth(4.0f);
                break;
            }
            case CLOYING: {
                mixedBeerOnUsing.addHealth(1.0f);
            }
        }
    }

    public static void applyMellowFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case MELLOW: {
                mixedBeerOnUsing.addSpecificStatusEffectDuration(class_1294.field_5907, 1600);
            }
        }
    }

    public static void applyDryingFlavorAction(int actionedTimes, class_1937 world, class_1309 user) {
        int range = 17 + actionedTimes * 4;
        int halfRange = (range - 1) / 2;
        int xStart = 0;
        int xEnd = 0;
        int zStart = 0;
        int zEnd = 0;
        class_2350 direction = user.method_5755();
        switch (direction) {
            case field_11043: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zStart = -range;
                break;
            }
            case field_11035: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zEnd = range;
                break;
            }
            case field_11034: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xEnd = range;
                break;
            }
            case field_11039: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xStart = -range;
            }
        }
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = 0; y < range; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    class_2338 pos = user.method_24515().method_10069(x, y, z);
                    class_2680 blockState = world.method_8320(pos);
                    if (!blockState.method_26204().equals(class_2246.field_10382)) continue;
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }
    }
}

