/*
 * Decompiled with CFR 0.152.
 */
package eu.houbystudio.timeoutout;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class TimeOutOutConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public int readTimeoutSeconds = 120;
    public long loginTimeoutTicks = 2400L;
    public long keepAlivePacketIntervalSeconds = 15L;
    public long keepAliveTimeoutSeconds = 120L;

    public static TimeOutOutConfig loadConfig(File file) {
        TimeOutOutConfig config;
        block18: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (TimeOutOutConfig)GSON.fromJson((Reader)bufferedReader, TimeOutOutConfig.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new TimeOutOutConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File config) {
        try (FileOutputStream stream = new FileOutputStream(config);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }
}

