/*
 * Decompiled with CFR 0.152.
 */
package ninjaphenix.expandedstorage;

import com.mojang.datafixers.DSL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1047;
import net.minecraft.class_1208;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3708;
import net.minecraft.class_3917;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import ninjaphenix.expandedstorage.MiniChestScreenHandler;
import ninjaphenix.expandedstorage.Pair;
import ninjaphenix.expandedstorage.Utils;
import ninjaphenix.expandedstorage.block.AbstractChestBlock;
import ninjaphenix.expandedstorage.block.BarrelBlock;
import ninjaphenix.expandedstorage.block.ChestBlock;
import ninjaphenix.expandedstorage.block.MiniChestBlock;
import ninjaphenix.expandedstorage.block.OpenableBlock;
import ninjaphenix.expandedstorage.block.entity.BarrelBlockEntity;
import ninjaphenix.expandedstorage.block.entity.ChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.MiniChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.OldChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.extendable.OpenableBlockEntity;
import ninjaphenix.expandedstorage.block.misc.CursedChestType;
import ninjaphenix.expandedstorage.block.strategies.ItemAccess;
import ninjaphenix.expandedstorage.block.strategies.Lockable;
import ninjaphenix.expandedstorage.client.TextureCollection;
import ninjaphenix.expandedstorage.item.BlockUpgradeBehaviour;
import ninjaphenix.expandedstorage.item.MutationMode;
import ninjaphenix.expandedstorage.item.MutatorBehaviour;
import ninjaphenix.expandedstorage.item.StorageConversionKit;
import ninjaphenix.expandedstorage.item.StorageMutator;
import ninjaphenix.expandedstorage.registration.BlockItemCollection;
import ninjaphenix.expandedstorage.registration.BlockItemPair;
import ninjaphenix.expandedstorage.registration.RegistrationConsumer;
import ninjaphenix.expandedstorage.tier.Tier;
import org.apache.commons.codec.digest.DigestUtils;

public final class Common {
    public static final class_2960 BARREL_BLOCK_TYPE = Utils.id("barrel");
    public static final class_2960 CHEST_BLOCK_TYPE = Utils.id("chest");
    public static final class_2960 OLD_CHEST_BLOCK_TYPE = Utils.id("old_chest");
    public static final class_2960 MINI_CHEST_BLOCK_TYPE = Utils.id("mini_chest");
    private static final Map<Predicate<class_2248>, BlockUpgradeBehaviour> BLOCK_UPGRADE_BEHAVIOURS = new HashMap<Predicate<class_2248>, BlockUpgradeBehaviour>();
    private static final Map<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour> MUTATOR_BEHAVIOURS = new HashMap<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour>();
    private static final Map<Pair<class_2960, class_2960>, OpenableBlock> BLOCKS = new HashMap<Pair<class_2960, class_2960>, OpenableBlock>();
    private static final Map<class_2960, TextureCollection> CHEST_TEXTURES = new HashMap<class_2960, TextureCollection>();
    private static class_2591<ChestBlockEntity> chestBlockEntityType;
    private static class_2591<OldChestBlockEntity> oldChestBlockEntityType;
    private static class_2591<BarrelBlockEntity> barrelBlockEntityType;
    private static class_2591<MiniChestBlockEntity> miniChestBlockEntityType;
    private static Function<OpenableBlockEntity, ItemAccess> itemAccess;
    private static Supplier<Lockable> lockable;
    private static class_3917<MiniChestScreenHandler> miniChestScreenHandler;

    public static class_2591<ChestBlockEntity> getChestBlockEntityType() {
        return chestBlockEntityType;
    }

    public static class_2591<OldChestBlockEntity> getOldChestBlockEntityType() {
        return oldChestBlockEntityType;
    }

    public static class_2591<BarrelBlockEntity> getBarrelBlockEntityType() {
        return barrelBlockEntityType;
    }

    public static class_2591<MiniChestBlockEntity> getMiniChestBlockEntityType() {
        return miniChestBlockEntityType;
    }

    private static BlockItemPair<ChestBlock, class_1747> chestBlock(class_2960 blockId, class_2960 stat, Tier tier, class_4970.class_2251 settings, BiFunction<ChestBlock, class_1792.class_1793, class_1747> blockItemMaker, class_1761 group) {
        ChestBlock block = new ChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), blockId, tier.getId(), stat, tier.getSlotCount());
        Common.registerTieredBlock(block);
        return new BlockItemPair<ChestBlock, class_1747>(block, blockItemMaker.apply(block, new class_1792.class_1793().method_7892(group)));
    }

    private static BlockItemPair<AbstractChestBlock, class_1747> oldChestBlock(class_2960 blockId, class_2960 stat, Tier tier, class_4970.class_2251 settings, class_1761 group) {
        AbstractChestBlock block = new AbstractChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), blockId, tier.getId(), stat, tier.getSlotCount());
        Common.registerTieredBlock(block);
        class_1747 item = new class_1747((class_2248)block, (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group)));
        return new BlockItemPair<AbstractChestBlock, class_1747>(block, item);
    }

    private static BlockItemPair<BarrelBlock, class_1747> barrelBlock(class_2960 blockId, class_2960 stat, Tier tier, class_4970.class_2251 settings, class_1761 group) {
        BarrelBlock block = new BarrelBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), blockId, tier.getId(), stat, tier.getSlotCount());
        Common.registerTieredBlock(block);
        class_1747 item = new class_1747((class_2248)block, (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group)));
        return new BlockItemPair<BarrelBlock, class_1747>(block, item);
    }

    private static BlockItemPair<MiniChestBlock, class_1747> miniChestBlock(class_2960 blockId, class_2960 stat, Tier tier, class_4970.class_2251 settings, BiFunction<MiniChestBlock, class_1792.class_1793, class_1747> blockItemMaker, class_1761 group) {
        MiniChestBlock block = new MiniChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), blockId, stat);
        Common.registerTieredBlock(block);
        class_1747 item = blockItemMaker.apply(block, (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793().method_7892(group)));
        return new BlockItemPair<MiniChestBlock, class_1747>(block, item);
    }

    static class_2960[] getChestTextures(ChestBlock[] blocks) {
        class_2960[] textures = new class_2960[blocks.length * CursedChestType.values().length];
        int index = 0;
        for (ChestBlock block : blocks) {
            class_2960 blockId = block.getBlockId();
            for (CursedChestType type : CursedChestType.values()) {
                textures[index++] = Common.getChestTexture(blockId, type);
            }
        }
        return textures;
    }

    static void registerChestTextures(ChestBlock[] blocks) {
        for (ChestBlock block : blocks) {
            class_2960 blockId = block.getBlockId();
            Common.declareChestTextures(blockId, Utils.id("entity/" + blockId.method_12832() + "/single"), Utils.id("entity/" + blockId.method_12832() + "/left"), Utils.id("entity/" + blockId.method_12832() + "/right"), Utils.id("entity/" + blockId.method_12832() + "/top"), Utils.id("entity/" + blockId.method_12832() + "/bottom"), Utils.id("entity/" + blockId.method_12832() + "/front"), Utils.id("entity/" + blockId.method_12832() + "/back"));
        }
    }

    private static boolean upgradeSingleBlockToChest(class_1937 world, class_2680 state, class_2338 pos, class_2960 from, class_2960 to) {
        int inventorySize;
        class_2248 block = state.method_26204();
        boolean isExpandedStorageChest = block instanceof ChestBlock;
        int n = inventorySize = !isExpandedStorageChest ? 27 : Common.getTieredBlock(CHEST_BLOCK_TYPE, ((OpenableBlock)block).getBlockTier()).getSlotCount();
        if (isExpandedStorageChest && ((OpenableBlock)block).getBlockTier() == from || !isExpandedStorageChest && from == Utils.WOOD_TIER_ID) {
            class_2499 items;
            class_1263 inventory;
            boolean verifiedSize;
            class_2586 blockEntity = world.method_8321(pos);
            class_2487 tag = blockEntity.method_38244();
            boolean bl = verifiedSize = blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() == inventorySize;
            if (!verifiedSize && tag.method_10573("Items", 9) && (items = tag.method_10554("Items", 10)).size() <= inventorySize) {
                verifiedSize = true;
            }
            if (verifiedSize) {
                ChestBlock toBlock = (ChestBlock)Common.getTieredBlock(CHEST_BLOCK_TYPE, to);
                class_2371 inventory2 = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
                class_1273 code = class_1273.method_5473((class_2487)tag);
                class_1262.method_5429((class_2487)tag, (class_2371)inventory2);
                world.method_8544(pos);
                class_2680 newState = (class_2680)((class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)));
                if (state.method_28498((class_2769)ChestBlock.CURSED_CHEST_TYPE)) {
                    newState = (class_2680)newState.method_11657((class_2769)ChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)state.method_11654((class_2769)ChestBlock.CURSED_CHEST_TYPE)))));
                } else if (state.method_28498((class_2769)class_2741.field_12506)) {
                    class_2745 type = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
                    newState = (class_2680)newState.method_11657((class_2769)ChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)(type == class_2745.field_12574 ? CursedChestType.RIGHT : (type == class_2745.field_12571 ? CursedChestType.LEFT : CursedChestType.SINGLE))));
                }
                if (world.method_8501(pos, newState)) {
                    class_2586 newEntity = world.method_8321(pos);
                    class_2487 newTag = newEntity.method_38244();
                    class_1262.method_5426((class_2487)newTag, (class_2371)inventory2);
                    code.method_5474(newTag);
                    newEntity.method_11014(newTag);
                    return true;
                }
                world.method_8438(blockEntity);
            }
        }
        return false;
    }

    private static boolean upgradeSingleBlockToOldChest(class_1937 world, class_2680 state, class_2338 pos, class_2960 from, class_2960 to) {
        if (((OpenableBlock)state.method_26204()).getBlockTier() == from) {
            AbstractChestBlock toBlock = (AbstractChestBlock)Common.getTieredBlock(OLD_CHEST_BLOCK_TYPE, to);
            class_2371 inventory = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
            class_2586 blockEntity = world.method_8321(pos);
            class_2487 tag = blockEntity.method_38244();
            class_1273 code = class_1273.method_5473((class_2487)tag);
            class_1262.method_5429((class_2487)tag, (class_2371)inventory);
            world.method_8544(pos);
            class_2680 newState = (class_2680)((class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))));
            if (world.method_8501(pos, newState)) {
                class_2586 newEntity = world.method_8321(pos);
                class_2487 newTag = newEntity.method_38244();
                class_1262.method_5426((class_2487)newTag, (class_2371)inventory);
                code.method_5474(newTag);
                newEntity.method_11014(newTag);
                return true;
            }
            world.method_8438(blockEntity);
        }
        return false;
    }

    public static class_2960 stat(String stat) {
        class_2960 statId = Utils.id(stat);
        class_2378.method_10230((class_2378)class_2378.field_11158, (class_2960)statId, (Object)statId);
        class_3468.field_15419.method_14956((Object)statId);
        return statId;
    }

    private static void defineTierUpgradePath(Pair<class_2960, class_1792>[] items, boolean wrapTooltipManually, class_1761 group, Tier ... tiers) {
        int numTiers = tiers.length;
        int index = 1;
        for (int fromIndex = 0; fromIndex < numTiers - 1; ++fromIndex) {
            Tier fromTier = tiers[fromIndex];
            for (int toIndex = fromIndex + 1; toIndex < numTiers; ++toIndex) {
                Tier toTier = tiers[toIndex];
                class_2960 itemId = Utils.id(fromTier.getId().method_12832() + "_to_" + toTier.getId().method_12832() + "_conversion_kit");
                class_1792.class_1793 settings = (class_1792.class_1793)fromTier.getItemSettings().andThen(toTier.getItemSettings()).apply(new class_1792.class_1793().method_7892(group).method_7889(16));
                StorageConversionKit kit = new StorageConversionKit(settings, fromTier.getId(), toTier.getId(), wrapTooltipManually);
                items[index++] = new Pair<class_2960, StorageConversionKit>(itemId, kit);
            }
        }
    }

    public static BlockUpgradeBehaviour getBlockUpgradeBehaviour(class_2248 block) {
        for (Map.Entry<Predicate<class_2248>, BlockUpgradeBehaviour> entry : BLOCK_UPGRADE_BEHAVIOURS.entrySet()) {
            if (!entry.getKey().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void defineBlockUpgradeBehaviour(Predicate<class_2248> target, BlockUpgradeBehaviour behaviour) {
        BLOCK_UPGRADE_BEHAVIOURS.put(target, behaviour);
    }

    private static void registerTieredBlock(OpenableBlock block) {
        BLOCKS.putIfAbsent(new Pair<class_2960, class_2960>(block.getBlockType(), block.getBlockTier()), block);
    }

    public static OpenableBlock getTieredBlock(class_2960 blockType, class_2960 tier) {
        return BLOCKS.get(new Pair<class_2960, class_2960>(blockType, tier));
    }

    public static void declareChestTextures(class_2960 block, class_2960 singleTexture, class_2960 leftTexture, class_2960 rightTexture, class_2960 topTexture, class_2960 bottomTexture, class_2960 frontTexture, class_2960 backTexture) {
        if (CHEST_TEXTURES.containsKey(block)) {
            throw new IllegalArgumentException("Tried registering chest textures for \"" + block + "\" which already has textures.");
        }
        TextureCollection collection = new TextureCollection(singleTexture, leftTexture, rightTexture, topTexture, bottomTexture, frontTexture, backTexture);
        CHEST_TEXTURES.put(block, collection);
    }

    public static class_2960 getChestTexture(class_2960 block, CursedChestType chestType) {
        if (CHEST_TEXTURES.containsKey(block)) {
            return CHEST_TEXTURES.get(block).getTexture(chestType);
        }
        return class_1047.method_4539();
    }

    private static void registerMutationBehaviour(Predicate<class_2248> predicate, MutationMode mode, MutatorBehaviour behaviour) {
        MUTATOR_BEHAVIOURS.put(new Pair<Predicate<class_2248>, MutationMode>(predicate, mode), behaviour);
    }

    public static MutatorBehaviour getMutatorBehaviour(class_2248 block, MutationMode mode) {
        for (Map.Entry<Pair<Predicate<class_2248>, MutationMode>, MutatorBehaviour> entry : MUTATOR_BEHAVIOURS.entrySet()) {
            Pair<Predicate<class_2248>, MutationMode> pair = entry.getKey();
            if (pair.getSecond() != mode || !pair.getFirst().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void registerContent(Function<OpenableBlockEntity, ItemAccess> itemAccess, Supplier<Lockable> lockable, class_1761 group, boolean isClient, Consumer<Pair<class_2960, class_1792>[]> baseRegistration, boolean manuallyWrapTooltips, RegistrationConsumer<ChestBlock, class_1747, ChestBlockEntity> chestRegistration, class_3494.class_5123<class_2248> chestTag, BiFunction<ChestBlock, class_1792.class_1793, class_1747> chestItemMaker, Function<OpenableBlockEntity, ItemAccess> chestAccessMaker, RegistrationConsumer<AbstractChestBlock, class_1747, OldChestBlockEntity> oldChestRegistration, RegistrationConsumer<BarrelBlock, class_1747, BarrelBlockEntity> barrelRegistration, class_3494.class_5123<class_2248> barrelTag, RegistrationConsumer<MiniChestBlock, class_1747, MiniChestBlockEntity> miniChestRegistration, BiFunction<MiniChestBlock, class_1792.class_1793, class_1747> miniChestItemMaker, class_3917<MiniChestScreenHandler> miniChestScreenHandlerType, class_3494.class_5123<class_2248> chestCycle, class_3494.class_5123<class_2248> miniChestCycle, class_3494.class_5123<class_2248> miniChestSecretCycle, class_3494.class_5123<class_2248> miniChestSecretCycle2) {
        Common.itemAccess = itemAccess;
        Common.lockable = lockable;
        Tier woodTier = new Tier(Utils.WOOD_TIER_ID, 27, UnaryOperator.identity(), UnaryOperator.identity());
        Tier ironTier = new Tier(Utils.id("iron"), 54, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier goldTier = new Tier(Utils.id("gold"), 81, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier diamondTier = new Tier(Utils.id("diamond"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier obsidianTier = new Tier(Utils.id("obsidian"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier netheriteTier = new Tier(Utils.id("netherite"), 135, class_4970.class_2251::method_29292, class_1792.class_1793::method_24359);
        Pair[] baseContent = new Pair[16];
        baseContent[0] = new Pair<class_2960, StorageMutator>(Utils.id("storage_mutator"), new StorageMutator(new class_1792.class_1793().method_7889(1).method_7892(group)));
        Common.defineTierUpgradePath(baseContent, manuallyWrapTooltips, group, woodTier, ironTier, goldTier, diamondTier, obsidianTier, netheriteTier);
        baseRegistration.accept(baseContent);
        class_4970.class_2251 woodSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 pumpkinSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15954, (class_3620)class_3620.field_15987).method_9632(1.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 presentSettings = class_4970.class_2251.method_26240((class_3614)class_3614.field_15932, state -> {
            CursedChestType type = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
            if (type == CursedChestType.SINGLE) {
                return class_3620.field_16020;
            }
            if (type == CursedChestType.FRONT || type == CursedChestType.BACK) {
                return class_3620.field_16004;
            }
            return class_3620.field_16022;
        }).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 ironSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16005).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 goldSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15994).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 diamondSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_15983).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 obsidianSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15914, (class_3620)class_3620.field_16009).method_9629(50.0f, 1200.0f);
        class_4970.class_2251 netheriteSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16009).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_22150);
        BlockItemCollection chestContent = BlockItemCollection.of(ChestBlock[]::new, class_1747[]::new, Common.chestBlock(Utils.id("wood_chest"), Common.stat("open_wood_chest"), woodTier, woodSettings, chestItemMaker, group), Common.chestBlock(Utils.id("pumpkin_chest"), Common.stat("open_pumpkin_chest"), woodTier, pumpkinSettings, chestItemMaker, group), Common.chestBlock(Utils.id("present"), Common.stat("open_present"), woodTier, presentSettings, chestItemMaker, group), Common.chestBlock(Utils.id("iron_chest"), Common.stat("open_iron_chest"), ironTier, ironSettings, chestItemMaker, group), Common.chestBlock(Utils.id("gold_chest"), Common.stat("open_gold_chest"), goldTier, goldSettings, chestItemMaker, group), Common.chestBlock(Utils.id("diamond_chest"), Common.stat("open_diamond_chest"), diamondTier, diamondSettings, chestItemMaker, group), Common.chestBlock(Utils.id("obsidian_chest"), Common.stat("open_obsidian_chest"), obsidianTier, obsidianSettings, chestItemMaker, group), Common.chestBlock(Utils.id("netherite_chest"), Common.stat("open_netherite_chest"), netheriteTier, netheriteSettings, chestItemMaker, group));
        if (isClient) {
            Common.registerChestTextures((ChestBlock[])chestContent.getBlocks());
        }
        chestBlockEntityType = class_2591.class_2592.method_20528((pos, state) -> new ChestBlockEntity(Common.getChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable), (class_2248[])chestContent.getBlocks()).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)CHEST_BLOCK_TYPE.toString()));
        chestRegistration.accept(chestContent, chestBlockEntityType);
        Predicate<class_2248> isUpgradableChestBlock = block -> block instanceof ChestBlock || block instanceof class_2281 || chestTag.method_15141(block);
        Common.defineBlockUpgradeBehaviour(isUpgradableChestBlock, (context, from, to) -> {
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            class_1657 player = context.method_8036();
            class_1799 handStack = context.method_8041();
            if (state.method_26204() instanceof ChestBlock) {
                CursedChestType type = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                if (AbstractChestBlock.getBlockType(type) == class_4732.class_4733.field_21783) {
                    boolean upgradeSucceeded = Common.upgradeSingleBlockToChest(world, state, pos, from, to);
                    if (upgradeSucceeded) {
                        handStack.method_7934(1);
                    }
                    return upgradeSucceeded;
                }
                if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(type, facing));
                    class_2680 otherState = world.method_8320(otherPos);
                    boolean firstSucceeded = Common.upgradeSingleBlockToChest(world, state, pos, from, to);
                    boolean secondSucceeded = Common.upgradeSingleBlockToChest(world, otherState, otherPos, from, to);
                    if (firstSucceeded && secondSucceeded) {
                        handStack.method_7934(2);
                    } else if (firstSucceeded || secondSucceeded) {
                        handStack.method_7934(1);
                    }
                    return firstSucceeded || secondSucceeded;
                }
            } else {
                if (class_2281.method_24169((class_2680)state) == class_4732.class_4733.field_21783) {
                    boolean upgradeSucceeded = Common.upgradeSingleBlockToChest(world, state, pos, from, to);
                    if (upgradeSucceeded) {
                        handStack.method_7934(1);
                    }
                    return upgradeSucceeded;
                }
                if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                    class_2338 otherPos = pos.method_10093(class_2281.method_9758((class_2680)state));
                    class_2680 otherState = world.method_8320(otherPos);
                    boolean firstSucceeded = Common.upgradeSingleBlockToChest(world, state, pos, from, to);
                    boolean secondSucceeded = Common.upgradeSingleBlockToChest(world, otherState, otherPos, from, to);
                    if (firstSucceeded && secondSucceeded) {
                        handStack.method_7934(2);
                    } else if (firstSucceeded || secondSucceeded) {
                        handStack.method_7934(1);
                    }
                    return firstSucceeded || secondSucceeded;
                }
            }
            return false;
        });
        BlockItemCollection oldChestContent = BlockItemCollection.of(AbstractChestBlock[]::new, class_1747[]::new, Common.oldChestBlock(Utils.id("old_wood_chest"), Common.stat("open_old_wood_chest"), woodTier, woodSettings, group), Common.oldChestBlock(Utils.id("old_iron_chest"), Common.stat("open_old_iron_chest"), ironTier, ironSettings, group), Common.oldChestBlock(Utils.id("old_gold_chest"), Common.stat("open_old_gold_chest"), goldTier, goldSettings, group), Common.oldChestBlock(Utils.id("old_diamond_chest"), Common.stat("open_old_diamond_chest"), diamondTier, diamondSettings, group), Common.oldChestBlock(Utils.id("old_obsidian_chest"), Common.stat("open_old_obsidian_chest"), obsidianTier, obsidianSettings, group), Common.oldChestBlock(Utils.id("old_netherite_chest"), Common.stat("open_old_netherite_chest"), netheriteTier, netheriteSettings, group));
        oldChestBlockEntityType = class_2591.class_2592.method_20528((pos, state) -> new OldChestBlockEntity(Common.getOldChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable), (class_2248[])oldChestContent.getBlocks()).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)OLD_CHEST_BLOCK_TYPE.toString()));
        oldChestRegistration.accept(oldChestContent, oldChestBlockEntityType);
        Predicate<class_2248> isUpgradableOldChestBlock = block -> block.getClass() == AbstractChestBlock.class;
        Common.defineBlockUpgradeBehaviour(isUpgradableOldChestBlock, (context, from, to) -> {
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2680 state = world.method_8320(pos);
            class_1657 player = context.method_8036();
            class_1799 handStack = context.method_8041();
            if (AbstractChestBlock.getBlockType((CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))) == class_4732.class_4733.field_21783) {
                boolean upgradeSucceeded = Common.upgradeSingleBlockToOldChest(world, state, pos, from, to);
                if (upgradeSucceeded) {
                    handStack.method_7934(1);
                }
                return upgradeSucceeded;
            }
            if (handStack.method_7947() > 1 || player != null && player.method_7337()) {
                class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                class_2680 otherState = world.method_8320(otherPos);
                boolean firstSucceeded = Common.upgradeSingleBlockToOldChest(world, state, pos, from, to);
                boolean secondSucceeded = Common.upgradeSingleBlockToOldChest(world, otherState, otherPos, from, to);
                if (firstSucceeded && secondSucceeded) {
                    handStack.method_7934(2);
                } else if (firstSucceeded || secondSucceeded) {
                    handStack.method_7934(1);
                }
                return firstSucceeded || secondSucceeded;
            }
            return false;
        });
        class_4970.class_2251 ironBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 goldBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 diamondBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 obsidianBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 netheriteBarrelSettings = class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        BlockItemCollection barrelContent = BlockItemCollection.of(BarrelBlock[]::new, class_1747[]::new, Common.barrelBlock(Utils.id("iron_barrel"), Common.stat("open_iron_barrel"), ironTier, ironBarrelSettings, group), Common.barrelBlock(Utils.id("gold_barrel"), Common.stat("open_gold_barrel"), goldTier, goldBarrelSettings, group), Common.barrelBlock(Utils.id("diamond_barrel"), Common.stat("open_diamond_barrel"), diamondTier, diamondBarrelSettings, group), Common.barrelBlock(Utils.id("obsidian_barrel"), Common.stat("open_obsidian_barrel"), obsidianTier, obsidianBarrelSettings, group), Common.barrelBlock(Utils.id("netherite_barrel"), Common.stat("open_netherite_barrel"), netheriteTier, netheriteBarrelSettings, group));
        barrelBlockEntityType = class_2591.class_2592.method_20528((pos, state) -> new BarrelBlockEntity(Common.getBarrelBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable), (class_2248[])barrelContent.getBlocks()).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)BARREL_BLOCK_TYPE.toString()));
        barrelRegistration.accept(barrelContent, barrelBlockEntityType);
        Predicate<class_2248> isUpgradableBarrelBlock = block -> block instanceof BarrelBlock || block instanceof class_3708 || barrelTag.method_15141(block);
        Common.defineBlockUpgradeBehaviour(isUpgradableBarrelBlock, (context, from, to) -> {
            int inventorySize;
            class_2338 pos;
            class_1937 world = context.method_8045();
            class_2680 state = world.method_8320(pos = context.method_8037());
            class_2248 block = state.method_26204();
            boolean isExpandedStorageBarrel = block instanceof BarrelBlock;
            int n = inventorySize = !isExpandedStorageBarrel ? 27 : Common.getTieredBlock(BARREL_BLOCK_TYPE, ((OpenableBlock)block).getBlockTier()).getSlotCount();
            if (isExpandedStorageBarrel && ((OpenableBlock)block).getBlockTier() == from || !isExpandedStorageBarrel && from == Utils.WOOD_TIER_ID) {
                class_2499 items;
                class_1263 inventory;
                boolean verifiedSize;
                class_2586 blockEntity = world.method_8321(pos);
                class_2487 tag = blockEntity.method_38244();
                boolean bl = verifiedSize = blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5439() == inventorySize;
                if (!verifiedSize && tag.method_10573("Items", 9) && (items = tag.method_10554("Items", 10)).size() <= inventorySize) {
                    verifiedSize = true;
                }
                if (verifiedSize) {
                    OpenableBlock toBlock = Common.getTieredBlock(BARREL_BLOCK_TYPE, to);
                    class_2371 inventory2 = class_2371.method_10213((int)toBlock.getSlotCount(), (Object)class_1799.field_8037);
                    class_1273 code = class_1273.method_5473((class_2487)tag);
                    class_1262.method_5429((class_2487)tag, (class_2371)inventory2);
                    world.method_8544(pos);
                    class_2680 newState = (class_2680)toBlock.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
                    if (world.method_8501(pos, newState)) {
                        class_2586 newEntity = world.method_8321(pos);
                        class_2487 newTag = newEntity.method_38244();
                        class_1262.method_5426((class_2487)newTag, (class_2371)inventory2);
                        code.method_5474(newTag);
                        newEntity.method_11014(newTag);
                        context.method_8041().method_7934(1);
                        return true;
                    }
                    world.method_8438(blockEntity);
                }
            }
            return false;
        });
        class_2960 woodStat = Common.stat("open_wood_mini_chest");
        class_2960 pumpkinStat = Common.stat("open_pumpkin_mini_chest");
        class_2960 redPresentStat = Common.stat("open_red_mini_present");
        class_2960 whitePresentStat = Common.stat("open_white_mini_present");
        class_2960 candyCanePresentStat = Common.stat("open_candy_cane_mini_present");
        class_2960 greenPresentStat = Common.stat("open_green_mini_present");
        class_2960 lavenderPresentStat = Common.stat("open_lavender_mini_present");
        class_2960 pinkAmethystPresentStat = Common.stat("open_pink_amethyst_mini_present");
        class_4970.class_2251 redPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16020).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 whitePresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 candyCanePresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 greenPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16004).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 lavenderPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 pinkAmethystPresentSettings = class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        BlockItemCollection miniChestContent = BlockItemCollection.of(MiniChestBlock[]::new, class_1747[]::new, Common.miniChestBlock(Utils.id("vanilla_wood_mini_chest"), woodStat, woodTier, woodSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("wood_mini_chest"), woodStat, woodTier, woodSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("pumpkin_mini_chest"), pumpkinStat, woodTier, pumpkinSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("red_mini_present"), redPresentStat, woodTier, redPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("white_mini_present"), whitePresentStat, woodTier, whitePresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("candy_cane_mini_present"), candyCanePresentStat, woodTier, candyCanePresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("green_mini_present"), greenPresentStat, woodTier, greenPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("lavender_mini_present"), lavenderPresentStat, woodTier, lavenderPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("pink_amethyst_mini_present"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("vanilla_wood_mini_chest_with_sparrow"), woodStat, woodTier, woodSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("wood_mini_chest_with_sparrow"), woodStat, woodTier, woodSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("pumpkin_mini_chest_with_sparrow"), pumpkinStat, woodTier, pumpkinSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("red_mini_present_with_sparrow"), redPresentStat, woodTier, redPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("white_mini_present_with_sparrow"), whitePresentStat, woodTier, whitePresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("candy_cane_mini_present_with_sparrow"), candyCanePresentStat, woodTier, candyCanePresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("green_mini_present_with_sparrow"), greenPresentStat, woodTier, greenPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("lavender_mini_present_with_sparrow"), lavenderPresentStat, woodTier, lavenderPresentSettings, miniChestItemMaker, group), Common.miniChestBlock(Utils.id("pink_amethyst_mini_present_with_sparrow"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings, miniChestItemMaker, group));
        miniChestBlockEntityType = class_2591.class_2592.method_20528((pos, state) -> new MiniChestBlockEntity(Common.getMiniChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable), (class_2248[])miniChestContent.getBlocks()).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)MINI_CHEST_BLOCK_TYPE.toString()));
        miniChestRegistration.accept(miniChestContent, miniChestBlockEntityType);
        miniChestScreenHandler = miniChestScreenHandlerType;
        Predicate<class_2248> isChestBlock = b -> b instanceof AbstractChestBlock;
        Common.registerMutationBehaviour(isChestBlock, MutationMode.MERGE, (context, world, state, pos, stack) -> {
            class_1657 player = context.method_8036();
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == CursedChestType.SINGLE) {
                class_2487 tag = stack.method_7948();
                if (tag.method_10545("pos")) {
                    class_2338 otherPos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                    class_2680 otherState = world.method_8320(otherPos);
                    class_2350 direction = class_2350.method_35832((class_2338)otherPos.method_10059((class_2382)pos));
                    if (direction != null) {
                        if (state.method_26204() == otherState.method_26204()) {
                            if (otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == CursedChestType.SINGLE) {
                                if (state.method_11654((class_2769)class_2741.field_12481) == otherState.method_11654((class_2769)class_2741.field_12481)) {
                                    if (!world.method_8608()) {
                                        CursedChestType chestType = AbstractChestBlock.getChestType((class_2350)state.method_11654((class_2769)class_2741.field_12481), direction);
                                        world.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)));
                                        tag.method_10551("pos");
                                        player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_end"), true);
                                    }
                                    return class_1269.field_5812;
                                }
                                player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_wrong_facing"), true);
                            } else {
                                player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_already_double_chest"), true);
                            }
                        } else {
                            player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_wrong_block", new Object[]{state.method_26204().method_9518()}), true);
                        }
                    } else {
                        player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_not_adjacent"), true);
                    }
                } else {
                    if (!world.method_8608()) {
                        tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                        player.method_7353((class_2561)new class_2588("tooltip.expandedstorage.storage_mutator.merge_start", new Object[]{Utils.ALT_USE}), true);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5814;
        });
        Common.registerMutationBehaviour(isChestBlock, MutationMode.SPLIT, (context, world, state, pos, stack) -> {
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) != CursedChestType.SINGLE) {
                if (!world.method_8608()) {
                    world.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)CursedChestType.SINGLE)));
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        Common.registerMutationBehaviour(isChestBlock, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (!world.method_8608()) {
                CursedChestType chestType = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType == CursedChestType.SINGLE) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                } else {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = world.method_8320(otherPos);
                    if (chestType == CursedChestType.TOP || chestType == CursedChestType.BOTTOM) {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                        world.method_8501(otherPos, (class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                    } else {
                        world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                        world.method_8501(otherPos, (class_2680)((class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((CursedChestType)((Object)((Object)otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                    }
                }
            }
            return class_1269.field_5812;
        });
        Common.registerMutationBehaviour(b -> b instanceof ChestBlock, MutationMode.SWAP_THEME, (context, world, state, pos, stack) -> {
            List blocks = chestCycle.method_15138();
            int index = blocks.indexOf(state.method_26204());
            if (index != -1) {
                class_2248 next = (class_2248)blocks.get((index + 1) % blocks.size());
                CursedChestType chestType = (CursedChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType != CursedChestType.SINGLE) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = world.method_8320(otherPos);
                    world.method_8652(otherPos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)otherState.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)otherState.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType.getOpposite())), 130);
                }
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)), 130);
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        Predicate<class_2248> isBarrelBlock = b -> b instanceof BarrelBlock || b instanceof class_3708 || barrelTag.method_15141(b);
        Common.registerMutationBehaviour(isBarrelBlock, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                if (!world.method_8608()) {
                    world.method_8501(pos, (class_2680)state.method_28493((class_2769)class_2741.field_12525));
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
        Predicate<class_2248> isMiniChest = b -> b instanceof MiniChestBlock;
        Common.registerMutationBehaviour(isMiniChest, MutationMode.ROTATE, (context, world, state, pos, stack) -> {
            if (!world.method_8608()) {
                world.method_8501(pos, state.method_26186(class_2470.field_11463));
            }
            return class_1269.field_5812;
        });
        Common.registerMutationBehaviour(isMiniChest, MutationMode.SWAP_THEME, (context, world, state, pos, stack) -> {
            String nameHash = DigestUtils.md5Hex((String)stack.method_7964().method_10851());
            List blocks = nameHash.equals("4c88924788f419b562d50acfddc3a781") ? miniChestSecretCycle.method_15138() : (nameHash.equals("ef5a30521df4c0dc7568844eefe7e7e3") ? miniChestSecretCycle2.method_15138() : miniChestCycle.method_15138());
            int index = blocks.indexOf(state.method_26204());
            if (index != -1) {
                class_2248 next = (class_2248)blocks.get((index + 1) % blocks.size());
                world.method_8501(pos, (class_2680)((class_2680)next.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508))));
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        });
    }

    public static class_3917<MiniChestScreenHandler> getMiniChestScreenHandlerType() {
        return miniChestScreenHandler;
    }
}

