/*
 * Decompiled with CFR 0.152.
 */
package net.quarrymod.blockentity.machine.tier3;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.quarrymod.block.QuarryBlock;
import net.quarrymod.block.misc.BlockDrillTube;
import net.quarrymod.blockentity.utils.SlotGroup;
import net.quarrymod.config.QMConfig;
import net.quarrymod.init.QMBlockEntities;
import net.quarrymod.init.QMContent;
import net.quarrymod.items.IQuarryUpgrade;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.RebornInventory;

public class QuarryBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public int rangeExtenderLevel;
    public int fortuneLevel;
    public boolean isSilkTouch;
    public RebornInventory<QuarryBlockEntity> inventory = new RebornInventory(12, "QuarryBlockEntity", 64, (MachineBaseBlockEntity)this);
    public RebornInventory<QuarryBlockEntity> quarryUpgradesInventory = new RebornInventory(2, "QuarryUpgrades", 1, (MachineBaseBlockEntity)this);
    private long miningSpentedEnergy = 0L;
    private ExcavationState excavationState = ExcavationState.InProgress;
    private ExcavationWorkType excavationWorkType = ExcavationWorkType.Mining;
    private boolean isMineAll = false;
    private class_2338 targetOrePos;
    private int currentTickTime = 0;
    private SlotGroup<QuarryBlockEntity> holeFillerSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{0, 1, 2, 3});
    private SlotGroup<QuarryBlockEntity> drillTubeSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{4, 5});
    private SlotGroup<QuarryBlockEntity> outputSlotGroup = new SlotGroup<QuarryBlockEntity>(this.inventory, new int[]{6, 7, 8, 9, 10});
    private SlotGroup<QuarryBlockEntity> quarryUpgradesSlotGroup = new SlotGroup<QuarryBlockEntity>(this.quarryUpgradesInventory, new int[]{0, 1});

    public QuarryBlockEntity(class_2338 pos, class_2680 state) {
        super(QMBlockEntities.QUARRY, pos, state);
    }

    public int getProgressScaled(int scale) {
        if (this.miningSpentedEnergy != 0L) {
            return (int)Math.min(this.miningSpentedEnergy * (long)scale / this.getEnergyPerExcavation(), 100L);
        }
        return 0;
    }

    public ExcavationState getExcavationState() {
        return this.excavationState;
    }

    public boolean getMineAll() {
        switch (QMConfig.quarryAccessibleExcavationModes) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return this.isMineAll;
    }

    public void setMineAll(boolean mineAll) {
        switch (QMConfig.quarryAccessibleExcavationModes) {
            case 1: {
                this.isMineAll = false;
            }
            case 2: {
                this.isMineAll = true;
            }
        }
        this.isMineAll = mineAll;
    }

    private void setExcavationState(ExcavationState state) {
        if (this.excavationState == state) {
            return;
        }
        this.excavationState = state;
        this.refreshProperty();
    }

    public ExcavationWorkType getExcavationWorkType() {
        return this.excavationWorkType;
    }

    private void setExcavationWorkType(ExcavationWorkType workType) {
        if (this.excavationWorkType == workType) {
            return;
        }
        this.excavationWorkType = workType;
        this.refreshProperty();
    }

    private void refreshProperty() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            ((QuarryBlock)this.field_11863.method_8320(this.field_11867).method_26204()).setState(this.getDisplayState(), this.field_11863, this.field_11867);
        }
    }

    public QuarryBlock.DisplayState getDisplayState() {
        QuarryBlock.DisplayState state = QuarryBlock.DisplayState.Off;
        if (this.excavationState.isError()) {
            state = QuarryBlock.DisplayState.Error;
        } else if (this.excavationState == ExcavationState.InProgress) {
            state = this.excavationWorkType == ExcavationWorkType.Mining ? QuarryBlock.DisplayState.Mining : QuarryBlock.DisplayState.ExtractTube;
        } else if (this.excavationState == ExcavationState.Complete) {
            state = QuarryBlock.DisplayState.Complete;
        }
        return state;
    }

    public String getStateName() {
        if (this.excavationWorkType == ExcavationWorkType.ExtractTube && this.excavationState == ExcavationState.InProgress) {
            return ExcavationWorkType.ExtractTube.toString();
        }
        return this.excavationState.toString();
    }

    public void resetOnPlaced() {
        this.setExcavationState(ExcavationState.InProgress);
        this.setExcavationWorkType(ExcavationWorkType.Mining);
        this.setProgress(0L);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity2) {
        super.tick(world, pos, state, blockEntity2);
        if (world.field_9236) {
            return;
        }
        this.charge(11);
        this.refreshUpgrades();
        this.tickQuarryLogic();
        ++this.currentTickTime;
    }

    private void refreshUpgrades() {
        this.rangeExtenderLevel = 0;
        this.fortuneLevel = 0;
        this.isSilkTouch = false;
        this.quarryUpgradesSlotGroup.executeForAll(stack -> {
            if (!stack.method_7960() && stack.method_7909() instanceof IQuarryUpgrade) {
                ((IQuarryUpgrade)stack.method_7909()).process(this, (class_1799)stack);
            }
        });
    }

    private void tickQuarryLogic() {
        if (this.excavationState != ExcavationState.Complete) {
            if (this.miningSpentedEnergy < this.getEnergyPerExcavation()) {
                long euNeeded = this.getEnergyPerExcavation() / (long)this.getTiksPerExcavation();
                long euAvailable = Math.min(euNeeded, this.getStored());
                if ((double)euAvailable > 0.0) {
                    this.useEnergy(euAvailable);
                    this.miningSpentedEnergy += euAvailable;
                    this.setExcavationState(ExcavationState.InProgress);
                } else {
                    this.setExcavationState(ExcavationState.NoEnergyIncome);
                }
            }
            if (this.miningSpentedEnergy >= this.getEnergyPerExcavation()) {
                if (this.excavationWorkType == ExcavationWorkType.ExtractTube) {
                    this.tryDrillOutTube();
                } else {
                    if (this.targetOrePos == null && (this.excavationState == ExcavationState.InProgress || this.excavationState == ExcavationState.NoOreInCurrentPos || this.excavationState == ExcavationState.CannotOutputMineDrop)) {
                        this.targetOrePos = this.findOrePos();
                    }
                    if (this.excavationState == ExcavationState.NoOresInCurrentDepth || this.excavationState == ExcavationState.NotEnoughDrillTube) {
                        this.tryDrillDownTube();
                    } else if (this.targetOrePos != null && (this.excavationState == ExcavationState.InProgress || this.excavationState == ExcavationState.CannotOutputMineDrop)) {
                        this.tryMine(this.targetOrePos, !this.getMineAll());
                    }
                }
                if (this.excavationState == ExcavationState.InProgress) {
                    this.miningSpentedEnergy -= this.getEnergyPerExcavation();
                }
            }
            if (this.excavationState == ExcavationState.InProgress && this.currentTickTime % 20 == 0) {
                RecipeCrafter.soundHanlder.playSound(false, (class_2586)this);
            }
        }
    }

    private class_2338 findOrePos() {
        int radius = (int)Math.round(QMConfig.quarrySqrWorkRadiusByUpgradeLevel.get(this.rangeExtenderLevel));
        class_2338 upperBlockPos = this.field_11867.method_10069(radius, 0, radius);
        class_2338 lowerBlockPos = this.field_11867.method_10069(-radius, 0, -radius);
        class_1923 upperChunkPos = this.field_11863.method_22350(upperBlockPos).method_12004();
        class_1923 lowerChunkPos = this.field_11863.method_22350(lowerBlockPos).method_12004();
        for (int y = this.getDrillTubeDepth(); y < this.field_11867.method_10264(); ++y) {
            for (int chunkX = lowerChunkPos.field_9181; chunkX <= upperChunkPos.field_9181; ++chunkX) {
                for (int chunkZ = lowerChunkPos.field_9180; chunkZ <= upperChunkPos.field_9180; ++chunkZ) {
                    if (!this.field_11863.method_8393(chunkX, chunkZ)) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            class_2338 blockPos;
                            int blockX = chunkX * 16 + x;
                            int blockZ = chunkZ * 16 + z;
                            if (blockX > upperBlockPos.method_10263() || blockZ > upperBlockPos.method_10260() || blockX < lowerBlockPos.method_10263() || blockZ < lowerBlockPos.method_10260() || !this.isOre(blockPos = new class_2338(blockX, y, blockZ))) continue;
                            this.setExcavationState(ExcavationState.InProgress);
                            return blockPos;
                        }
                    }
                }
            }
        }
        this.setExcavationState(ExcavationState.NoOresInCurrentDepth);
        return null;
    }

    private void tryMine(class_2338 blockPos, boolean fillHole) {
        if (!this.isOre(blockPos)) {
            this.setExcavationState(ExcavationState.NoOreInCurrentPos);
            this.targetOrePos = null;
            return;
        }
        List<class_1799> drop = this.getDroppedStacks(this.field_11863.method_8320(blockPos), blockPos);
        if (this.outputSlotGroup.hasSpace(drop)) {
            this.outputSlotGroup.addStacks(drop);
            this.field_11863.method_8650(blockPos, false);
            if (fillHole) {
                this.tryFillHole(blockPos);
            }
            this.targetOrePos = null;
            this.setExcavationState(ExcavationState.InProgress);
        } else {
            this.setExcavationState(ExcavationState.CannotOutputMineDrop);
        }
    }

    private void tryFillHole(class_2338 blockPos) {
        class_1799 blockToPlace = this.holeFillerSlotGroup.consumeAny(1, QuarryBlockEntity::holeFillerFilter);
        if (!blockToPlace.method_7960() && blockToPlace.method_7909() instanceof class_1747) {
            this.field_11863.method_8501(blockPos, ((class_1747)blockToPlace.method_7909()).method_7711().method_9564());
        }
    }

    private int getDrillTubeDepth() {
        boolean hasTubes = false;
        for (int y = this.field_11867.method_10264() - 1; y >= this.field_11863.method_31607(); --y) {
            if (!this.isDrillTube(this.field_11863.method_8320(new class_2338(this.field_11867.method_10263(), y, this.field_11867.method_10260())))) {
                return y + 1;
            }
            hasTubes = true;
        }
        return hasTubes ? this.field_11863.method_31607() : this.field_11867.method_10264();
    }

    private void tryDrillDownTube() {
        class_1799 blockDrop;
        List<class_1799> blockDrops;
        int newDepth = this.getDrillTubeDepth() - 1;
        if (newDepth < this.field_11863.method_31607()) {
            this.setExcavationWorkType(ExcavationWorkType.ExtractTube);
            this.setExcavationState(ExcavationState.InProgress);
            return;
        }
        class_2338 blockPos = new class_2338(this.field_11867.method_10263(), newDepth, this.field_11867.method_10260());
        class_2680 blockState = this.field_11863.method_8320(blockPos);
        class_1799 drillTubeItem = new class_1799((class_1935)class_1792.method_7867((class_2248)QMContent.DRILL_TUBE));
        if (blockState.method_26214((class_1922)this.field_11863, blockPos) < 0.0f) {
            this.setExcavationWorkType(ExcavationWorkType.ExtractTube);
            this.setExcavationState(ExcavationState.InProgress);
            return;
        }
        if (this.drillTubeSlotGroup.isEmpty() || !this.drillTubeSlotGroup.canConsume(drillTubeItem)) {
            this.setExcavationState(ExcavationState.NotEnoughDrillTube);
            return;
        }
        if (this.isOre(blockPos)) {
            this.tryMine(blockPos, false);
            return;
        }
        if (!this.getMineAll() && (blockDrops = this.getDroppedStacks(blockState, blockPos)).size() == 1 && this.holeFillerSlotGroup.hasSpace(blockDrop = blockDrops.get(0)) && QuarryBlockEntity.holeFillerFilter(blockDrop)) {
            this.holeFillerSlotGroup.addStack(blockDrop);
        }
        this.drillTubeSlotGroup.consume(drillTubeItem);
        this.setExcavationState(ExcavationState.InProgress);
        this.field_11863.method_8501(blockPos, QMContent.DRILL_TUBE.method_9564());
    }

    private void tryDrillOutTube() {
        int tubeDepth = this.getDrillTubeDepth();
        if (tubeDepth == this.field_11867.method_10264()) {
            this.setExcavationState(ExcavationState.Complete);
            return;
        }
        class_1799 tubeItem = new class_1799((class_1935)class_1792.method_7867((class_2248)QMContent.DRILL_TUBE));
        if (this.drillTubeSlotGroup.hasSpace(tubeItem)) {
            class_2338 blockPos = new class_2338(this.field_11867.method_10263(), tubeDepth, this.field_11867.method_10260());
            this.field_11863.method_8650(blockPos, false);
            if (!this.getMineAll()) {
                this.tryFillHole(blockPos);
            }
            this.drillTubeSlotGroup.addStack(tubeItem);
        } else {
            this.setExcavationState(ExcavationState.CannotOutputDrillTube);
        }
    }

    private int getTiksPerExcavation() {
        return Math.max((int)((double)QMConfig.quarryTiksPerExcavation * (1.0 - this.getSpeedMultiplier())), QMConfig.quarryMinTiksPerExcavation);
    }

    private long getEnergyPerExcavation() {
        return (long)((double)QMConfig.quarryEnergyPerExcavation * this.getPowerMultiplier());
    }

    private boolean isOre(class_2338 blockPos) {
        class_2680 state = this.field_11863.method_8320(blockPos);
        class_2248 block = state.method_26204();
        return !state.method_26215() && !(block instanceof class_2404) && state.method_26214((class_1922)this.field_11863, blockPos) >= 0.0f && !this.isDrillTube(state) && (this.getMineAll() || this.isOreCheckId(class_2378.field_11146.method_10221((Object)block).toString()));
    }

    boolean isOreCheckId(String id) {
        return id.endsWith("_ore") || QMConfig.quarryAdditioanlBlocksToMine.contains(id);
    }

    private boolean isDrillTube(class_2680 state) {
        return !state.method_26215() && state.method_26204() instanceof BlockDrillTube;
    }

    private List<class_1799> getDroppedStacks(class_2680 blockState, class_2338 blockPos) {
        class_1799 item = class_1802.field_22024.method_7854();
        item.method_7978(class_1893.field_9130, this.fortuneLevel);
        item.method_7978(class_1893.field_9099, this.isSilkTouch ? 1 : 0);
        return class_2248.method_9609((class_2680)blockState, (class_3218)((class_3218)this.field_11863), (class_2338)blockPos, (class_2586)this.field_11863.method_8321(blockPos), null, (class_1799)item);
    }

    public long getBaseMaxPower() {
        return QMConfig.quarryMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return (long)((double)QMConfig.quarryMaxInput * (1.0 + this.getSpeedMultiplier() * QMConfig.quarryMaxInputOverclockerMultipier));
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return QMContent.Machine.QUARRY.getStack();
    }

    public RebornInventory<QuarryBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        ScreenHandlerBuilder screenHandler = new ScreenHandlerBuilder("quarry").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).filterSlot(0, 30, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(1, 48, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(2, 66, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(3, 84, 20, QuarryBlockEntity::holeFillerFilter).filterSlot(4, 121, 20, QuarryBlockEntity::drillTubeFilter).filterSlot(5, 139, 20, QuarryBlockEntity::drillTubeFilter).outputSlot(6, 55, 66).outputSlot(7, 75, 66).outputSlot(8, 95, 66).outputSlot(9, 115, 66).outputSlot(10, 135, 66).energySlot(11, 8, 72).syncEnergyValue().sync(this::getProgress, this::setProgress).sync(this::getState, this::setState).sync(this::getWorkType, this::setWorkType).sync(this::getMiningAll, this::setMiningAll).addInventory();
        try {
            Field slotsField = ScreenHandlerBuilder.class.getDeclaredField("slots");
            slotsField.setAccessible(true);
            List slots = (List)slotsField.get(screenHandler);
            slots.add(new BaseSlot(this.quarryUpgradesInventory, 0, -42, 30, QuarryBlockEntity::quarryUpgradesFilter));
            slots.add(new BaseSlot(this.quarryUpgradesInventory, 1, -42, 48, QuarryBlockEntity::quarryUpgradesFilter));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return screenHandler.create((MachineBaseBlockEntity)this, syncID);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2487 data = tag.method_10562("Quarry");
        this.setState(data.method_10550("state"));
        this.setWorkType(data.method_10550("workType"));
        this.setProgress(data.method_10537("progress"));
        this.setMiningAll(data.method_10550("mineAll"));
        this.quarryUpgradesInventory.read(tag, "quarryUpgradesInventory");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 data = new class_2487();
        data.method_10569("state", this.getState());
        data.method_10569("workType", this.getWorkType());
        data.method_10544("progress", this.getProgress());
        data.method_10569("mineAll", this.getMiningAll());
        tag.method_10566("Quarry", (class_2520)data);
        this.quarryUpgradesInventory.write(tag, "quarryUpgradesInventory");
    }

    private long getProgress() {
        return this.miningSpentedEnergy;
    }

    private void setProgress(long progress) {
        this.miningSpentedEnergy = progress;
    }

    private int getState() {
        return this.excavationState.ordinal();
    }

    private void setState(int state) {
        this.setExcavationState(ExcavationState.values()[state]);
    }

    private int getWorkType() {
        return this.excavationWorkType.ordinal();
    }

    private void setWorkType(int state) {
        this.excavationWorkType = ExcavationWorkType.values()[state];
    }

    private int getMiningAll() {
        return this.getMineAll() ? 1 : 0;
    }

    private void setMiningAll(int mineAll) {
        this.setMineAll(mineAll == 1);
    }

    private static boolean holeFillerFilter(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711().method_9564().method_26207().equals(class_3614.field_15914);
        }
        return false;
    }

    private static boolean drillTubeFilter(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return blockItem.method_7711() instanceof BlockDrillTube;
        }
        return false;
    }

    private static boolean quarryUpgradesFilter(class_1799 stack) {
        return stack.method_7909() instanceof IQuarryUpgrade;
    }

    public static enum ExcavationState {
        InProgress,
        Complete,
        NoEnergyIncome,
        NoOresInCurrentDepth,
        NoOreInCurrentPos,
        CannotOutputMineDrop,
        CannotOutputDrillTube,
        NotEnoughDrillTube;


        public boolean isError() {
            return this.ordinal() >= CannotOutputMineDrop.ordinal();
        }
    }

    public static enum ExcavationWorkType {
        Mining,
        ExtractTube;

    }
}

