/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.api.pipes.item.SpeedUpgrade;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.item.ItemPipeInterface;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ItemNetworkNode
extends PipeNetworkNode {
    final List<ItemConnection> connections = new ArrayList<ItemConnection>();
    int inactiveTicks = 0;

    @Override
    public void updateConnections(class_1937 world, class_2338 pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((class_3218)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, connection.direction)) continue;
                connection.dropUpgrades(world, pos);
                return true;
            }
            return false;
        });
    }

    private boolean canConnect(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 adjPos = pos.method_10093(direction);
        return ItemStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153()) != null;
    }

    @Override
    public PipeEndpointType[] getConnections(class_2338 pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (class_2350 direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.method_10146()] = PipeEndpointType.PIPE;
        }
        for (ItemConnection connection : this.connections) {
            connections[connection.direction.method_10146()] = connection.type;
        }
        return connections;
    }

    @Override
    public void removeConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ItemConnection conn = this.connections.get(i);
            if (conn.direction != direction) continue;
            if (conn.type == PipeEndpointType.BLOCK_IN) {
                conn.type = PipeEndpointType.BLOCK_IN_OUT;
            } else if (conn.type == PipeEndpointType.BLOCK_IN_OUT) {
                conn.type = PipeEndpointType.BLOCK_OUT;
            } else {
                conn.dropUpgrades(world, pos);
                this.connections.remove(i);
            }
            return;
        }
    }

    @Override
    public void addConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(new ItemConnection(direction, PipeEndpointType.BLOCK_IN, 0, -10));
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        for (ItemConnection connection : this.connections) {
            class_2487 connectionTag = new class_2487();
            connectionTag.method_10567("connections", (byte)ItemNetworkNode.encodeConnectionType(connection.type));
            connectionTag.method_10556("whitelist", connection.whitelist);
            connectionTag.method_10569("insertPriority", connection.insertPriority);
            connectionTag.method_10569("extractPriority", connection.extractPriority);
            for (int i = 0; i < 21; ++i) {
                connectionTag.method_10566(Integer.toString(i), (class_2520)connection.stacks[i].method_7953(new class_2487()));
            }
            connectionTag.method_10566("upgradeStack", (class_2520)connection.upgradeStack.method_7953(new class_2487()));
            tag.method_10566(connection.direction.toString(), (class_2520)connectionTag);
        }
        tag.method_10569("inactiveTicks", this.inactiveTicks);
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        for (class_2350 direction : class_2350.values()) {
            if (!tag.method_10545(direction.toString())) continue;
            class_2487 connectionTag = tag.method_10562(direction.toString());
            int insertPriority = connectionTag.method_10550("insertPriority");
            int extractPriority = connectionTag.method_10550("extractPriority");
            if (connectionTag.method_10545("priority")) {
                insertPriority = extractPriority = connectionTag.method_10550("priority");
            }
            ItemConnection connection = new ItemConnection(direction, ItemNetworkNode.decodeConnectionType(connectionTag.method_10571("connections")), insertPriority, extractPriority);
            connection.whitelist = connectionTag.method_10577("whitelist");
            for (int i = 0; i < 21; ++i) {
                connection.stacks[i] = class_1799.method_7915((class_2487)connectionTag.method_10562(Integer.toString(i)));
                connection.stacks[i].method_7939(1);
            }
            connection.refreshStacksCache();
            connection.upgradeStack = class_1799.method_7915((class_2487)connectionTag.method_10562("upgradeStack"));
            this.connections.add(connection);
        }
        this.inactiveTicks = tag.method_10550("inactiveTicks");
    }

    private static PipeEndpointType decodeConnectionType(int i) {
        return i == 0 ? PipeEndpointType.BLOCK_IN : (i == 1 ? PipeEndpointType.BLOCK_IN_OUT : PipeEndpointType.BLOCK_OUT);
    }

    private static int encodeConnectionType(PipeEndpointType connection) {
        return connection == PipeEndpointType.BLOCK_IN ? 0 : (connection == PipeEndpointType.BLOCK_IN_OUT ? 1 : 2);
    }

    @Override
    public ExtendedScreenHandlerFactory getConnectionGui(class_2350 guiDirection, IPipeScreenHandlerHelper helper) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != guiDirection) continue;
            ItemConnection itemConnection = connection;
            Objects.requireNonNull(itemConnection);
            return itemConnection.new ItemConnection.ScreenHandlerFactory(helper, this.getType().getIdentifier());
        }
        return null;
    }

    @Override
    public void appendDroppedStacks(List<class_1799> droppedStacks) {
        for (ItemConnection conn : this.connections) {
            if (conn.upgradeStack.method_7960()) continue;
            droppedStacks.add(conn.upgradeStack);
            conn.upgradeStack = class_1799.field_8037;
        }
    }

    class ItemConnection {
        final class_2350 direction;
        private PipeEndpointType type;
        boolean whitelist = true;
        int insertPriority;
        int extractPriority;
        private final class_1799[] stacks = new class_1799[21];
        final Set<ItemVariant> stacksCache = new HashSet<ItemVariant>();
        private class_1799 upgradeStack = class_1799.field_8037;
        BlockApiCache<Storage<ItemVariant>, class_2350> cache = null;

        private ItemConnection(class_2350 direction, PipeEndpointType type, int insertPriority, int extractPriority) {
            this.direction = direction;
            this.type = type;
            this.insertPriority = insertPriority;
            this.extractPriority = extractPriority;
            for (int i = 0; i < 21; ++i) {
                this.stacks[i] = class_1799.field_8037;
            }
        }

        private void refreshStacksCache() {
            this.stacksCache.clear();
            for (class_1799 stack : this.stacks) {
                if (stack.method_7960()) continue;
                this.stacksCache.add(ItemVariant.of((class_1799)stack));
            }
        }

        boolean canInsert() {
            return this.type == PipeEndpointType.BLOCK_IN || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canExtract() {
            return this.type == PipeEndpointType.BLOCK_OUT || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canStackMoveThrough(ItemVariant key) {
            return this.stacksCache.contains(key) == this.whitelist;
        }

        long getMoves() {
            SpeedUpgrade upgrade = (SpeedUpgrade)SpeedUpgrade.LOOKUP.find(this.upgradeStack, null);
            return 16L + (upgrade == null ? 0L : upgrade.value() * (long)this.upgradeStack.method_7947());
        }

        private void dropUpgrades(class_1937 world, class_2338 pos) {
            if (!this.upgradeStack.method_7960()) {
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), this.upgradeStack));
                this.upgradeStack = class_1799.field_8037;
            }
        }

        private class ScreenHandlerFactory
        implements ExtendedScreenHandlerFactory {
            private final ItemPipeInterface iface;
            private final class_2960 pipeType;

            private ScreenHandlerFactory(final IPipeScreenHandlerHelper helper, class_2960 pipeType) {
                this.iface = new ItemPipeInterface(){

                    @Override
                    public boolean isWhitelist() {
                        return ItemConnection.this.whitelist;
                    }

                    @Override
                    public void setWhitelist(boolean whitelist) {
                        ItemConnection.this.whitelist = whitelist;
                        helper.callMarkDirty();
                    }

                    @Override
                    public class_1799 getStack(int slot) {
                        return ItemConnection.this.stacks[slot];
                    }

                    @Override
                    public void setStack(int slot, class_1799 stack) {
                        ItemConnection.this.stacks[slot] = stack;
                        ItemConnection.this.refreshStacksCache();
                        helper.callMarkDirty();
                    }

                    @Override
                    public class_1799 getUpgradeStack() {
                        return ItemConnection.this.upgradeStack;
                    }

                    @Override
                    public void setUpgradeStack(class_1799 stack) {
                        ItemConnection.this.upgradeStack = stack;
                        helper.callMarkDirty();
                    }

                    @Override
                    public int getConnectionType() {
                        return ItemNetworkNode.encodeConnectionType(ItemConnection.this.type);
                    }

                    @Override
                    public void setConnectionType(int type) {
                        if (0 <= type && type < 3) {
                            ItemConnection.this.type = ItemNetworkNode.decodeConnectionType(type);
                            helper.callMarkDirty();
                            helper.callSync();
                        }
                    }

                    @Override
                    public int getPriority(int channel) {
                        return channel == 0 ? ItemConnection.this.insertPriority : ItemConnection.this.extractPriority;
                    }

                    @Override
                    public void setPriority(int channel, int priority) {
                        if (channel == 0) {
                            ItemConnection.this.insertPriority = priority;
                        } else {
                            ItemConnection.this.extractPriority = priority;
                        }
                        helper.callMarkDirty();
                    }

                    @Override
                    public boolean canUse(class_1657 player) {
                        if (!helper.isWithinUseDistance(player)) {
                            return false;
                        }
                        return helper.doesNodeStillExist(ItemNetworkNode.this) && ItemNetworkNode.this.connections.contains(ItemConnection.this);
                    }
                };
                this.pipeType = pipeType;
            }

            public class_2561 method_5476() {
                return new class_2588("item." + this.pipeType.method_12836() + "." + this.pipeType.method_12832());
            }

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new ItemPipeScreenHandler(syncId, inv, this.iface);
            }

            public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                this.iface.toBuf(packetByteBuf);
            }
        }
    }
}

