/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.UnbuildablePart;
import aztech.modern_industrialization.materials.set.MaterialRawSet;
import aztech.modern_industrialization.textures.TextureHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_1011;

public class RawMetalPart
extends UnbuildablePart<MaterialRawSet> {
    public final boolean isBlock;

    public RawMetalPart(boolean isBlock) {
        super(isBlock ? "raw_metal_block" : "raw_metal");
        this.isBlock = isBlock;
    }

    @Override
    public BuildablePart of(MaterialRawSet set) {
        RegularPart part = new RegularPart(this.key);
        if (this.isBlock) {
            part = part.asBlock(5.0f, 6.0f, 1);
        }
        part = part.withTextureRegister((mtm, partContext, part1, itemPath) -> {
            String template = String.format("modern_industrialization:textures/materialsets/raw/%s.png", set.name + (this.isBlock ? "_block" : ""));
            try {
                class_1011 image = mtm.getAssetAsTexture(template);
                TextureHelper.colorize(image, partContext.getColoramp());
                String texturePath = this.isBlock ? String.format("modern_industrialization:textures/blocks/%s.png", itemPath) : String.format("modern_industrialization:textures/items/%s.png", itemPath);
                mtm.addTexture(texturePath, image);
                image.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        if (this.isBlock) {
            return part.withCustomFormattablePath("raw_%s_block", "raw_%s_blocks");
        }
        return part.withCustomFormattablePath("raw_%s", "raw_%s_ores");
    }

    public List<BuildablePart> ofAll(MaterialRawSet set) {
        return List.of(MIParts.RAW_METAL.of(set), MIParts.RAW_METAL_BLOCK.of(set));
    }
}

