/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialHardness;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import aztech.modern_industrialization.materials.set.MaterialSet;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import aztech.modern_industrialization.textures.coloramp.DefaultColoramp;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2444;

public final class MaterialBuilder {
    private final Map<String, MaterialPart> partsMap = new TreeMap<String, MaterialPart>();
    private final PartContext partContext = new PartContext();
    private final String materialName;
    private final String materialSet;
    private final Coloramp coloramp;
    private final Part mainPart;
    private final MaterialHardness hardness;
    private final Queue<RecipeAction> recipesActions = new LinkedList<RecipeAction>();

    public MaterialBuilder(String materialName, MaterialSet materialSet, Part mainPart, Coloramp coloramp, MaterialHardness hardness) {
        this.materialName = materialName;
        this.materialSet = materialSet.name;
        this.coloramp = coloramp;
        this.mainPart = mainPart;
        this.hardness = hardness;
    }

    public MaterialBuilder(String materialName, MaterialSet materialSet, Part mainPart, int color, MaterialHardness hardness) {
        this(materialName, materialSet, mainPart, new DefaultColoramp(color), hardness);
    }

    public MaterialBuilder(String materialName, MaterialSet materialSet, Coloramp coloramp, MaterialHardness hardness) {
        this(materialName, materialSet, (Part)MIParts.INGOT, coloramp, hardness);
    }

    public MaterialBuilder(String materialName, MaterialSet materialSet, int color, MaterialHardness hardness) {
        this(materialName, materialSet, (Part)MIParts.INGOT, new DefaultColoramp(color), hardness);
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public MaterialBuilder addParts(BuildablePart ... parts) {
        for (BuildablePart part : parts) {
            this.addPart(part.build(this.partContext));
        }
        return this;
    }

    public MaterialBuilder addParts(List<BuildablePart> parts) {
        for (BuildablePart part : parts) {
            this.addPart(part.build(this.partContext));
        }
        return this;
    }

    public MaterialBuilder addParts(MaterialPart ... parts) {
        for (MaterialPart part : parts) {
            this.addPart(part);
        }
        return this;
    }

    public MaterialBuilder removeParts(Part ... parts) {
        for (Part part : parts) {
            this.removePart(part);
        }
        return this;
    }

    private void addPart(MaterialPart part) {
        if (this.partsMap.put(part.getPart().key, part) != null) {
            throw new IllegalStateException("Part " + part.getItemId() + " is already registered for this material!");
        }
    }

    private void removePart(Part part) {
        this.partsMap.remove(part.key);
    }

    public MaterialBuilder overridePart(MaterialPart part) {
        if (this.partsMap.put(part.getPart().key, part) == null) {
            throw new IllegalStateException("Part " + part.getItemId() + " was not already registered for this material!");
        }
        return this;
    }

    @SafeVarargs
    public final MaterialBuilder addRecipes(final Consumer<RecipeContext> ... consumers) {
        this.recipesActions.add(new RecipeAction(){

            @Override
            void apply(RecipeContext recipeContext) {
                for (Consumer consumer : consumers) {
                    consumer.accept(recipeContext);
                }
            }
        });
        return this;
    }

    public MaterialBuilder cancelRecipes(final String ... recipeIds) {
        this.recipesActions.add(new RecipeAction(){

            @Override
            void apply(RecipeContext context) {
                for (String recipeId : recipeIds) {
                    context.removeRecipe(recipeId);
                }
            }
        });
        return this;
    }

    public final Material build(RegisteringEvent ... events) {
        RegisteringContext context = new RegisteringContext();
        for (MaterialPart part : this.partsMap.values()) {
            part.register(context);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            part.registerClient();
        }
        for (RegisteringEvent event : events) {
            event.onRegister(context);
        }
        return new Material(this.materialName, Collections.unmodifiableMap(this.partsMap), this::buildRecipes);
    }

    public void buildRecipes(Consumer<class_2444> consumer) {
        HashMap<String, MaterialRecipeBuilder> recipesMap = new HashMap<String, MaterialRecipeBuilder>();
        RecipeContext recipeContext = new RecipeContext(recipesMap);
        for (RecipeAction action : this.recipesActions) {
            action.apply(recipeContext);
        }
        for (MaterialRecipeBuilder builder : recipesMap.values()) {
            builder.save(consumer);
        }
    }

    public class PartContext {
        public Coloramp getColoramp() {
            return MaterialBuilder.this.coloramp;
        }

        public String getMaterialName() {
            return MaterialBuilder.this.materialName;
        }

        public String getMaterialSet() {
            return MaterialBuilder.this.materialSet;
        }

        public Part getMainPart() {
            return MaterialBuilder.this.mainPart;
        }
    }

    public class RegisteringContext {
        public MaterialPart getMaterialPart(Part part) {
            return MaterialBuilder.this.partsMap.get(part.key);
        }
    }

    @FunctionalInterface
    public static interface RegisteringEvent {
        public void onRegister(RegisteringContext var1);
    }

    public class RecipeContext {
        private final Map<String, MaterialRecipeBuilder> recipesMap;

        public RecipeContext(Map<String, MaterialRecipeBuilder> recipesMap) {
            this.recipesMap = recipesMap;
        }

        public void addRecipe(MaterialRecipeBuilder builder) {
            if (this.recipesMap.containsKey(builder.getRecipeId())) {
                if (this.recipesMap.get(builder.getRecipeId()).isCanceled()) {
                    this.recipesMap.remove(builder.getRecipeId());
                } else {
                    throw new IllegalStateException("Duplicate registration of recipe " + builder.getRecipeId() + " for Material : " + this.getMaterialName());
                }
            }
            this.recipesMap.put(builder.getRecipeId(), builder);
        }

        public void removeRecipe(String recipeId) {
            if (this.recipesMap.remove(recipeId) == null) {
                throw new IllegalArgumentException("Recipe does not exist and cannot be cancelled: " + recipeId + " for Material : " + MaterialBuilder.this.materialName);
            }
        }

        public MaterialPart getPart(Part part) {
            return MaterialBuilder.this.partsMap.get(part.key);
        }

        public String getMaterialName() {
            return MaterialBuilder.this.materialName;
        }

        public Part getMainPart() {
            return MaterialBuilder.this.mainPart;
        }

        public MaterialHardness getHardness() {
            return MaterialBuilder.this.hardness;
        }
    }

    public abstract class RecipeAction {
        abstract void apply(RecipeContext var1);
    }
}

