/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasingModel;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class MachineCasings {
    public static final Map<String, MachineCasing> registeredCasings = new HashMap<String, MachineCasing>();
    public static final MachineCasing BRICKED_BRONZE = MachineCasings.create("bricked_bronze");
    public static final MachineCasing BRICKED_STEEL = MachineCasings.create("bricked_steel");
    public static final MachineCasing BRICKS = MachineCasings.create("bricks");
    public static final MachineCasing BRONZE = MachineCasings.create("bronze");
    public static final MachineCasing BRONZE_PLATED_BRICKS = MachineCasings.create("bronze_plated_bricks");
    public static final MachineCasing CLEAN_STAINLESS_STEEL = MachineCasings.create("clean_stainless_steel_machine_casing");
    public static final MachineCasing STAINLESS_STEEL_PIPE = MachineCasings.create("stainless_steel_machine_casing_pipe");
    public static final MachineCasing FIREBRICKS = MachineCasings.create("firebricks");
    public static final MachineCasing FROSTPROOF = MachineCasings.create("frostproof_machine_casing");
    public static final MachineCasing HEATPROOF = MachineCasings.create("heatproof_machine_casing");
    public static final MachineCasing STEEL = MachineCasings.create("steel");
    public static final MachineCasing STEEL_CRATE = MachineCasings.create("steel_crate");
    public static final MachineCasing LV = MachineCasings.create("lv");
    public static final MachineCasing MV = MachineCasings.create("mv");
    public static final MachineCasing HV = MachineCasings.create("hv");
    public static final MachineCasing EV = MachineCasings.create("ev");
    public static final MachineCasing SUPERCONDUCTOR = MachineCasings.create("superconductor");
    public static final MachineCasing TITANIUM = MachineCasings.create("titanium");
    public static final MachineCasing TITANIUM_PIPE = MachineCasings.create("titanium_machine_casing_pipe");
    public static final MachineCasing SOLID_TITANIUM = MachineCasings.create("solid_titanium_machine_casing");
    public static final MachineCasing NUCLEAR = MachineCasings.create("nuclear_casing");
    public static final MachineCasing PLASMA_HANDLING_IRIDIUM = MachineCasings.create("plasma_handling_iridium_machine_casing");

    public static MachineCasing casingFromCableTier(CableTier tier) {
        if (tier == CableTier.LV) {
            return LV;
        }
        if (tier == CableTier.MV) {
            return MV;
        }
        if (tier == CableTier.HV) {
            return HV;
        }
        if (tier == CableTier.EV) {
            return EV;
        }
        if (tier == CableTier.SUPERCONDUCTOR) {
            return SUPERCONDUCTOR;
        }
        return null;
    }

    private static MachineCasing create(String name) {
        MachineCasing casing = new MachineCasing(name);
        registeredCasings.put(name, casing);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            casing.mcm = new MachineCasingModel(name);
        }
        return casing;
    }

    public static MachineCasing get(String name) {
        MachineCasing casing = registeredCasings.get(name);
        if (casing != null) {
            return casing;
        }
        throw new IllegalArgumentException("Machine casing model \"" + name + "\" does not exist.");
    }
}

