/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class TemperatureBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;
        public final int temperatureMax;

        public Parameters(int renderX, int renderY, int temperatureMax) {
            this.renderX = renderX;
            this.renderY = renderY;
            this.temperatureMax = temperatureMax;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        public final Parameters params;
        public int temperature;

        public Client(class_2540 buf) {
            this.params = new Parameters(buf.readInt(), buf.readInt(), buf.readInt());
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.temperature = buf.readInt();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            private final MIIdentifier TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
            private final int WIDTH = 100;
            private final int HEIGHT = 2;

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE);
                class_332.method_25291((class_4587)matrices, (int)(x + Client.this.params.renderX - 1), (int)(y + Client.this.params.renderY - 1), (int)helper.method_25305(), (float)0.0f, (float)2.0f, (int)102, (int)4, (int)102, (int)6);
                int barPixels = (int)((float)Client.this.temperature / (float)Client.this.params.temperatureMax * 100.0f);
                class_332.method_25291((class_4587)matrices, (int)(x + Client.this.params.renderX), (int)(y + Client.this.params.renderY), (int)helper.method_25305(), (float)0.0f, (float)0.0f, (int)barPixels, (int)2, (int)102, (int)6);
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                helper.method_25302(matrices, x + Client.this.params.renderX - 22, y + Client.this.params.renderY + 1 - 10, 144, 0, 20, 20);
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(Client.this.params.renderX, Client.this.params.renderY, 100, 2, cursorX - x, cursorY - y)) {
                    ArrayList<class_2588> tooltip = new ArrayList<class_2588>();
                    tooltip.add(new class_2588("text.modern_industrialization.temperature", new Object[]{Client.this.temperature}));
                    screen.method_30901(matrices, tooltip, cursorX, cursorY);
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Integer> {
        private final Parameters params;
        private final Supplier<Integer> temperatureSupplier;

        public Server(Parameters params, Supplier<Integer> temperatureSupplier) {
            this.params = params;
            this.temperatureSupplier = temperatureSupplier;
        }

        @Override
        public Integer copyData() {
            return this.temperatureSupplier.get();
        }

        @Override
        public boolean needsSync(Integer cachedData) {
            return !cachedData.equals(this.temperatureSupplier.get());
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            buf.writeInt(this.params.temperatureMax);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            buf.writeInt(this.temperatureSupplier.get().intValue());
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.TEMPERATURE_BAR;
        }
    }
}

