/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class CraftingMultiblockGui {
    public static final int X = 4;
    public static final int Y = 16;
    public static final int W = 166;
    public static final int H = 80;

    private static class Data {
        final boolean isShapeValid;
        final boolean hasActiveRecipe;
        final float progress;
        final int efficiencyTicks;
        final int maxEfficiencyTicks;
        final long currentRecipeEu;
        final long baseRecipeEu;

        private Data() {
            this(false);
        }

        private Data(boolean isShapeValid) {
            this.isShapeValid = isShapeValid;
            this.hasActiveRecipe = false;
            this.efficiencyTicks = 0;
            this.progress = 0.0f;
            this.maxEfficiencyTicks = 0;
            this.currentRecipeEu = 0L;
            this.baseRecipeEu = 0L;
        }

        private Data(float progress, int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu) {
            this.efficiencyTicks = efficiencyTicks;
            this.progress = progress;
            this.maxEfficiencyTicks = maxEfficiencyTicks;
            this.isShapeValid = true;
            this.hasActiveRecipe = true;
            this.currentRecipeEu = currentRecipeEu;
            this.baseRecipeEu = baseRecipeEu;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        public boolean isShapeValid;
        boolean hasActiveRecipe;
        float progress;
        int efficiencyTicks;
        int maxEfficiencyTicks;
        long currentRecipeEu;
        long baseRecipeEu;

        public Client(class_2540 buf) {
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.isShapeValid = buf.readBoolean();
            if (this.isShapeValid) {
                this.hasActiveRecipe = buf.readBoolean();
                if (this.hasActiveRecipe) {
                    this.progress = buf.readFloat();
                    this.efficiencyTicks = buf.readInt();
                    this.maxEfficiencyTicks = buf.readInt();
                    this.currentRecipeEu = buf.readLong();
                    this.baseRecipeEu = buf.readLong();
                }
            }
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            private final MIIdentifier texture = new MIIdentifier("textures/gui/container/multiblock_info.png");

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                class_310 minecraftClient = class_310.method_1551();
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
                class_332.method_25290((class_4587)matrices, (int)(x + 4), (int)(y + 16), (float)0.0f, (float)0.0f, (int)166, (int)80, (int)166, (int)80);
                class_327 textRenderer = minecraftClient.field_1772;
                textRenderer.method_30883(matrices, (class_2561)new class_2588(Client.this.isShapeValid ? "text.modern_industrialization.multiblock_shape_valid" : "text.modern_industrialization.multiblock_shape_invalid"), (float)(x + 9), (float)(y + 23), Client.this.isShapeValid ? 0xFFFFFF : 0xFF0000);
                if (Client.this.isShapeValid) {
                    textRenderer.method_30883(matrices, (class_2561)new class_2588(Client.this.hasActiveRecipe ? "text.modern_industrialization.multiblock_status_active" : "text.modern_industrialization.multiblock_status_inactive"), (float)(x + 9), (float)(y + 34), 0xFFFFFF);
                    if (Client.this.hasActiveRecipe) {
                        textRenderer.method_30883(matrices, (class_2561)new class_2588("text.modern_industrialization.progress", new Object[]{String.format("%.1f", Float.valueOf(Client.this.progress * 100.0f)) + " %"}), (float)(x + 9), (float)(y + 45), 0xFFFFFF);
                        textRenderer.method_30883(matrices, (class_2561)new class_2588("text.modern_industrialization.efficiency_ticks", new Object[]{Client.this.efficiencyTicks, Client.this.maxEfficiencyTicks}), (float)(x + 9), (float)(y + 56), 0xFFFFFF);
                        textRenderer.method_30883(matrices, (class_2561)new class_2588("text.modern_industrialization.base_eu_recipe", new Object[]{TextHelper.getEuTextTick(Client.this.baseRecipeEu)}), (float)(x + 9), (float)(y + 67), 0xFFFFFF);
                        textRenderer.method_30883(matrices, (class_2561)new class_2588("text.modern_industrialization.current_eu_recipe", new Object[]{TextHelper.getEuTextTick(Client.this.currentRecipeEu)}), (float)(x + 9), (float)(y + 78), 0xFFFFFF);
                    }
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Data> {
        private final CrafterComponent crafter;
        private final Supplier<Boolean> isShapeValid;
        private final Supplier<Float> progressSupplier;

        public Server(Supplier<Boolean> isShapeValid, Supplier<Float> progressSupplier, CrafterComponent crafter) {
            this.isShapeValid = isShapeValid;
            this.crafter = crafter;
            this.progressSupplier = progressSupplier;
        }

        @Override
        public Data copyData() {
            if (this.isShapeValid.get().booleanValue()) {
                if (this.crafter.hasActiveRecipe()) {
                    return new Data(this.progressSupplier.get().floatValue(), this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu());
                }
                return new Data(true);
            }
            return new Data();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            boolean recipe = false;
            if (this.crafter.hasActiveRecipe()) {
                recipe = this.crafter.getCurrentRecipeEu() != cachedData.currentRecipeEu || this.crafter.getBaseRecipeEu() != cachedData.baseRecipeEu;
            }
            return cachedData.isShapeValid != this.isShapeValid.get() || cachedData.hasActiveRecipe != this.crafter.hasActiveRecipe() || cachedData.progress != this.progressSupplier.get().floatValue() || this.crafter.getEfficiencyTicks() != cachedData.efficiencyTicks || this.crafter.getMaxEfficiencyTicks() != cachedData.maxEfficiencyTicks || recipe;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            if (this.isShapeValid.get().booleanValue()) {
                buf.writeBoolean(true);
                if (this.crafter.hasActiveRecipe()) {
                    buf.writeBoolean(true);
                    buf.writeFloat(this.progressSupplier.get().floatValue());
                    buf.writeInt(this.crafter.getEfficiencyTicks());
                    buf.writeInt(this.crafter.getMaxEfficiencyTicks());
                    buf.writeLong(this.crafter.getCurrentRecipeEu());
                    buf.writeLong(this.crafter.getBaseRecipeEu());
                } else {
                    buf.writeBoolean(false);
                }
            } else {
                buf.writeBoolean(false);
            }
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.CRAFTING_MULTIBLOCK_GUI;
        }
    }
}

