/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.GunpowderOverclockComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class SteamCraftingMultiblockBlockEntity
extends AbstractCraftingMultiblockBlockEntity {
    private final GunpowderOverclockComponent gunpowderOverclock;
    private final MachineRecipeType recipeType;
    private boolean steelTier;

    public SteamCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, MachineRecipeType recipeType) {
        super(bep, name, new OrientationComponent.Params(false, false, false), new ShapeTemplate[]{shapeTemplate});
        this.recipeType = recipeType;
        this.gunpowderOverclock = new GunpowderOverclockComponent();
        this.registerComponents(this.gunpowderOverclock);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.steelTier = false;
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            if (!hatch.upgradesToSteel()) continue;
            this.steelTier = true;
        }
    }

    @Override
    public final void tickExtra() {
        this.gunpowderOverclock.tick(this);
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            return this.gunpowderOverclock.onUse(this, player, hand);
        }
        return result;
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            return SteamHelper.consumeSteamEu(SteamCraftingMultiblockBlockEntity.this.inventory.getFluidInputs(), max, simulation);
        }

        @Override
        public MachineRecipeType recipeType() {
            return SteamCraftingMultiblockBlockEntity.this.recipeType;
        }

        @Override
        public long getBaseRecipeEu() {
            return (SteamCraftingMultiblockBlockEntity.this.steelTier ? 4 : 2) * (SteamCraftingMultiblockBlockEntity.this.gunpowderOverclock.isOverclocked() ? 2 : 1);
        }

        @Override
        public long getMaxRecipeEu() {
            return this.getBaseRecipeEu();
        }

        @Override
        public class_1937 getCrafterWorld() {
            return SteamCraftingMultiblockBlockEntity.this.field_11863;
        }

        @Override
        @Nullable
        public UUID getOwnerUuid() {
            return SteamCraftingMultiblockBlockEntity.this.placedBy.placerId;
        }
    }
}

