/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.ScrewdriverableBlockEntity;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.hatches.NuclearHatch;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.IntegerHistoryComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.NuclearReactorGui;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.nuclear.INuclearGrid;
import aztech.modern_industrialization.nuclear.INuclearTile;
import aztech.modern_industrialization.nuclear.NeutronFate;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearGridHelper;
import aztech.modern_industrialization.util.Tickable;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_3965;

public class NuclearReactorMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
ScrewdriverableBlockEntity {
    private static final ShapeTemplate[] shapeTemplates = new ShapeTemplate[4];
    private static final boolean[][][] gridLayout = new boolean[4][][];
    private final ActiveShapeComponent activeShape = new ActiveShapeComponent(shapeTemplates);
    private final IsActiveComponent isActive;
    private final IntegerHistoryComponent efficiencyHistory = new IntegerHistoryComponent(new String[]{"euProduction", "euFuelConsumption"}, 300);
    private ShapeMatcher shapeMatcher;
    private INuclearGrid nuclearGrid;
    private Supplier<NuclearReactorGui.Data> dataSupplier;

    public NuclearReactorMultiblockBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("nuclear_reactor", false).backgroundHeight(256).build(), new OrientationComponent.Params(false, false, false));
        this.isActive = new IsActiveComponent();
        this.registerComponents(this.activeShape, this.isActive, this.efficiencyHistory);
        this.registerClientComponent(new NuclearReactorGui.Server(this::sendData));
    }

    public NuclearReactorGui.Data sendData() {
        if (this.shapeValid.shapeValid) {
            return this.dataSupplier.get();
        }
        return new NuclearReactorGui.Data(false, 0, 0, null, 0.0, 0.0);
    }

    @Override
    public boolean useScrewdriver(class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.useScrewdriver(this.activeShape, player, hand, hitResult);
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActive.isActive);
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            if (this.shapeValid.shapeValid) {
                this.isActive.updateActive(NuclearGridHelper.simulate(this.nuclearGrid), this);
                this.efficiencyHistory.tick();
            } else {
                this.isActive.updateActive(false, this);
                this.efficiencyHistory.clear();
            }
        }
    }

    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.shapeValid.shapeValid = true;
        final int size = gridLayout[this.activeShape.getActiveShapeIndex()].length;
        final NuclearHatch[][] hatchesGrid = new NuclearHatch[size][size];
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            int x0 = hatch.method_11016().method_10263() - this.method_11016().method_10263();
            int z0 = hatch.method_11016().method_10260() - this.method_11016().method_10260();
            if (this.orientation.facingDirection == class_2350.field_11043) {
                x = size / 2 + x0;
                y = z0;
            } else if (this.orientation.facingDirection == class_2350.field_11035) {
                x = size / 2 - x0;
                y = -z0;
            } else if (this.orientation.facingDirection == class_2350.field_11034) {
                x = size / 2 + z0;
                y = -x0;
            } else {
                x = size / 2 - z0;
                y = x0;
            }
            hatchesGrid[x][y] = (NuclearHatch)hatch;
        }
        this.nuclearGrid = new INuclearGrid(){

            @Override
            public int getSizeX() {
                return size;
            }

            @Override
            public int getSizeY() {
                return size;
            }

            @Override
            public Optional<INuclearTile> getNuclearTile(int x, int y) {
                return Optional.ofNullable(hatchesGrid[x][y]);
            }

            @Override
            public void registerNeutronFate(int neutronNumber, NeutronType type, NeutronFate escape) {
            }

            @Override
            public void registerNeutronCreation(int neutronNumber, NeutronType type) {
            }

            @Override
            public void registerEuFuelConsumption(double eu) {
                NuclearReactorMultiblockBlockEntity.this.efficiencyHistory.addValue("euFuelConsumption", (int)eu);
            }

            @Override
            public void registerEuProduction(double eu) {
                NuclearReactorMultiblockBlockEntity.this.efficiencyHistory.addValue("euProduction", (int)eu);
            }
        };
        this.dataSupplier = () -> {
            Optional[] tilesData = new Optional[size * size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    int x = size - 1 - i;
                    int y = size - 1 - j;
                    int index = NuclearReactorGui.Data.toIndex(i, j, size);
                    tilesData[index] = Optional.ofNullable(hatchesGrid[x][y]);
                }
            }
            return new NuclearReactorGui.Data(true, size, size, tilesData, this.efficiencyHistory.getAverage("euProduction"), this.efficiencyHistory.getAverage("euFuelConsumption"));
        };
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.field_11863, this.field_11867, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.field_11863);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.nuclearGrid = null;
            this.shapeMatcher.rematch(this.field_11863);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.shapeValid.shapeValid = true;
                this.onSuccessfulMatch(this.shapeMatcher);
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    protected final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.field_11863);
            this.shapeMatcher = null;
        }
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : shapeTemplates) {
            ReiMachineRecipes.registerMultiblockShape("nuclear_reactor", shapeTemplate);
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((class_2248)MIBlock.blocks.get("nuclear_casing"));
        SimpleMember pipe = SimpleMember.forBlock((class_2248)MIBlock.blocks.get("nuclear_alloy_machine_casing_pipe"));
        HatchFlags top = new HatchFlags.Builder().with(HatchType.NUCLEAR_FLUID, HatchType.NUCLEAR_ITEM).build();
        for (int i = 0; i < 4; ++i) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.NUCLEAR);
            NuclearReactorMultiblockBlockEntity.gridLayout[i] = new boolean[5 + 2 * i][5 + 2 * i];
            for (int x = -2 - i; x <= 2 + i; ++x) {
                int xAbs = Math.abs(x);
                int minZ = i != 3 ? (xAbs == 0 ? 0 : xAbs - 1) : (xAbs <= 1 ? 0 : xAbs - 2);
                int maxZ = 2 * (2 + i) - minZ;
                for (int z = minZ; z <= maxZ; ++z) {
                    NuclearReactorMultiblockBlockEntity.gridLayout[i][2 + i + x][z] = true;
                    if (z != minZ && z != maxZ && xAbs != 2 + i) {
                        builder.add(x, -1, z, casing, null);
                        builder.add(x, 0, z, pipe, null);
                        builder.add(x, 1, z, pipe, null);
                        builder.add(x, 2, z, pipe, null);
                        builder.add(x, 3, z, casing, top);
                        continue;
                    }
                    builder.add(x, -1, z, casing, null);
                    if (x != 0 || z != 0) {
                        builder.add(x, 0, z, casing, null);
                    }
                    builder.add(x, 1, z, casing, null);
                    builder.add(x, 2, z, casing, null);
                    builder.add(x, 3, z, casing, null);
                }
            }
            NuclearReactorMultiblockBlockEntity.shapeTemplates[i] = builder.build();
        }
    }
}

