/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.ScrewdriverableBlockEntity;
import aztech.modern_industrialization.compat.megane.holder.CrafterComponentHolder;
import aztech.modern_industrialization.compat.megane.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.components.sync.ReiSlotLocking;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
ScrewdriverableBlockEntity,
MultiblockInventoryComponentHolder,
CrafterComponentHolder {
    @Nullable
    private ShapeMatcher shapeMatcher = null;
    private boolean allowNormalOperation = false;
    protected final ActiveShapeComponent activeShape;
    protected final MultiblockInventoryComponent inventory;
    protected final CrafterComponent crafter;
    private final IsActiveComponent isActive;

    public AbstractCraftingMultiblockBlockEntity(BEP bep, String name, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(200).build(), orientationParams);
        this.activeShape = new ActiveShapeComponent(shapeTemplates);
        this.inventory = new MultiblockInventoryComponent();
        this.crafter = new CrafterComponent(this.inventory, this.getBehavior());
        this.isActive = new IsActiveComponent();
        this.registerClientComponent(new CraftingMultiblockGui.Server(() -> this.shapeValid.shapeValid, this.crafter::getProgress, this.crafter));
        this.registerClientComponent(new ReiSlotLocking.Server(this.crafter::lockRecipe, () -> this.allowNormalOperation));
        this.registerComponents(this.activeShape, this.crafter, this.isActive);
    }

    protected abstract CrafterComponent.Behavior getBehavior();

    protected abstract void onSuccessfulMatch(ShapeMatcher var1);

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    @Override
    public MultiblockInventoryComponent getMultiblockInventoryComponent() {
        return this.inventory;
    }

    @Override
    public CrafterComponent getCrafterComponent() {
        return this.crafter;
    }

    @Override
    public boolean useScrewdriver(class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.useScrewdriver(this.activeShape, player, hand, hitResult);
    }

    @Override
    public final MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActive.isActive);
    }

    @Override
    public final void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            boolean newActive = false;
            if (this.allowNormalOperation) {
                if (this.crafter.tickRecipe()) {
                    newActive = true;
                }
            } else {
                this.crafter.decreaseEfficiencyTicks();
            }
            this.isActive.updateActive(newActive, this);
        }
        this.tickExtra();
    }

    public void tickExtra() {
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.field_11863, this.field_11867, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.field_11863);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.allowNormalOperation = false;
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.field_11863);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.inventory.rebuild(this.shapeMatcher);
                this.onSuccessfulMatch(this.shapeMatcher);
                this.shapeValid.shapeValid = true;
                if (this.crafter.tryContinueRecipe()) {
                    this.allowNormalOperation = true;
                }
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    protected final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.field_11863);
            this.shapeMatcher = null;
        }
    }
}

