/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.AutoExtract;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.List;

public class ItemHatch
extends HatchBlockEntity {
    private final boolean input;
    private final boolean upgradesToSteel;
    private final MIInventory inventory;

    public ItemHatch(BEP bep, MachineGuiParameters guiParams, boolean input, boolean upgradesToSteel, MIInventory inventory) {
        super(bep, guiParams, new OrientationComponent.Params(true, true, false));
        this.input = input;
        this.upgradesToSteel = upgradesToSteel;
        this.inventory = inventory;
        this.registerComponents(inventory);
        this.registerClientComponent(new AutoExtract.Server(this.orientation, input));
    }

    @Override
    public HatchType getHatchType() {
        return this.input ? HatchType.ITEM_INPUT : HatchType.ITEM_OUTPUT;
    }

    @Override
    public boolean upgradesToSteel() {
        return this.upgradesToSteel;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void appendItemInputs(List<ConfigurableItemStack> list) {
        if (this.input) {
            list.addAll(this.inventory.getItemStacks());
        }
    }

    @Override
    public void appendItemOutputs(List<ConfigurableItemStack> list) {
        if (!this.input) {
            list.addAll(this.inventory.getItemStacks());
        }
    }

    @Override
    protected void tickTransfer() {
        if (this.orientation.extractItems) {
            if (this.input) {
                this.inventory.autoInsertItems(this.field_11863, this.field_11867, this.orientation.outputDirection);
            } else {
                this.inventory.autoExtractItems(this.field_11863, this.field_11867, this.orientation.outputDirection);
            }
        }
    }
}

