/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.components.GunpowderOverclockComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.sync.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;

public class SteamCraftingMachineBlockEntity
extends AbstractCraftingMachineBlockEntity {
    private final GunpowderOverclockComponent gunpowderOverclock = new GunpowderOverclockComponent();

    public SteamCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, ProgressBar.Parameters progressBarParams, MachineTier tier) {
        super(bep, recipeType, inventory, guiParams, progressBarParams, tier);
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(progressBarParams.renderX, progressBarParams.renderY + 20);
        this.registerClientComponent(new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, () -> this.gunpowderOverclock.overclockGunpowderTick));
        this.registerComponents(this.gunpowderOverclock);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu(this.getInventory().getFluidStacks(), max, simulation);
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            return this.gunpowderOverclock.onUse(this, player, hand);
        }
        return result;
    }

    @Override
    public long getMaxRecipeEu() {
        if (this.gunpowderOverclock.isOverclocked()) {
            return (long)this.tier.getMaxEu() * 2L;
        }
        return this.tier.getMaxEu();
    }

    @Override
    public long getBaseRecipeEu() {
        if (this.gunpowderOverclock.isOverclocked()) {
            return (long)this.tier.getBaseEu() * 2L;
        }
        return this.tier.getBaseEu();
    }

    @Override
    public void tick() {
        super.tick();
        this.gunpowderOverclock.tick(this);
    }
}

