/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.AutoExtract;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.ResourceUtil;
import aztech.modern_industrialization.util.Tickable;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3611;

public class ReplicatorMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final IsActiveComponent isActiveComponent = new IsActiveComponent();
    private final MachineInventoryComponent inventoryComponent;
    private int progressTick = 0;
    private static class_3494<class_1792> blacklisted;

    public static void initTag() {
        MIIdentifier blacklist = new MIIdentifier("replicator_blacklist");
        blacklisted = TagRegistry.item((class_2960)blacklist);
        ResourceUtil.appendToItemTag(blacklist, new class_2960("minecraft", "bundle"));
        ResourceUtil.appendTagToItemTag(blacklist, new class_2960("c", "shulker_box"));
        ResourceUtil.appendTagToItemTag(blacklist, new MIIdentifier("tanks"));
        ResourceUtil.appendTagToItemTag(blacklist, new MIIdentifier("barrels"));
    }

    public ReplicatorMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("replicator", true).build(), new OrientationComponent.Params(true, true, false));
        ProgressBar.Parameters progressBarParams = new ProgressBar.Parameters(85, 34, "arrow");
        long capacity = 20736000L;
        List<ConfigurableFluidStack> fluidInput = Collections.singletonList(ConfigurableFluidStack.lockedInputSlot(capacity, MIFluids.UU_MATER));
        List<ConfigurableItemStack> itemInputs = Collections.singletonList(ConfigurableItemStack.standardInputSlot());
        List<ConfigurableItemStack> itemOutputs = Collections.singletonList(ConfigurableItemStack.standardOutputSlot());
        SlotPositions fluidSlotPositions = new SlotPositions.Builder().addSlot(35, 35).build();
        SlotPositions itemSlotPositions = new SlotPositions.Builder().addSlot(60, 35).addSlot(115, 35).build();
        this.inventoryComponent = new MachineInventoryComponent(itemInputs, itemOutputs, fluidInput, Collections.emptyList(), itemSlotPositions, fluidSlotPositions);
        this.registerComponents(this.isActiveComponent, this.inventoryComponent, new IComponent(){

            @Override
            public void writeNbt(class_2487 tag) {
                tag.method_10569("progressTick", ReplicatorMachineBlockEntity.this.progressTick);
            }

            @Override
            public void readNbt(class_2487 tag) {
                ReplicatorMachineBlockEntity.this.progressTick = tag.method_10550("progressTick");
            }
        });
        this.registerClientComponent(new ProgressBar.Server(progressBarParams, () -> Float.valueOf((float)this.progressTick / 20.0f)));
        this.registerClientComponent(new AutoExtract.Server(this.orientation, false));
    }

    @Override
    public MIInventory getInventory() {
        return this.inventoryComponent.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public boolean replicationStep(boolean simulate) {
        ItemVariant itemVariant = (ItemVariant)this.inventoryComponent.getItemInputs().get(0).getResource();
        if (!itemVariant.isBlank()) {
            Transaction tx;
            if (blacklisted.method_15141((Object)itemVariant.getItem())) {
                return false;
            }
            Storage fluidItem = (Storage)ContainerItemContext.withInitial((ItemVariant)itemVariant, (long)1L).find(FluidStorage.ITEM);
            if (fluidItem != null) {
                tx = Transaction.openOuter();
                try {
                    for (StorageView view : fluidItem.iterable((TransactionContext)tx)) {
                        if (!((FluidVariant)view.getResource()).isOf((Object)MIFluids.UU_MATER)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            tx = Transaction.openOuter();
            try {
                MIItemStorage itemStorage = new MIItemStorage(this.inventoryComponent.getItemOutputs());
                MIFluidStorage fluidStorage = new MIFluidStorage(this.inventoryComponent.getFluidInputs());
                long inserted = itemStorage.insertAllSlot(itemVariant, 1L, (TransactionContext)tx);
                long uuMatterExtraced = fluidStorage.extractAllSlot(FluidVariant.of((class_3611)MIFluids.UU_MATER), 8100L, (TransactionContext)tx);
                if (inserted == 1L && uuMatterExtraced == 8100L) {
                    if (!simulate) {
                        tx.commit();
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        return false;
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            if (this.replicationStep(true)) {
                ++this.progressTick;
                this.isActiveComponent.updateActive(true, this);
                if (this.progressTick == 20) {
                    this.replicationStep(false);
                    this.progressTick = 0;
                }
            } else {
                this.isActiveComponent.updateActive(false, this);
                this.progressTick = 0;
            }
            if (this.orientation.extractItems) {
                this.inventoryComponent.inventory.autoExtractItems(this.field_11863, this.field_11867, this.orientation.outputDirection);
            }
            this.method_5431();
        }
    }
}

