/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.api.DynamicEnchantmentItem;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import draylar.magna.Magna;
import draylar.magna.api.MagnaTool;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.tool.attribute.v1.DynamicAttributeTool;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class SteamDrillItem
extends class_1792
implements DynamicAttributeTool,
MagnaTool,
DynamicEnchantmentItem,
ItemContainingItemHelper,
FabricItem {
    private static final int FULL_WATER = 18000;

    public SteamDrillItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7894(class_1814.field_8907));
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return this.canUse(newStack);
    }

    public int getMiningLevel(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
        if (tag.method_15141((Object)this) && this.canUse(stack)) {
            return 2;
        }
        return 0;
    }

    public float getMiningSpeedMultiplier(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
        float speed = 1.0f;
        if (tag.method_15141((Object)this) && this.canUse(stack)) {
            speed = 4.0f;
        }
        class_1657 player = CommonProxy.INSTANCE.findUser(user);
        if (Magna.CONFIG.breakSingleBlockWhenSneaking && player != null && player.method_5715()) {
            speed *= 4.0f;
        }
        return speed;
    }

    public Multimap<class_1320, class_1322> getDynamicModifiers(class_1304 slot, class_1799 stack, @Nullable class_1309 user) {
        if (slot == class_1304.field_6173 && this.canUse(stack)) {
            return ItemHelper.createToolModifiers(5.0);
        }
        return EMPTY;
    }

    public int getRadius(class_1799 stack) {
        return 1;
    }

    public boolean playBreakEffects() {
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        this.useFuel(stack);
        return true;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        this.useFuel(stack);
        return true;
    }

    private void useFuel(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10550("water") > 0 && tag.method_10550("burnTicks") == 0) {
            int burnTicks = this.consumeFuel(stack, Simulation.ACT);
            tag.method_10569("burnTicks", burnTicks);
            tag.method_10569("maxBurnTicks", burnTicks);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_3965 hitResult = SteamDrillItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1347);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)itemStack);
        }
        class_3610 fluidState = world.method_8316(hitResult.method_17777());
        if (fluidState.method_15772() == class_3612.field_15910 || fluidState.method_15772() == class_3612.field_15909) {
            itemStack.method_7948().method_10569("water", 18000);
            return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
        }
        return super.method_7836(world, user, hand);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2487 tag = stack.method_7948();
        int burnTicks = tag.method_10550("burnTicks");
        if (burnTicks > 0) {
            NbtHelper.putNonzeroInt(tag, "burnTicks", Math.max(0, burnTicks - 5));
            NbtHelper.putNonzeroInt(tag, "water", Math.max(0, tag.method_10550("water") - 5));
        }
        if (tag.method_10550("burnTicks") == 0) {
            tag.method_10551("maxBurnTicks");
        }
    }

    public boolean canUse(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || tag.method_10550("water") == 0) {
            return false;
        }
        return tag.method_10550("burnTicks") > 0 || this.consumeFuel(stack, Simulation.SIMULATE) > 0;
    }

    private int consumeFuel(class_1799 stack, Simulation simulation) {
        Integer burnTicks = (Integer)FuelRegistry.INSTANCE.get((class_1935)this.getItemVariant(stack).getItem());
        if (burnTicks != null && burnTicks > 0) {
            if (simulation.isActing()) {
                class_1792 burnt = this.getItemVariant(stack).getItem();
                this.setAmount(stack, this.getAmount(stack) - 1L);
                if (burnt.method_7857()) {
                    this.insert(stack, ItemVariant.of((class_1935)burnt.method_7858()), 1L);
                }
            }
            return burnTicks;
        }
        return 0;
    }

    @Override
    public Reference2IntMap<class_1887> getEnchantments(class_1799 stack) {
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        map.put((Object)class_1893.field_9099, 1);
        return map;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            return Optional.of(new SteamDrillTooltipData(tag.method_10550("water") * 100 / 18000, tag.method_10550("burnTicks"), tag.method_10550("maxBurnTicks"), this.getItemVariant(stack), this.getAmount(stack)));
        }
        return Optional.of(new SteamDrillTooltipData(0, 0, 1, ItemVariant.blank(), 0L));
    }

    @Override
    public long getStackCapacity() {
        return 1L;
    }

    public boolean method_31565(class_1799 stackBarrel, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stackBarrel, class_1799 itemStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.handleOtherStackedOnMe(stackBarrel, itemStack, slot, clickType, player, cursorStackReference);
    }

    @Override
    public boolean canDirectInsert(class_1799 stack) {
        Integer fuelTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return fuelTime != null && fuelTime > 0 && ItemContainingItemHelper.super.canDirectInsert(stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        SteamDrillTooltipData data = (SteamDrillTooltipData)this.method_32346(stack).get();
        tooltip.add((class_2561)new class_2588("text.modern_industrialization.water_percent", new Object[]{data.waterLevel}).method_10862(TextHelper.WATER_TEXT));
        int barWater = (int)Math.ceil((double)data.waterLevel / 5.0);
        int barVoid = 20 - barWater;
        tooltip.add((class_2561)new class_2585("|".repeat(barWater)).method_10862(TextHelper.WATER_TEXT).method_10852((class_2561)new class_2585("|".repeat(barVoid)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0x6B6B6B)))));
        if (data.burnTicks > 0) {
            tooltip.add((class_2561)new class_2588("text.modern_industrialization.seconds_left", new Object[]{data.burnTicks / 100}).method_10862(TextHelper.GRAY_TEXT));
        }
        tooltip.add((class_2561)new class_2588("text.modern_industrialization.steam_drill_water_help").method_10862(TextHelper.UPGRADE_TEXT));
        tooltip.add((class_2561)new class_2588("text.modern_industrialization.steam_drill_fuel_help").method_10862(TextHelper.UPGRADE_TEXT));
        tooltip.add((class_2561)new class_2588("text.modern_industrialization.steam_drill_profit").method_10862(TextHelper.UPGRADE_TEXT));
    }

    public record SteamDrillTooltipData(int waterLevel, int burnTicks, int maxBurnTicks, ItemVariant variant, long amount) implements class_5632
    {
    }

    public static class SteamDrillTooltipComponent
    implements class_5684 {
        final SteamDrillTooltipData data;

        public SteamDrillTooltipComponent(SteamDrillTooltipData data) {
            this.data = data;
        }

        public int method_32661() {
            return 20;
        }

        public int method_32664(class_327 textRenderer) {
            return 40;
        }

        public void method_32666(class_327 textRenderer, int x, int y, class_4587 matrices, class_918 itemRenderer, int z) {
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
            class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)256, (int)256);
            class_1799 stack = this.data.variant.toStack((int)this.data.amount);
            itemRenderer.method_4023(stack, x + 1, y + 1);
            itemRenderer.method_4025(textRenderer, stack, x + 1, y + 1);
            ProgressBar.Parameters progressParams = new ProgressBar.Parameters(0, 0, "furnace", true);
            ProgressBar.RenderHelper.renderProgress(0, matrices, x + 20, y, progressParams, (float)this.data.burnTicks / (float)this.data.maxBurnTicks);
        }
    }
}

