/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.nuclear;

import aztech.modern_industrialization.compat.rei.ReiUtil;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionPlugin;
import aztech.modern_industrialization.compat.rei.nuclear.ThermalInteractionDisplay;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class ThermalInteractionCategory
implements DisplayCategory<ThermalInteractionDisplay> {
    public Renderer getIcon() {
        return new Renderer(){
            private int z = 2;

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                class_332.method_25291((class_4587)matrices, (int)(bounds.x - 1), (int)(bounds.y - 1), (int)this.z, (float)145.0f, (float)1.0f, (int)18, (int)18, (int)256, (int)256);
            }

            public int getZ() {
                return this.z;
            }

            public void setZ(int z) {
                this.z = z;
            }
        };
    }

    public List<Widget> setupDisplay(ThermalInteractionDisplay display, Rectangle bounds) {
        if (display.type == ThermalInteractionDisplay.CategoryType.NEUTRON_EFFICIENCY) {
            return this.setupNeutronEfficiency((NuclearFuel)display.nuclearComponent, bounds);
        }
        if (display.type == ThermalInteractionDisplay.CategoryType.THERMAL_PROPERTIES) {
            return this.setupThermalProperties(display.nuclearComponent, bounds);
        }
        return null;
    }

    private List<Widget> setupNeutronEfficiency(NuclearFuel nuclearComponent, Rectangle bounds) {
        List<Widget> widgets = ThermalInteractionCategory.defaultWidget(nuclearComponent, bounds, "neutron_production_temperature_effect");
        Rectangle area = new Rectangle(bounds.x + 10, bounds.y + 45, bounds.getWidth() - 20, bounds.getHeight() - 50);
        widgets.add(Widgets.createFilledRectangle((Rectangle)area, (int)-7631989));
        int py = bounds.y + bounds.getHeight() - 14;
        int px1 = bounds.x + 20;
        int px3 = bounds.x + bounds.getWidth() - 20;
        int px2 = (px1 + px3) / 2;
        widgets.add((Widget)Widgets.createLabel((Point)new Point(px1, py), (class_2561)new class_2585("0\u00b0C")));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(px2, py), (class_2561)new class_2585(String.format("%d\u00b0C", nuclearComponent.tempLimitLow))));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(px3 - 8, py), (class_2561)new class_2585(String.format("%d\u00b0C", nuclearComponent.tempLimitHigh))));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            int i;
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
            for (i = 1; i < area.getWidth() / 2; ++i) {
                helper.method_25302(matrices, area.x + i, area.y + 4, 0, 255, 1, 1);
            }
            for (i = area.getWidth() / 2; i < area.getWidth() - 1; ++i) {
                double f = ((double)i - (double)area.getWidth() / 2.0) / ((double)area.getWidth() - (double)area.getWidth() / 2.0);
                int y = (int)((1.0 - f) * (double)(area.y + 4) + f * (double)(area.y + area.height - 14));
                helper.method_25302(matrices, area.x + i, y, 0, 255, 1, 1);
            }
        }));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(px1 - 2, area.y + 2), (class_2561)new class_2585(String.format("%.1f", nuclearComponent.neutronMultiplicationFactor))).noShadow());
        widgets.add((Widget)Widgets.createLabel((Point)new Point(px3 + 6, py - 10), (class_2561)new class_2585("0")).noShadow());
        return widgets;
    }

    private static List<Widget> defaultWidget(INuclearComponent nuclearComponent, Rectangle bounds, String titleKey) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int centerX = bounds.x + bounds.width / 2;
        int px = centerX - 9;
        int py = bounds.y + 22;
        Point pos = new Point(px, py);
        Object t = nuclearComponent.getVariant();
        if (t instanceof ItemVariant) {
            ItemVariant itemVariant = (ItemVariant)t;
            widgets.add((Widget)Widgets.createSlot((Point)pos).entry(EntryStacks.of((class_1935)itemVariant.getItem())));
        } else {
            t = nuclearComponent.getVariant();
            if (t instanceof FluidVariant) {
                FluidVariant fluidVariant = (FluidVariant)t;
                widgets.add((Widget)Widgets.createSlot((Point)pos).entry(ReiUtil.createFluidEntryStack(fluidVariant.getFluid())));
            }
        }
        class_2588 title = new class_2588("text.modern_industrialization." + titleKey);
        Point posTitle = new Point(centerX, bounds.y + 8);
        widgets.add((Widget)Widgets.createLabel((Point)posTitle, (class_2561)title));
        return widgets;
    }

    private List<Widget> setupThermalProperties(INuclearComponent nuclearComponent, Rectangle bounds) {
        List<Widget> widgets = ThermalInteractionCategory.defaultWidget(nuclearComponent, bounds, "thermal_properties");
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        class_5250 heatConduction = new class_2588("text.modern_industrialization.heat_conduction", new Object[]{String.format("%.2f", nuclearComponent.getHeatConduction())}).method_10862(TextHelper.HEAT_CONDUCTION);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX, centerY), (class_2561)heatConduction).noShadow());
        int maxTemperature = nuclearComponent.getMaxTemperature();
        if (maxTemperature != Integer.MAX_VALUE) {
            class_5250 maxTemp = new class_2588("text.modern_industrialization.max_temp", new Object[]{maxTemperature}).method_10862(TextHelper.MAX_TEMP_TEXT);
            widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX, centerY + 12), (class_2561)maxTemp).noShadow());
        }
        return widgets;
    }

    public class_2561 getTitle() {
        return new class_2588("text.modern_industrialization.thermal_interaction");
    }

    public int getDisplayHeight() {
        return 100;
    }

    public CategoryIdentifier<? extends ThermalInteractionDisplay> getCategoryIdentifier() {
        return NeutronInteractionPlugin.THERMAL_CATEGORY;
    }
}

