/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.util.MobSpawning;
import aztech.modern_industrialization.util.ResourceUtil;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends AbstractStorageBlock
implements class_2343 {
    public final class_2343 factory;

    public BarrelBlock(String id, Function<MIBlock, class_1747> blockItemCtor, class_2343 factory) {
        super(id, FabricBlockSettings.of((class_3614)ModernIndustrialization.METAL_MATERIAL).breakByTool(FabricToolTags.PICKAXES).method_36557(4.0f).method_29292().method_26235(MobSpawning.NO_SPAWN), blockItemCtor);
        this.asColumn();
        this.factory = factory;
        ResourceUtil.appendToItemTag(new MIIdentifier("barrels"), new MIIdentifier(id));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.factory.method_10123(pos, state);
    }

    private static void updateDestroyDelay() {
        class_310.method_1551().field_1761.field_3716 = 5;
    }

    static {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2586 patt3428$temp = world.method_8321(hitResult.method_17777());
            if (patt3428$temp instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)patt3428$temp;
                if (hitResult.method_17780().method_10166().method_10179()) {
                    if (!player.method_5715()) {
                        if (StorageUtil.move((Storage)((Storage)PlayerInventoryStorage.of((class_1657)player).getSlots().get(player.method_31548().field_7545)), (Storage)barrel, itemVariant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                    } else {
                        ItemVariant currentInHand = ItemVariant.of((class_1799)player.method_6047());
                        if (StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)barrel, itemVariant -> itemVariant.equals(currentInHand), (long)Long.MAX_VALUE, null) > 0L) {
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_2586 patt4533$temp = world.method_8321(pos);
            if (patt4533$temp instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)patt4533$temp;
                if (direction.method_10166().method_10179() && !barrel.isEmpty()) {
                    try (Transaction transaction = Transaction.openOuter();){
                        ItemVariant extractedResource = (ItemVariant)barrel.getResource();
                        long extracted = barrel.extract((ItemVariant)barrel.getResource(), player.method_5715() ? 1L : (long)((ItemVariant)barrel.getResource()).getItem().method_7882(), (TransactionContext)transaction);
                        PlayerInventoryStorage.of((class_1657)player).offerOrDrop(extractedResource, extracted, (TransactionContext)transaction);
                        transaction.commit();
                        if (world.method_8608()) {
                            BarrelBlock.updateDestroyDelay();
                        }
                    }
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            }
            return class_1269.field_5811;
        });
    }
}

