/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.api.energy.EnergyMoveable;
import aztech.modern_industrialization.util.Simulation;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import team.reborn.energy.api.EnergyStorage;

public class EnergyApi {
    public static final BlockApiLookup<EnergyMoveable, class_2350> MOVEABLE = BlockApiLookup.get((class_2960)new class_2960("modern_industrialization:energy_moveable"), EnergyMoveable.class, class_2350.class);
    public static final EnergyExtractable CREATIVE_EXTRACTABLE = new EnergyExtractable(){

        @Override
        public long extractEnergy(long maxAmount, Simulation simulation) {
            return maxAmount;
        }

        @Override
        public boolean canExtract(CableTier tier) {
            return true;
        }
    };

    static {
        MOVEABLE.registerFallback((world, pos, state, blockEntity, context) -> {
            final EnergyStorage storage = (EnergyStorage)EnergyStorage.SIDED.find(world, pos, state, blockEntity, context);
            if (storage == null || !storage.supportsInsertion()) {
                return null;
            }
            return new EnergyInsertable(){

                @Override
                public long insertEnergy(long amount, Simulation simulation) {
                    long inserted;
                    try (Transaction tx = Transaction.openOuter();){
                        inserted = storage.insert(amount, (TransactionContext)tx);
                        if (simulation.isActing()) {
                            tx.commit();
                        }
                    }
                    if (inserted < 0L) {
                        ModernIndustrialization.LOGGER.warn(String.format("Tried inserting up to %d energy, but broken EnergyStorage %s inserted a negative amount of energy %d.%nWorld and position: %s %s.", amount, storage, inserted, world, pos));
                        return 0L;
                    }
                    return inserted;
                }

                @Override
                public boolean canInsert(CableTier tier) {
                    return true;
                }
            };
        });
    }
}

