/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix.mixin;

import java.util.Optional;
import net.blay09.mods.netherportalfix.NetherPortalFix;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.blay09.mods.netherportalfix.ReturnPortalManager;
import net.blay09.mods.netherportalfix.mixin.EntityAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5459;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class ServerPlayerMixin {
    @Inject(method={"getExitPortal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, cancellable=true)
    public void getExitPortal(class_3218 level, class_2338 pos, boolean isToNether, class_2784 worldBorder, CallbackInfoReturnable<Optional<class_5459.class_5460>> callbackInfo) {
        boolean isTeleportBetweenNetherAndOverworld;
        class_3222 player = (class_3222)this;
        class_2338 fromPos = player.method_24515();
        class_5321 fromDim = player.field_6002.method_27983();
        class_5321 toDim = level.method_27983();
        class_5321 OVERWORLD = class_1937.field_25179;
        class_5321 THE_NETHER = class_1937.field_25180;
        boolean isPlayerCurrentlyInPortal = ((EntityAccessor)player).getIsInsidePortal();
        boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD;
        if (isPlayerCurrentlyInPortal && isTeleportBetweenNetherAndOverworld) {
            ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, (class_5321<class_1937>)fromDim, fromPos);
            if (returnPortal == null) {
                NetherPortalFix.logger.info("No return portal found");
                return;
            }
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            class_3218 toLevel = server.method_3847(toDim);
            if (toLevel == null) {
                return;
            }
            NetherPortalFix.logger.info("Return portal found, redirecting! :)");
            callbackInfo.setReturnValue(Optional.of(returnPortal.getRectangle()));
        }
    }
}

