/*
 * Decompiled with CFR 0.152.
 */
package ninjaphenix.container_library;

import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import ninjaphenix.container_library.Utils;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import ninjaphenix.container_library.api.v2.client.NCL_ClientApiV2;
import ninjaphenix.container_library.client.gui.PageScreen;
import ninjaphenix.container_library.client.gui.ScrollScreen;
import ninjaphenix.container_library.client.gui.SingleScreen;
import ninjaphenix.container_library.inventory.ClientScreenHandlerFactory;
import ninjaphenix.container_library.wrappers.ConfigWrapper;
import ninjaphenix.container_library.wrappers.PlatformUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public final class CommonMain {
    public static final Logger LOGGER = LogManager.getLogger((String)"ninjaphenix_container_lib");
    private static class_3917<AbstractHandler> screenHandlerType;

    public static void initialize(BiFunction<class_2960, ClientScreenHandlerFactory, class_3917> handlerTypeFunction, Path configPath, Path oldConfigPath) {
        screenHandlerType = handlerTypeFunction.apply(Utils.HANDLER_TYPE_ID, AbstractHandler::createClientMenu);
        if (PlatformUtils.isClient()) {
            ConfigWrapper.getInstance().initialise(configPath, oldConfigPath);
            NCL_ClientApiV2.registerScreenButton(Utils.PAGE_SCREEN_TYPE, Utils.id("textures/gui/page_button.png"), (class_2561)Utils.translation("screen.expandedstorage.page_screen", new Object[0]));
            NCL_ClientApiV2.registerScreenButton(Utils.SCROLL_SCREEN_TYPE, Utils.id("textures/gui/scroll_button.png"), (class_2561)Utils.translation("screen.expandedstorage.scroll_screen", new Object[0]));
            NCL_ClientApiV2.registerScreenButton(Utils.SINGLE_SCREEN_TYPE, Utils.id("textures/gui/single_button.png"), (class_2561)Utils.translation("screen.expandedstorage.single_screen", new Object[0]), (scaledWidth, scaledHeight) -> scaledWidth < 370 || scaledHeight < 386, List.of(Utils.translation("screen.ninjaphenix_container_lib.off_screen_warning_1", new Object[0]).method_27692(class_124.field_1080), Utils.translation("screen.ninjaphenix_container_lib.off_screen_warning_2", new Object[0]).method_27692(class_124.field_1080)));
            NCL_ClientApiV2.registerScreenType(Utils.PAGE_SCREEN_TYPE, PageScreen::new);
            NCL_ClientApiV2.registerScreenType(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::new);
            NCL_ClientApiV2.registerScreenType(Utils.SINGLE_SCREEN_TYPE, SingleScreen::new);
            NCL_ClientApiV2.registerDefaultScreenSize(Utils.PAGE_SCREEN_TYPE, PageScreen::retrieveScreenSize);
            NCL_ClientApiV2.registerDefaultScreenSize(Utils.SCROLL_SCREEN_TYPE, ScrollScreen::retrieveScreenSize);
            NCL_ClientApiV2.registerDefaultScreenSize(Utils.SINGLE_SCREEN_TYPE, SingleScreen::retrieveScreenSize);
            NCL_ClientApiV2.setPrefersSingleScreen(Utils.PAGE_SCREEN_TYPE);
            NCL_ClientApiV2.setPrefersSingleScreen(Utils.SCROLL_SCREEN_TYPE);
        }
    }

    public static void warnThrowableMessage(String message, Throwable throwable, Object ... values) {
        LOGGER.warn((Message)new FormattedMessage(message, values, throwable));
    }

    public static class_3917<AbstractHandler> getScreenHandlerType() {
        return screenHandlerType;
    }
}

