/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.structures;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3749;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.world.structures.IStructure;
import paulevs.betternether.world.structures.StructureGeneratorThreadContext;

public class StructurePath
implements IStructure {
    private final OpenSimplexNoise heightNoise;
    private final OpenSimplexNoise rigidNoise;
    private final OpenSimplexNoise distortX;
    private final OpenSimplexNoise distortY;

    public StructurePath(long seed) {
        Random random = new Random(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (int x = 0; x < 16; ++x) {
            int wx = pos.method_10263() + x;
            context.POS.method_33097(wx);
            for (int z = 0; z < 16; ++z) {
                int wz = pos.method_10260() + z;
                context.POS.method_33099(wz);
                double rigid = this.getRigid(wx, wz) + (double)MHelper.randRange(0.0f, 0.015f, random);
                if (!(rigid < 0.015)) continue;
                int height = this.getHeight(wx, wz);
                context.POS.method_33098(height);
                height -= BlocksHelper.downRay((class_1936)world, (class_2338)context.POS, height);
                context.POS.method_33098(height);
                if (!world.method_22347((class_2338)context.POS) || !world.method_8320((class_2338)context.POS.method_10098(class_2350.field_11033)).method_26234((class_1922)world, (class_2338)context.POS) || !this.isHeightValid((class_1936)world, context.POS.method_10084())) continue;
                class_1959 biome = world.method_23753((class_2338)context.POS);
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)context.POS, this.getRoadMaterial(world, (class_2338)context.POS, biome));
                if (this.needsSlab(world, context.POS.method_10084())) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, context.POS.method_10084(), this.getSlabMaterial(world, (class_2338)context.POS, biome));
                    continue;
                }
                if (!(rigid > 0.01) || (x & 3) != 0 || (z & 3) != 0 || random.nextInt(8) != 0) continue;
                this.makeLantern((class_1936)world, context.POS.method_10084());
            }
        }
    }

    private int getHeight(int x, int z) {
        return (int)(this.heightNoise.eval((double)x * 0.001, (double)z * 0.001) * 32.0 + 64.0);
    }

    private double getRigid(double x, double z) {
        return Math.abs(this.rigidNoise.eval((x *= 0.1) * 0.02 + this.distortX.eval(x * 0.05, (z *= 0.1) * 0.05) * 0.2, z * 0.02 + this.distortY.eval(x * 0.05, z * 0.05) * 0.2));
    }

    private boolean isHeightValid(class_1936 world, class_2338 pos) {
        return Math.abs(BlocksHelper.downRay(world, pos.method_10076(2), 5) - BlocksHelper.downRay(world, pos.method_10077(2), 5)) < 3 && Math.abs(BlocksHelper.downRay(world, pos.method_10089(2), 5) - BlocksHelper.downRay(world, pos.method_10088(2), 5)) < 3;
    }

    private void makeLantern(class_1936 world, class_2338 pos) {
        BlocksHelper.setWithoutUpdate(world, pos, NetherBlocks.NETHER_BRICK_WALL.method_9564());
        BlocksHelper.setWithoutUpdate(world, pos.method_10084(), class_2246.field_10364.method_9564());
        BlocksHelper.setWithoutUpdate(world, pos.method_10086(2), class_2246.field_10364.method_9564());
        class_2350 dir = class_2350.field_11043;
        double d = 1000.0;
        double v = this.getRigid(pos.method_10263(), pos.method_10260());
        for (class_2350 face : BlocksHelper.HORIZONTAL) {
            class_2338 p = pos.method_10093(face);
            double v2 = this.getRigid(p.method_10263(), p.method_10260());
            double d2 = v - v2;
            if (!(d2 < d)) continue;
            d = d2;
            dir = face;
        }
        class_2338 p = pos.method_10086(3);
        BlocksHelper.setWithoutUpdate(world, p, class_2246.field_10364.method_9564());
        world.method_22350(p).method_12039(new class_2338(p.method_10263() & 0xF, p.method_10264(), p.method_10260() & 0xF));
        p = p.method_10093(dir.method_10153());
        BlocksHelper.setWithoutUpdate(world, p, class_2246.field_10364.method_9564());
        world.method_22350(p).method_12039(new class_2338(p.method_10263() & 0xF, p.method_10264(), p.method_10260() & 0xF));
        BlocksHelper.setWithoutUpdate(world, p.method_10074(), (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true)));
    }

    private class_2680 getRoadMaterial(class_5425 world, class_2338 pos, class_1959 biome) {
        return class_2246.field_22091.method_9564();
    }

    private class_2680 getSlabMaterial(class_5425 world, class_2338 pos, class_1959 biome) {
        return NetherBlocks.BASALT_SLAB.method_9564();
    }

    private boolean needsSlab(class_5425 world, class_2338 pos) {
        for (class_2350 dir : BlocksHelper.HORIZONTAL) {
            class_2680 state = world.method_8320(pos.method_10093(dir));
            if (!BlocksHelper.isNetherGround(state) && state.method_26204() != class_2246.field_22091 && state.method_26204() != NetherBlocks.SOUL_SANDSTONE || world.method_8320(pos.method_10074().method_10093(dir.method_10153())).method_26215()) continue;
            return true;
        }
        return false;
    }
}

