/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.biomes;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockSoulSandstone;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.registry.NetherEntities;
import paulevs.betternether.registry.NetherFeatures;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.NetherBiomeConfig;
import paulevs.betternether.world.structures.StructureType;
import paulevs.betternether.world.structures.decorations.StructureWartDeadwood;
import paulevs.betternether.world.structures.plants.StructureBlackBush;
import paulevs.betternether.world.structures.plants.StructureNetherWart;
import paulevs.betternether.world.structures.plants.StructureSoulLily;
import paulevs.betternether.world.structures.plants.StructureWartSeed;
import paulevs.betternether.world.structures.plants.StructureWartTree;
import ru.bclib.api.biomes.BCLBiomeBuilder;
import ru.bclib.world.biomes.BCLBiomeSettings;

public class NetherWartForest
extends NetherBiome {
    public NetherWartForest(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    @Override
    protected void onInit() {
        this.setNoiseDensity(0.45f);
        this.addStructure("wart_deadwood", new StructureWartDeadwood(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("wart_tree", new StructureWartTree(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("nether_wart", new StructureNetherWart(), StructureType.FLOOR, 0.2f, false);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("soul_lily", new StructureSoulLily(), StructureType.FLOOR, 0.2f, true);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        switch (random.nextInt(4)) {
            case 0: {
                super.genSurfColumn(world, pos, random);
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10114.method_9564());
                break;
            }
            case 2: {
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_22090.method_9564());
                break;
            }
            case 3: {
                BlocksHelper.setWithoutUpdate(world, pos, NetherBlocks.NETHERRACK_MOSS.method_9564());
            }
        }
        int d1 = MHelper.randRange(2, 4, random);
        POS.method_33097(pos.method_10263());
        POS.method_33099(pos.method_10260());
        for (int i = 1; i < d1; ++i) {
            POS.method_33098(pos.method_10264() - i);
            if (BlocksHelper.isNetherGround(world.method_8320((class_2338)POS))) {
                switch (random.nextInt(3)) {
                    case 0: {
                        BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10114.method_9564());
                        break;
                    }
                    case 1: {
                        BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_22090.method_9564());
                        break;
                    }
                    case 2: {
                        BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10515.method_9564());
                    }
                }
                continue;
            }
            return;
        }
        int d2 = MHelper.randRange(5, 7, random);
        for (int i = d1; i < d2; ++i) {
            POS.method_33098(pos.method_10264() - i);
            if (!BlocksHelper.isNetherGround(world.method_8320((class_2338)POS))) {
                return;
            }
            BlocksHelper.setWithoutUpdate(world, (class_2338)POS, (class_2680)NetherBlocks.SOUL_SANDSTONE.method_9564().method_11657((class_2769)BlockSoulSandstone.UP, (Comparable)Boolean.valueOf(i == d1)));
        }
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(151, 6, 6).loop(class_3417.field_22452).additions(class_3417.field_22451).mood(class_3417.field_22453).music(class_3417.field_23796).particles((class_2394)class_2398.field_22248, 0.05f).spawn(NetherEntities.FLYING_PIG, 20, 2, 4).feature(NetherFeatures.NETHER_RUBY_ORE).edgeSize(9);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherWartForest::new;
        }
    }
}

