/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import paulevs.betternether.BetterNether;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.config.Configs;
import paulevs.betternether.entity.EntityChair;
import paulevs.betternether.entity.EntityFirefly;
import paulevs.betternether.entity.EntityFlyingPig;
import paulevs.betternether.entity.EntityHydrogenJellyfish;
import paulevs.betternether.entity.EntityJungleSkeleton;
import paulevs.betternether.entity.EntityNaga;
import paulevs.betternether.entity.EntityNagaProjectile;
import paulevs.betternether.entity.EntitySkull;
import paulevs.betternether.registry.NetherItems;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.spawning.SpawnRuleBuilder;
import ru.bclib.entity.BCLEntityWrapper;
import ru.bclib.interfaces.SpawnRule;
import ru.bclib.util.ColorUtil;

public class NetherEntities {
    public static final Map<class_1299<? extends class_1297>, class_5132> ATTRIBUTES = Maps.newHashMap();
    private static final List<BCLEntityWrapper<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static final class_1299<EntityChair> CHAIR = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityChair::new).dimensions(class_4048.method_18385((float)0.0f, (float)0.0f)).fireImmune().disableSummon().build();
    public static final class_1299<EntityNagaProjectile> NAGA_PROJECTILE = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, EntityNagaProjectile::new).dimensions(class_4048.method_18385((float)1.0f, (float)1.0f)).disableSummon().build();
    public static final BCLEntityWrapper<EntityFirefly> FIREFLY = NetherEntities.register("firefly", class_1311.field_6303, 0.5f, 0.5f, EntityFirefly::new, EntityFirefly.createMobAttributes(), true, ColorUtil.color((int)255, (int)223, (int)168), ColorUtil.color((int)233, (int)182, (int)95));
    public static final BCLEntityWrapper<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH = NetherEntities.register("hydrogen_jellyfish", class_1311.field_6303, 2.0f, 5.0f, EntityHydrogenJellyfish::new, EntityHydrogenJellyfish.createMobAttributes(), false, ColorUtil.color((int)253, (int)164, (int)24), ColorUtil.color((int)88, (int)21, (int)4));
    public static final BCLEntityWrapper<EntityNaga> NAGA = NetherEntities.register("naga", class_1311.field_6302, 0.625f, 2.75f, EntityNaga::new, EntityNaga.createMobAttributes(), true, ColorUtil.color((int)12, (int)12, (int)12), ColorUtil.color((int)210, (int)90, (int)26));
    public static final BCLEntityWrapper<EntityFlyingPig> FLYING_PIG = NetherEntities.register("flying_pig", class_1311.field_6303, 1.0f, 1.25f, EntityFlyingPig::new, EntityFlyingPig.createMobAttributes(), true, ColorUtil.color((int)241, (int)140, (int)93), ColorUtil.color((int)176, (int)58, (int)47));
    public static final BCLEntityWrapper<EntityJungleSkeleton> JUNGLE_SKELETON = NetherEntities.register("jungle_skeleton", class_1311.field_6302, 0.6f, 1.99f, EntityJungleSkeleton::new, EntityJungleSkeleton.method_26918(), true, ColorUtil.color((int)134, (int)162, (int)149), ColorUtil.color((int)6, (int)111, (int)79));
    public static final BCLEntityWrapper<EntitySkull> SKULL = NetherEntities.register("skull", class_1311.field_6302, 0.625f, 0.625f, EntitySkull::new, EntitySkull.createMobAttributes(), true, ColorUtil.color((int)24, (int)19, (int)19), ColorUtil.color((int)255, (int)28, (int)18));
    public static final int MAX_FLOAT_HEIGHT = 7;
    public static final SpawnRule RULE_FLOAT_NOT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, false);
    public static final SpawnRule RULE_FLOAT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, true);

    private static <T extends class_1308> BCLEntityWrapper<T> register(String name, class_1311 group, float width, float height, class_1299.class_4049<T> entity, class_5132.class_5133 attributes, boolean fixedSize, int eggColor, int dotsColor) {
        class_2960 id = BetterNether.makeID(name);
        class_1299 type = FabricEntityTypeBuilder.create((class_1311)group, entity).dimensions(fixedSize ? class_4048.method_18385((float)width, (float)height) : class_4048.method_18384((float)width, (float)height)).fireImmune().build();
        type = (class_1299)class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)id, (Object)type);
        FabricDefaultAttributeRegistry.register((class_1299)type, (class_5132.class_5133)attributes);
        NetherItems.makeEgg("spawn_egg_" + name, (class_1299<? extends class_1308>)type, eggColor, dotsColor);
        if (Configs.MOBS.getBooleanRoot(id.method_12832(), true)) {
            return new BCLEntityWrapper(type, true);
        }
        BCLEntityWrapper wrapper = new BCLEntityWrapper(type, false);
        NETHER_ENTITIES.add(wrapper);
        return wrapper;
    }

    private static boolean testSpawnAboveLava(class_1936 world, class_2338 pos, boolean allow) {
        int h = ru.bclib.util.BlocksHelper.downRay((class_1936)world, (class_2338)pos, (int)9);
        if (h > 7) {
            return false;
        }
        for (int i = 1; i <= h + 1; ++i) {
            if (!BlocksHelper.isLava(world.method_8320(pos.method_10087(i)))) continue;
            return allow;
        }
        return !allow;
    }

    public static void register() {
        NetherEntities.registerEntity("chair", CHAIR, EntityChair.getAttributeContainer());
        NetherEntities.registerEntity("naga_projectile", NAGA_PROJECTILE);
        SpawnRuleBuilder.start(FIREFLY).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(32, 64).buildNoRestrictions(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(HYDROGEN_JELLYFISH).belowMaxHeight().maxNearby(24, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
        SpawnRuleBuilder.start(NAGA).hostile(8).maxNearby(32, 64).buildOnGround(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(FLYING_PIG).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(16, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
        SpawnRuleBuilder.start(JUNGLE_SKELETON).notPeaceful().maxNearby(16, 64).buildOnGround(class_2902.class_2903.field_13203);
        SpawnRuleBuilder.start(SKULL).belowMaxHeight().vanillaHostile().maxNearby(16, 64).buildNoRestrictions(class_2902.class_2903.field_13197);
    }

    public static void registerEntity(String name, class_1299<? extends class_1309> entity) {
        class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("betternether", name), entity);
        ATTRIBUTES.put(entity, class_1308.method_26828().method_26866());
    }

    public static void registerEntity(String name, class_1299<? extends class_1297> entity, class_5132 container) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("betternether", name), entity);
            ATTRIBUTES.put(entity, container);
        }
    }

    public static boolean isNetherEntity(class_1297 entity) {
        return NETHER_ENTITIES.contains(entity.method_5864());
    }

    static void modifyNonBNBiome(class_2960 biomeID, class_1959 biome) {
        BiomeAPI.addBiomeMobSpawn((class_1959)biome, FIREFLY, (int)5, (int)3, (int)6);
        BiomeAPI.addBiomeMobSpawn((class_1959)biome, HYDROGEN_JELLYFISH, (int)5, (int)2, (int)5);
        BiomeAPI.addBiomeMobSpawn((class_1959)biome, NAGA, (int)8, (int)3, (int)5);
    }
}

