/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3614;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5533;
import net.minecraft.class_7;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.registry.NetherEntities;
import paulevs.betternether.registry.SoundsRegistry;
import ru.bclib.entity.DespawnableAnimal;

public class EntityFirefly
extends DespawnableAnimal
implements class_1432 {
    private static final HashSet<class_2248> FLOWERS;
    private static final class_2382[] SEARCH;
    private static final class_2940<Float> COLOR_RED;
    private static final class_2940<Float> COLOR_GREEN;
    private static final class_2940<Float> COLOR_BLUE;
    private boolean mustSit = false;

    public EntityFirefly(class_1299<? extends EntityFirefly> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.field_6206 = new FreflyLookControl((class_1308)this);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.field_6194 = 1;
    }

    protected void method_5693() {
        super.method_5693();
        this.makeColor(this.field_5974.nextFloat(), this.field_5974.nextFloat() * 0.5f + 0.25f, 1.0f);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23720, 0.6).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 48.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                boolean valid;
                class_2680 state = this.field_6677.method_8320(pos.method_10074());
                boolean bl = valid = !state.method_26215() && state.method_26207() != class_3614.field_15922;
                if (valid) {
                    state = this.field_6677.method_8320(pos);
                    valid = state.method_26215() || !state.method_26207().method_15801();
                    valid = valid && state.method_26204() != NetherBlocks.EGG_PLANT;
                    valid = valid && !state.method_26207().method_15801();
                }
                return valid;
            }

            public void method_6360() {
                super.method_6360();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new SittingGoal());
        this.field_6201.method_6277(5, (class_1352)new MoveToFlowersGoal());
        this.field_6201.method_6277(6, (class_1352)new WanderAroundGoal());
        this.field_6201.method_6277(7, (class_1352)new MoveRandomGoal());
    }

    public float method_6144(class_2338 pos, class_4538 worldView) {
        return worldView.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8601;
    }

    protected boolean method_5776() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    protected void method_6010(class_3494<class_3611> fluid) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.01, 0.0));
    }

    public float method_5718() {
        return 1.0f;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public boolean method_5740() {
        return true;
    }

    public float getRed() {
        return ((Float)this.field_6011.method_12789(COLOR_RED)).floatValue();
    }

    public float getGreen() {
        return ((Float)this.field_6011.method_12789(COLOR_GREEN)).floatValue();
    }

    public float getBlue() {
        return ((Float)this.field_6011.method_12789(COLOR_BLUE)).floatValue();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("ColorRed", this.getRed());
        tag.method_10548("ColorGreen", this.getGreen());
        tag.method_10548("ColorBlue", this.getBlue());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("ColorRed")) {
            this.field_6011.method_12778(COLOR_RED, (Object)Float.valueOf(tag.method_10583("ColorRed")));
        }
        if (tag.method_10545("ColorGreen")) {
            this.field_6011.method_12778(COLOR_GREEN, (Object)Float.valueOf(tag.method_10583("ColorGreen")));
        }
        if (tag.method_10545("ColorBlue")) {
            this.field_6011.method_12778(COLOR_BLUE, (Object)Float.valueOf(tag.method_10583("ColorBlue")));
        }
    }

    public class_1296 method_5613(class_3218 world, class_1296 mate) {
        return (class_1296)NetherEntities.FIREFLY.type().method_5883((class_1937)world);
    }

    public boolean method_6581() {
        return !this.field_5952;
    }

    private void checkMovement() {
        class_243 vel = this.method_18798();
        if (Math.abs(vel.field_1352) > 0.1 || Math.abs(vel.field_1350) > 0.1) {
            double d = Math.abs(this.field_6014 - this.method_23317());
            if ((d += Math.abs(this.field_5969 - this.method_23321())) < 0.1) {
                this.field_6189.method_6340();
            }
        }
    }

    public class_3414 method_5994() {
        return SoundsRegistry.MOB_FIREFLY_FLY;
    }

    protected float method_6107() {
        return MHelper.randRange(0.1f, 0.3f, this.field_5974);
    }

    private void makeColor(float hue, float saturation, float brightness) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
        float f4 = f3 - (float)Math.floor(f3);
        float f5 = brightness * (1.0f - saturation);
        float f6 = brightness * (1.0f - saturation * f4);
        float f7 = brightness * (1.0f - saturation * (1.0f - f4));
        switch ((int)f3) {
            case 0: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f7 * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 1: {
                red = (byte)(f6 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 2: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f7 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(f6 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 4: {
                red = (byte)(f7 * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 5: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(f6 * 255.0f + 0.5f);
            }
        }
        this.field_6011.method_12784(COLOR_RED, (Object)Float.valueOf(red / 255.0f));
        this.field_6011.method_12784(COLOR_GREEN, (Object)Float.valueOf(green / 255.0f));
        this.field_6011.method_12784(COLOR_BLUE, (Object)Float.valueOf(blue / 255.0f));
    }

    public int method_5945() {
        return 5;
    }

    public static boolean canSpawn(class_1299<? extends EntityFirefly> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        if (pos.method_10264() >= world.method_8597().method_29959()) {
            return false;
        }
        int h = BlocksHelper.downRay(world, pos, 10);
        if (h > 8) {
            return false;
        }
        for (int i = 1; i <= h; ++i) {
            if (!BlocksHelper.isLava(world.method_8320(pos.method_10087(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    static {
        COLOR_RED = class_2945.method_12791(EntityFirefly.class, (class_2941)class_2943.field_13320);
        COLOR_GREEN = class_2945.method_12791(EntityFirefly.class, (class_2941)class_2943.field_13320);
        COLOR_BLUE = class_2945.method_12791(EntityFirefly.class, (class_2941)class_2943.field_13320);
        ArrayList<class_2382> points = new ArrayList<class_2382>();
        int radius = 6;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > r2) continue;
                    points.add(new class_2382(x, y, z));
                }
            }
        }
        points.sort(new Comparator<class_2382>(){

            @Override
            public int compare(class_2382 v1, class_2382 v2) {
                int d1 = v1.method_10263() * v1.method_10263() + v1.method_10264() * v1.method_10264() + v1.method_10260() * v1.method_10260();
                int d2 = v2.method_10263() * v2.method_10263() + v2.method_10264() * v2.method_10264() + v2.method_10260() * v2.method_10260();
                return d1 - d2;
            }
        });
        SEARCH = points.toArray(new class_2382[0]);
        FLOWERS = new HashSet();
        FLOWERS.add(NetherBlocks.NETHER_GRASS);
        FLOWERS.add(NetherBlocks.SOUL_GRASS);
        FLOWERS.add(NetherBlocks.SWAMP_GRASS);
        FLOWERS.add(NetherBlocks.BLACK_APPLE);
        FLOWERS.add(NetherBlocks.MAGMA_FLOWER);
        FLOWERS.add(NetherBlocks.SOUL_VEIN);
        FLOWERS.add(NetherBlocks.MAT_REED.getStem());
        FLOWERS.add(NetherBlocks.INK_BUSH);
        FLOWERS.add(NetherBlocks.INK_BUSH_SEED);
        FLOWERS.add(NetherBlocks.POTTED_PLANT);
        FLOWERS.add(class_2246.field_9974);
    }

    class FreflyLookControl
    extends class_1333 {
        FreflyLookControl(class_1308 entity) {
            super(entity);
        }

        protected boolean method_20433() {
            return true;
        }
    }

    class SittingGoal
    extends class_1352 {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean method_6264() {
            if (EntityFirefly.this.mustSit && EntityFirefly.this.field_6189.method_6357()) {
                class_2338 pos = new class_2338(EntityFirefly.this.method_23317(), EntityFirefly.this.method_23318(), EntityFirefly.this.method_23321());
                class_2680 state = EntityFirefly.this.field_6002.method_8320(pos.method_10074());
                return !state.method_26215() && !state.method_26207().method_15797();
            }
            return false;
        }

        public boolean method_6266() {
            return this.timer < this.ammount;
        }

        public void method_6269() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.field_5974.nextInt(21) + 20;
            EntityFirefly.this.mustSit = false;
            EntityFirefly.this.method_18800(0.0, -0.1, 0.0);
            super.method_6269();
        }

        public void method_6270() {
            EntityFirefly.this.method_18800(0.0, 0.1, 0.0);
            super.method_6270();
        }

        public void method_6268() {
            ++this.timer;
            super.method_6268();
        }
    }

    class MoveToFlowersGoal
    extends class_1352 {
        MoveToFlowersGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return EntityFirefly.this.field_6189.method_6357() && EntityFirefly.this.field_5974.nextInt(30) == 0;
        }

        public boolean method_6266() {
            return EntityFirefly.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_2338 pos = this.getFlowerLocation();
            if (pos != null) {
                class_11 path = EntityFirefly.this.field_6189.method_6348(new class_2338((class_2382)pos), 1);
                EntityFirefly.this.field_6189.method_6334(path, 1.0);
            }
            super.method_6269();
        }

        public void method_6270() {
            if (this.isFlower(EntityFirefly.this.method_36601())) {
                EntityFirefly.this.mustSit = true;
            }
            super.method_6270();
        }

        private class_2338 getFlowerLocation() {
            class_1937 w = EntityFirefly.this.field_6002;
            class_2338.class_2339 bpos = new class_2338.class_2339();
            for (class_2382 offset : SEARCH) {
                bpos.method_10102(EntityFirefly.this.method_23317() + (double)offset.method_10263(), EntityFirefly.this.method_23318() + (double)offset.method_10264(), EntityFirefly.this.method_23321() + (double)offset.method_10260());
                if (!this.isFlower(w.method_8320((class_2338)bpos))) continue;
                return bpos;
            }
            return null;
        }

        private boolean isFlower(class_2680 state) {
            class_2248 b = state.method_26204();
            return FLOWERS.contains(b);
        }

        public void method_6268() {
            EntityFirefly.this.checkMovement();
            super.method_6268();
        }
    }

    class WanderAroundGoal
    extends class_1352 {
        WanderAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return EntityFirefly.this.field_6189.method_6357() && EntityFirefly.this.field_5974.nextInt(10) == 0;
        }

        public boolean method_6266() {
            return EntityFirefly.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_2338 pos = this.getRandomLocation();
            class_11 path = EntityFirefly.this.field_6189.method_6348(pos, 1);
            if (path != null) {
                EntityFirefly.this.field_6189.method_6334(path, 1.0);
            } else {
                EntityFirefly.this.method_18800(0.0, -0.2, 0.0);
            }
            super.method_6269();
        }

        private class_2338 getRandomLocation() {
            class_1937 w = EntityFirefly.this.field_6002;
            class_2338.class_2339 bpos = new class_2338.class_2339();
            bpos.method_10102(EntityFirefly.this.method_23317(), EntityFirefly.this.method_23318(), EntityFirefly.this.method_23321());
            if (w.method_22347(bpos.method_10087(2)) && w.method_22347(bpos.method_10074())) {
                int y = bpos.method_10264() - 1;
                while (w.method_22347(bpos.method_10087(2)) && y > 0) {
                    bpos.method_33098(y--);
                }
                return bpos;
            }
            class_243 angle = EntityFirefly.this.method_5828(0.0f);
            class_243 airTarget = class_5533.method_31524((class_1314)EntityFirefly.this, (int)8, (int)7, (double)angle.field_1352, (double)angle.field_1350, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = class_5533.method_31524((class_1314)EntityFirefly.this, (int)16, (int)10, (double)angle.field_1352, (double)angle.field_1350, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.method_33097(bpos.method_10263() + this.randomRange(8));
                bpos.method_33099(bpos.method_10260() + this.randomRange(8));
                bpos.method_33098(bpos.method_10264() + this.randomRange(2));
                return bpos;
            }
            bpos.method_10102(airTarget.method_10216(), airTarget.method_10214(), airTarget.method_10215());
            return bpos;
        }

        private int randomRange(int side) {
            Random random = EntityFirefly.this.field_5974;
            return random.nextInt(side + 1) - (side >> 1);
        }

        public void method_6268() {
            EntityFirefly.this.checkMovement();
            super.method_6268();
        }
    }

    class MoveRandomGoal
    extends class_1352 {
        int timer;
        int ammount;

        MoveRandomGoal() {
        }

        public boolean method_6264() {
            return EntityFirefly.this.field_6189.method_6357() && EntityFirefly.this.field_5974.nextInt(20) == 0;
        }

        public boolean method_6266() {
            return this.timer < this.ammount;
        }

        public void method_6269() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.field_5974.nextInt(30) + 10;
            class_243 velocity = new class_243(EntityFirefly.this.field_5974.nextDouble(), EntityFirefly.this.field_5974.nextDouble(), EntityFirefly.this.field_5974.nextDouble());
            if (velocity.method_1027() == 0.0) {
                velocity = new class_243(1.0, 0.0, 0.0);
            }
            EntityFirefly.this.method_18799(velocity.method_1029().method_1021((double)EntityFirefly.this.field_6281));
            super.method_6269();
        }

        public void method_6268() {
            ++this.timer;
            super.method_6268();
        }
    }
}

