/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Config {
    private static final List<Config> ALL = Lists.newArrayList();
    private JsonObject config;
    private boolean rewrite = false;
    private final String name;

    public Config(String name) {
        this.name = name;
        ALL.add(this);
    }

    private void load() {
        block7: {
            if (this.config == null) {
                File file = this.getFolder();
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((file = this.getFile()).exists()) {
                    Gson gson = new Gson();
                    try {
                        FileReader reader = new FileReader(file);
                        this.config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (this.config == null) {
                            this.config = new JsonObject();
                            this.rewrite = true;
                            break block7;
                        }
                        this.rewrite = false;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        this.config = new JsonObject();
                        this.rewrite = true;
                    }
                } else {
                    this.config = new JsonObject();
                    this.rewrite = true;
                }
            }
        }
    }

    public static void save() {
        ALL.forEach(config -> {
            if (config.rewrite) {
                File file = config.getFolder();
                if (!file.exists()) {
                    file.mkdirs();
                }
                file = config.getFile();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try {
                    FileWriter writer = new FileWriter(file);
                    String gstring = gson.toJson((JsonElement)config.config);
                    writer.write(gstring);
                    writer.flush();
                    writer.close();
                    config.rewrite = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private File getFile() {
        return new File(String.format("./config/%s/%s.json", "betternether", this.name));
    }

    private File getFolder() {
        return new File("./config/betternether/");
    }

    public boolean getBoolean(String groups, String name, boolean def) {
        this.load();
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        JsonElement element = group.get((String)name);
        if (element != null) {
            return element.getAsBoolean();
        }
        group.addProperty((String)name, Boolean.valueOf(def));
        this.rewrite = true;
        return def;
    }

    public void setBoolean(String groups, String name, boolean def, boolean value) {
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        group.addProperty((String)name, Boolean.valueOf(value));
        this.rewrite = true;
    }

    public float getFloat(String groups, String name, float def) {
        this.load();
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        JsonElement element = group.get((String)name);
        if (element != null) {
            return element.getAsFloat();
        }
        group.addProperty((String)name, (Number)Float.valueOf(def));
        this.rewrite = true;
        return def;
    }

    public void setFloat(String groups, String name, float def, float value) {
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        group.addProperty((String)name, (Number)Float.valueOf(value));
        this.rewrite = true;
    }

    public int getInt(String groups, String name, int def) {
        this.load();
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        JsonElement element = group.get((String)name);
        if (element != null) {
            return element.getAsInt();
        }
        group.addProperty((String)name, (Number)def);
        this.rewrite = true;
        return def;
    }

    public String getString(String groups, String name, String def) {
        this.load();
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        JsonElement element = group.get((String)name);
        if (element != null) {
            return element.getAsString();
        }
        group.addProperty((String)name, def);
        this.rewrite = true;
        return def;
    }

    public void setInt(String groups, String name, int def, int value) {
        name = (String)name + "[def: " + def + "]";
        JsonObject group = this.getGroup(groups);
        group.addProperty((String)name, (Number)value);
        this.rewrite = true;
    }

    public void setStringLoad(String groups, String name, String value) {
        JsonObject group = this.getGroup(groups);
        group.addProperty(name, value);
    }

    public String[] getStringArray(String groups, String name, String[] def) {
        this.load();
        JsonObject group = this.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return this.toStringArray(element.getAsJsonArray());
        }
        group.add(name, (JsonElement)this.toJsonArray(def));
        this.rewrite = true;
        return def;
    }

    private String[] toStringArray(JsonArray array) {
        this.load();
        String[] result = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    private JsonArray toJsonArray(String[] array) {
        this.load();
        JsonArray result = new JsonArray();
        for (String s : array) {
            result.add(s);
        }
        return result;
    }

    public JsonObject getGroup(String groups) {
        String[] groupsArr;
        JsonObject obj = this.config;
        for (String group : groupsArr = groups.split("\\.")) {
            JsonObject jGroup = obj.getAsJsonObject(group);
            if (jGroup == null) {
                jGroup = new JsonObject();
                obj.add(group, (JsonElement)jGroup);
            }
            obj = jGroup;
        }
        return obj;
    }

    public List<String> getBaseGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        Iterator<Map.Entry> iterator = this.config.entrySet().iterator();
        iterator.forEachRemaining(element -> groups.add((String)element.getKey()));
        return groups;
    }

    public List<Map.Entry<String, JsonElement>> getGroupMembers(JsonObject group) {
        ArrayList<Map.Entry<String, JsonElement>> result = new ArrayList<Map.Entry<String, JsonElement>>();
        result.addAll(group.entrySet());
        return result;
    }

    public void markToSave() {
        this.rewrite = true;
    }
}

