/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks.complex;

import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import paulevs.betternether.blocks.BNBarStool;
import paulevs.betternether.blocks.BNNormalChair;
import paulevs.betternether.blocks.BNTaburet;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.registry.NetherItems;
import ru.bclib.api.tag.NamedBlockTags;
import ru.bclib.api.tag.NamedCommonBlockTags;
import ru.bclib.api.tag.NamedCommonItemTags;
import ru.bclib.api.tag.NamedItemTags;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.blocks.BaseBarkBlock;
import ru.bclib.blocks.BaseCraftingTableBlock;
import ru.bclib.blocks.BaseRotatedPillarBlock;
import ru.bclib.blocks.BaseStripableLogBlock;
import ru.bclib.blocks.StripableBarkBlock;
import ru.bclib.complexmaterials.ComplexMaterial;
import ru.bclib.complexmaterials.WoodenComplexMaterial;
import ru.bclib.complexmaterials.entry.BlockEntry;
import ru.bclib.complexmaterials.entry.RecipeEntry;
import ru.bclib.config.Configs;
import ru.bclib.config.PathConfig;
import ru.bclib.recipes.GridRecipe;
import ru.bclib.registry.BlockRegistry;
import ru.bclib.registry.ItemRegistry;

public class NetherWoodenMaterial
extends WoodenComplexMaterial {
    protected static final String BLOCK_OPTIONAL_TRUNK = "trunk";
    protected static final String BLOCK_OPTIONAL_BRANCH = "branch";
    protected static final String BLOCK_OPTIONAL_ROOT = "roots";
    protected static final String BLOCK_OPTIONAL_SAPLING = "sapling";
    protected static final String BLOCK_OPTIONAL_SEED = "seed";
    protected static final String BLOCK_OPTIONAL_STEM = "stem";
    protected static final String BLOCK_OPTIONAL_ROOF = "roof";
    protected static final String BLOCK_OPTIONAL_ROOF_STAIRS = "roof_stairs";
    protected static final String BLOCK_OPTIONAL_ROOF_SLAB = "roof_slab";
    public static final String BLOCK_TABURET = "taburet";
    public static final String BLOCK_CHAIR = "chair";
    public static final String BLOCK_BAR_STOOL = "bar_stool";

    public NetherWoodenMaterial(String name, class_3620 woodColor, class_3620 planksColor) {
        super("betternether", name, "nether", woodColor, planksColor);
    }

    public ComplexMaterial init(BlockRegistry blocksRegistry, ItemRegistry itemsRegistry, PathConfig recipeConfig) {
        return super.init(blocksRegistry, itemsRegistry, recipeConfig);
    }

    public NetherWoodenMaterial init() {
        return (NetherWoodenMaterial)super.init(NetherBlocks.getBlockRegistry(), NetherItems.getItemRegistry(), Configs.RECIPE_CONFIG);
    }

    protected FabricBlockSettings getBlockSettings() {
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_22127).materialColor(this.planksColor);
    }

    protected void _initBase(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        super.initBase(blockSettings, itemSettings);
        TagAPI.TagLocation tagBlockLog = TagAPI.TagLocation.of((class_3494.class_5123)this.getBlockTag("logs"));
        TagAPI.TagLocation tagItemLog = TagAPI.TagLocation.of((class_3494.class_5123)this.getItemTag("logs"));
        this.replaceOrAddBlockEntry(new BlockEntry("stripped_log", (complexMaterial, settings) -> new BaseRotatedPillarBlock((class_4970.class_2251)settings)).setBlockTags(new TagAPI.TagLocation[]{NamedBlockTags.LOGS, tagBlockLog}).setItemTags(new TagAPI.TagLocation[]{NamedItemTags.LOGS, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("stripped_bark", (complexMaterial, settings) -> new BaseBarkBlock((class_4970.class_2251)settings)).setBlockTags(new TagAPI.TagLocation[]{NamedBlockTags.LOGS, tagBlockLog}).setItemTags(new TagAPI.TagLocation[]{NamedItemTags.LOGS, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("log", (complexMaterial, settings) -> new BaseStripableLogBlock(this.woodColor, this.getBlock("stripped_log"))).setBlockTags(new TagAPI.TagLocation[]{NamedBlockTags.LOGS, tagBlockLog}).setItemTags(new TagAPI.TagLocation[]{NamedItemTags.LOGS, tagItemLog}));
        this.replaceOrAddBlockEntry(new BlockEntry("bark", (complexMaterial, settings) -> new StripableBarkBlock(this.woodColor, this.getBlock("stripped_bark"))).setBlockTags(new TagAPI.TagLocation[]{NamedBlockTags.LOGS, tagBlockLog}).setItemTags(new TagAPI.TagLocation[]{NamedItemTags.LOGS, tagItemLog}));
    }

    protected void initDefault(FabricBlockSettings blockSettings, FabricItemSettings itemSettings) {
        this._initBase(blockSettings, itemSettings);
        super.initStorage(blockSettings, itemSettings);
        this.addBlockEntry(new BlockEntry("crafting_table", (complexMaterial, settings) -> new BaseCraftingTableBlock(this.getBlock("planks"))).setBlockTags(new TagAPI.TagLocation[]{NamedCommonBlockTags.WORKBENCHES}).setItemTags(new TagAPI.TagLocation[]{NamedCommonItemTags.WORKBENCHES}));
        this.addBlockEntry(new BlockEntry(BLOCK_TABURET, (complexMaterial, settings) -> new BNTaburet(this.getBlock("slab"))));
        this.addBlockEntry(new BlockEntry(BLOCK_CHAIR, (complexMaterial, settings) -> new BNNormalChair(this.getBlock("slab"))));
        this.addBlockEntry(new BlockEntry(BLOCK_BAR_STOOL, (complexMaterial, settings) -> new BNBarStool(this.getBlock("slab"))));
    }

    public static void makeTaburetRecipe(PathConfig config, class_2960 id, class_2248 taburet, class_2248 planks) {
        GridRecipe.make((class_2960)id, (class_1935)taburet).checkConfig(config).setShape(new String[]{"##", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_taburet").build();
    }

    public static void makeChairRecipe(PathConfig config, class_2960 id, class_2248 chair, class_2248 planks) {
        GridRecipe.make((class_2960)id, (class_1935)chair).checkConfig(config).setShape(new String[]{"I ", "##", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_chair").build();
    }

    public static void makeBarStoolRecipe(PathConfig config, class_2960 id, class_2248 barStool, class_2248 planks) {
        GridRecipe.make((class_2960)id, (class_1935)barStool).checkConfig(config).setShape(new String[]{"##", "II", "II"}).addMaterial('#', new class_1935[]{planks}).addMaterial('I', new class_1935[]{class_1802.field_8600}).setGroup("nether_bar_stool").build();
    }

    protected void initDefaultFurniture() {
        class_2248 slab = this.getSlab();
        if (class_2378.field_11146.method_10221((Object)slab) != class_2378.field_11146.method_10137()) {
            this.addRecipeEntry(new RecipeEntry(BLOCK_TABURET, (material, config, id) -> NetherWoodenMaterial.makeTaburetRecipe(config, id, this.getBlock(BLOCK_TABURET), slab)));
            this.addRecipeEntry(new RecipeEntry(BLOCK_CHAIR, (material, config, id) -> NetherWoodenMaterial.makeChairRecipe(config, id, this.getBlock(BLOCK_CHAIR), slab)));
            this.addRecipeEntry(new RecipeEntry(BLOCK_BAR_STOOL, (material, config, id) -> NetherWoodenMaterial.makeBarStoolRecipe(config, id, this.getBlock(BLOCK_BAR_STOOL), slab)));
        }
    }

    public void initDefaultRecipes() {
        super.initDefaultRecipes();
        this.initDefaultFurniture();
    }

    protected void initFlammable(FlammableBlockRegistry registry) {
    }

    public class_2248 getPlanks() {
        return this.getBlock("planks");
    }

    public class_2248 getSlab() {
        return this.getBlock("slab");
    }

    public class_2248 getLog() {
        return this.getBlock("log");
    }

    public class_2248 getBark() {
        return this.getBlock("bark");
    }

    public class_2248 getStrippedLog() {
        return this.getBlock("stripped_log");
    }

    public class_2248 getStrippedBark() {
        return this.getBlock("stripped_bark");
    }
}

