/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.extragenerators.utils;

import com.google.gson.JsonObject;
import io.github.lucaargolo.extragenerators.common.resource.ResourceCompendium;
import io.github.lucaargolo.extragenerators.utils.InventoryUtils;
import io.github.lucaargolo.extragenerators.utils.InventoryUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\r\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lio/github/lucaargolo/extragenerators/utils/FluidGeneratorFuel;", "", "burnTime", "", "fluidInput", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "energyOutput", "", "(ILnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;D)V", "currentBurnTime", "(IILnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;D)V", "getBurnTime", "()I", "getCurrentBurnTime", "setCurrentBurnTime", "(I)V", "getEnergyOutput", "()D", "getFluidInput", "()Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toBuf", "", "buf", "Lnet/minecraft/network/PacketByteBuf;", "toString", "", "toTag", "Lnet/minecraft/nbt/NbtCompound;", "Companion", "extra-generators"})
public final class FluidGeneratorFuel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int burnTime;
    private int currentBurnTime;
    @NotNull
    private final ResourceAmount<FluidVariant> fluidInput;
    private final double energyOutput;

    public FluidGeneratorFuel(int burnTime, int currentBurnTime, @NotNull ResourceAmount<FluidVariant> fluidInput, double energyOutput) {
        Intrinsics.checkNotNullParameter(fluidInput, (String)"fluidInput");
        this.burnTime = burnTime;
        this.currentBurnTime = currentBurnTime;
        this.fluidInput = fluidInput;
        this.energyOutput = energyOutput;
    }

    public final int getBurnTime() {
        return this.burnTime;
    }

    public final int getCurrentBurnTime() {
        return this.currentBurnTime;
    }

    public final void setCurrentBurnTime(int n) {
        this.currentBurnTime = n;
    }

    @NotNull
    public final ResourceAmount<FluidVariant> getFluidInput() {
        return this.fluidInput;
    }

    public final double getEnergyOutput() {
        return this.energyOutput;
    }

    public FluidGeneratorFuel(int burnTime, @NotNull ResourceAmount<FluidVariant> fluidInput, double energyOutput) {
        Intrinsics.checkNotNullParameter(fluidInput, (String)"fluidInput");
        this(burnTime, burnTime, fluidInput, energyOutput);
    }

    @NotNull
    public final class_2487 toTag() {
        class_2487 class_24872 = new class_2487();
        boolean bl = false;
        boolean bl2 = false;
        class_2487 it = class_24872;
        boolean bl3 = false;
        it.method_10569("burnTime", this.getBurnTime());
        it.method_10569("currentBurnTime", this.getCurrentBurnTime());
        it.method_10566("fluidInput", (class_2520)InventoryUtilsKt.toNbt$default(this.getFluidInput(), null, 1, null));
        it.method_10549("energyOutput", this.getEnergyOutput());
        return class_24872;
    }

    public final void toBuf(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.burnTime);
        buf.writeInt(this.currentBurnTime);
        InventoryUtilsKt.toMcBuffer(this.fluidInput, buf);
        buf.writeDouble(this.energyOutput);
    }

    public final int component1() {
        return this.burnTime;
    }

    public final int component2() {
        return this.currentBurnTime;
    }

    @NotNull
    public final ResourceAmount<FluidVariant> component3() {
        return this.fluidInput;
    }

    public final double component4() {
        return this.energyOutput;
    }

    @NotNull
    public final FluidGeneratorFuel copy(int burnTime, int currentBurnTime, @NotNull ResourceAmount<FluidVariant> fluidInput, double energyOutput) {
        Intrinsics.checkNotNullParameter(fluidInput, (String)"fluidInput");
        return new FluidGeneratorFuel(burnTime, currentBurnTime, fluidInput, energyOutput);
    }

    public static /* synthetic */ FluidGeneratorFuel copy$default(FluidGeneratorFuel fluidGeneratorFuel, int n, int n2, ResourceAmount resourceAmount, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = fluidGeneratorFuel.burnTime;
        }
        if ((n3 & 2) != 0) {
            n2 = fluidGeneratorFuel.currentBurnTime;
        }
        if ((n3 & 4) != 0) {
            resourceAmount = fluidGeneratorFuel.fluidInput;
        }
        if ((n3 & 8) != 0) {
            d = fluidGeneratorFuel.energyOutput;
        }
        return fluidGeneratorFuel.copy(n, n2, resourceAmount, d);
    }

    @NotNull
    public String toString() {
        return "FluidGeneratorFuel(burnTime=" + this.burnTime + ", currentBurnTime=" + this.currentBurnTime + ", fluidInput=" + this.fluidInput + ", energyOutput=" + this.energyOutput + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.burnTime);
        result = result * 31 + Integer.hashCode(this.currentBurnTime);
        result = result * 31 + this.fluidInput.hashCode();
        result = result * 31 + Double.hashCode(this.energyOutput);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FluidGeneratorFuel)) {
            return false;
        }
        FluidGeneratorFuel fluidGeneratorFuel = (FluidGeneratorFuel)other;
        if (this.burnTime != fluidGeneratorFuel.burnTime) {
            return false;
        }
        if (this.currentBurnTime != fluidGeneratorFuel.currentBurnTime) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fluidInput, fluidGeneratorFuel.fluidInput)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.energyOutput, (Object)fluidGeneratorFuel.energyOutput);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lio/github/lucaargolo/extragenerators/utils/FluidGeneratorFuel$Companion;", "", "()V", "fromBuf", "Lio/github/lucaargolo/extragenerators/utils/FluidGeneratorFuel;", "buf", "Lnet/minecraft/network/PacketByteBuf;", "fromFluidResource", "id", "", "fluid", "Lnet/minecraft/fluid/Fluid;", "fromJson", "jsonObject", "Lcom/google/gson/JsonObject;", "fromRedstoneGeneratorFuel", "itemStack", "Lnet/minecraft/item/ItemStack;", "fromSteamGeneratorFuel", "fromTag", "tag", "Lnet/minecraft/nbt/NbtCompound;", "extra-generators"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FluidGeneratorFuel fromTag(@NotNull class_2487 tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            int burnTime = tag.method_10550("burnTime");
            int currentBurnTime = tag.method_10550("currentBurnTime");
            class_2487 class_24872 = tag.method_10562("fluidInput");
            Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"tag.getCompound(\"fluidInput\")");
            ResourceAmount<FluidVariant> fluidInput = InventoryUtils.INSTANCE.fluidResourceFromNbt(class_24872);
            double energyOutput = tag.method_10574("energyOutput");
            return energyOutput == 0.0 ? null : new FluidGeneratorFuel(burnTime, currentBurnTime, fluidInput, energyOutput);
        }

        @Nullable
        public final FluidGeneratorFuel fromBuf(@NotNull class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int burnTime = buf.readInt();
            int currentBurnTime = buf.readInt();
            ResourceAmount<FluidVariant> fluidInput = InventoryUtils.INSTANCE.fluidResourceFromMcBuffer(buf);
            double energyOutput = buf.readDouble();
            return energyOutput == 0.0 ? null : new FluidGeneratorFuel(burnTime, currentBurnTime, fluidInput, energyOutput);
        }

        @Nullable
        public final FluidGeneratorFuel fromJson(@NotNull JsonObject jsonObject) {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            int burnTime = jsonObject.get("burnTime").getAsInt();
            JsonObject jsonObject2 = jsonObject.get("fluidInput").getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jsonObject.get(\"fluidInput\").asJsonObject");
            ResourceAmount<FluidVariant> fluidInput = InventoryUtils.INSTANCE.fluidResourceFromJson(jsonObject2);
            double energyOutput = jsonObject.get("energyOutput").getAsDouble();
            return energyOutput == 0.0 ? null : new FluidGeneratorFuel(burnTime, fluidInput, energyOutput);
        }

        @Nullable
        public final FluidGeneratorFuel fromFluidResource(@NotNull String id, @NotNull class_3611 fluid) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            return ResourceCompendium.INSTANCE.getFLUID_GENERATORS().test(id, fluid);
        }

        @Nullable
        public final FluidGeneratorFuel fromSteamGeneratorFuel(@NotNull class_1799 itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Integer n = (Integer)FuelRegistryImpl.INSTANCE.get((class_1935)itemStack.method_7909());
            if (n == null) {
                return null;
            }
            int burnTicks = n;
            double d = (double)burnTicks / 4.0;
            boolean bl = false;
            return new FluidGeneratorFuel((int)Math.rint(d), (ResourceAmount<FluidVariant>)new ResourceAmount((Object)FluidVariant.of((class_3611)((class_3611)class_3612.field_15910)), (long)burnTicks * (long)81), (double)burnTicks * 16.0);
        }

        @Nullable
        public final FluidGeneratorFuel fromRedstoneGeneratorFuel(@NotNull class_1799 itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            class_1792 class_17922 = itemStack.method_7909();
            return Intrinsics.areEqual((Object)class_17922, (Object)class_1802.field_8725) ? new FluidGeneratorFuel(100, (ResourceAmount<FluidVariant>)new ResourceAmount((Object)FluidVariant.of((class_3611)((class_3611)class_3612.field_15908)), 4050L), 12800.0) : (Intrinsics.areEqual((Object)class_17922, (Object)class_1802.field_8793) ? new FluidGeneratorFuel(900, (ResourceAmount<FluidVariant>)new ResourceAmount((Object)FluidVariant.of((class_3611)((class_3611)class_3612.field_15908)), 36450L), 115200.0) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

