/*
 * Decompiled with CFR 0.152.
 */
package draylar.fabricfurnaces.registry;

import draylar.fabricfurnaces.FabricFurnaces;
import draylar.fabricfurnaces.block.CrystalFurnaceBlock;
import draylar.fabricfurnaces.block.FabricFurnaceBlock;
import draylar.fabricfurnaces.config.FurnaceData;
import draylar.fabricfurnaces.item.FurnaceItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.block.FabricBlockSettings;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3614;

public class FFBlocks {
    public static final List<class_2248> allFurnaces = new ArrayList<class_2248>();
    public static final List<class_2248> crystalFurnaces = new ArrayList<class_2248>();
    public static final List<class_2248> regularFurnaces = new ArrayList<class_2248>();

    public static void init() {
        FabricFurnaces.CONFIG.furnaceData.forEach(FFBlocks::registerFurnace);
        FabricFurnaces.CONFIG.furnaceData.forEach(FFBlocks::registerCrystalFurnace);
    }

    private static void registerFurnace(FurnaceData data) {
        FabricFurnaceBlock baseFurnace = FFBlocks.register(data.getName(), new FabricFurnaceBlock(FabricBlockSettings.of((class_3614)class_3614.field_15914).hardness(3.5f).build().method_9631(FFBlocks.createLightLevelFromBlockState(13)), data.getSpeedModifier(), data.getFuelModifier(), data.getDuplicationChance()));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)data.getID(), (Object)((Object)new FurnaceItem(baseFurnace, new class_1792.class_1793().method_7892(FabricFurnaces.GROUP))));
        regularFurnaces.add((class_2248)baseFurnace);
        allFurnaces.add((class_2248)baseFurnace);
    }

    private static void registerCrystalFurnace(FurnaceData data) {
        FabricFurnaceBlock crystalFurnace = FFBlocks.register(String.format("crystal_%s", data.getName()), new CrystalFurnaceBlock(FabricBlockSettings.of((class_3614)class_3614.field_15914).nonOpaque().hardness(3.5f).build().method_9631(FFBlocks.createLightLevelFromBlockState(13)).method_22488(), data.getSpeedModifier(), data.getFuelModifier(), data.getDuplicationChance()));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)FabricFurnaces.id(String.format("crystal_%s", data.getName())), (Object)((Object)new FurnaceItem(crystalFurnace, new class_1792.class_1793().method_7892(FabricFurnaces.GROUP))));
        crystalFurnaces.add((class_2248)crystalFurnace);
        allFurnaces.add((class_2248)crystalFurnace);
    }

    private static FabricFurnaceBlock register(String name, FabricFurnaceBlock block) {
        return (FabricFurnaceBlock)((Object)class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("fabric-furnaces", name), (Object)((Object)block)));
    }

    public static List<class_2248> getFurnaces() {
        return allFurnaces;
    }

    public static List<class_2248> getCrystalFurnaces() {
        return crystalFurnaces;
    }

    private static ToIntFunction<class_2680> createLightLevelFromBlockState(int litLevel) {
        return blockState -> (Boolean)blockState.method_11654((class_2769)class_2741.field_12548) != false ? litLevel : 0;
    }
}

