/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.event;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockPosWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.ServerLevelWrapper;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class LeafBreakingListener {
    @NotNull
    private final FallingTreeCommon<Direction> mod;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            this.mod.getLeafBreakingHandler().onServerTick();
        }
    }

    @SubscribeEvent
    public void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState eventState = event.getState();
            BlockPos eventPos = event.getPos();
            this.mod.getLeafBreakingHandler().onBlockUpdate(new ServerLevelWrapper(level), new BlockPosWrapper(eventPos), new BlockStateWrapper(eventState), event.getNotifiedSides().stream().map(this.mod::asDirectionCompat).collect(Collectors.toSet()));
        }
    }

    public LeafBreakingListener(@NotNull FallingTreeCommon<Direction> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

