/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.tree.builder.position;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.common.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.common.wrapper.IBlock;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AbovePositionFetcher
implements IPositionFetcher {
    private static AbovePositionFetcher INSTANCE;
    private static AbovePositionFetcher SECOND_STEP_INSTANCE;
    @NotNull
    private final FallingTreeCommon<?> mod;
    @NotNull
    private final Function<IBlockPos, IBlockPos> lowerPosProvider;
    @NotNull
    private final Supplier<IPositionFetcher> positionFetcherSupplier;

    @Override
    @NotNull
    public Collection<ToAnalyzePos> getPositions(@NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull ToAnalyzePos parent) {
        IBlockPos parentPos = parent.checkPos();
        IBlock parentBlock = level.getBlockState(parentPos).getBlock();
        return parentPos.betweenClosedStream(parentPos.above().north().east(), this.lowerPosProvider.apply(parentPos).south().west()).map(checkPos -> {
            IBlock checkBlock = level.getBlockState((IBlockPos)checkPos).getBlock();
            return new ToAnalyzePos(this.positionFetcherSupplier.get(), parentPos, parentBlock, checkPos.immutable(), checkBlock, this.mod.getTreePart(checkBlock), parent.sequence() + 1);
        }).collect(Collectors.toList());
    }

    public static AbovePositionFetcher getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AbovePositionFetcher(common, IBlockPos::above, () -> AbovePositionFetcher.getSecondStepInstance(common));
        }
        return INSTANCE;
    }

    private static AbovePositionFetcher getSecondStepInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(SECOND_STEP_INSTANCE)) {
            SECOND_STEP_INSTANCE = new AbovePositionFetcher(common, Function.identity(), () -> BasicPositionFetcher.getInstance(common));
        }
        return SECOND_STEP_INSTANCE;
    }

    private AbovePositionFetcher(@NotNull FallingTreeCommon<?> mod, @NotNull Function<IBlockPos, IBlockPos> lowerPosProvider, @NotNull Supplier<IPositionFetcher> positionFetcherSupplier) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        if (lowerPosProvider == null) {
            throw new NullPointerException("lowerPosProvider is marked non-null but is null");
        }
        if (positionFetcherSupplier == null) {
            throw new NullPointerException("positionFetcherSupplier is marked non-null but is null");
        }
        this.mod = mod;
        this.lowerPosProvider = lowerPosProvider;
        this.positionFetcherSupplier = positionFetcherSupplier;
    }
}

