/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.block;

import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.block.fabric.ToolTypeImpl;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_3494;

public final class ToolType {
    private static final Map<String, ToolType> TYPES = Maps.newConcurrentMap();
    public static final ToolType PICKAXE = ToolType.create("pickaxe", ToolType::pickaxeTag);
    public static final ToolType AXE = ToolType.create("axe", ToolType::axeTag);
    public static final ToolType HOE = ToolType.create("hoe", ToolType::hoeTag);
    public static final ToolType SHOVEL = ToolType.create("shovel", ToolType::shovelTag);
    public final String forgeName;
    public final Supplier<class_3494<class_1792>> fabricTag;
    private Object obj;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_3494<class_1792> pickaxeTag() {
        return ToolTypeImpl.pickaxeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_3494<class_1792> axeTag() {
        return ToolTypeImpl.axeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_3494<class_1792> hoeTag() {
        return ToolTypeImpl.hoeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_3494<class_1792> shovelTag() {
        return ToolTypeImpl.shovelTag();
    }

    private ToolType(String forgeName, Supplier<class_3494<class_1792>> fabricTag) {
        this.forgeName = forgeName;
        this.fabricTag = fabricTag;
    }

    public static ToolType create(String forgeName, Supplier<class_3494<class_1792>> fabricTag) {
        return TYPES.computeIfAbsent(forgeName, s -> new ToolType((String)s, fabricTag));
    }

    public static ToolType byName(String forgeName) {
        return TYPES.get(forgeName);
    }
}

