/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client;

import java.util.Iterator;
import java.util.Queue;
import me.flashyreese.mods.sodiumextra.common.util.EvictingQueue;
import me.flashyreese.mods.sodiumextra.mixin.gui.MinecraftClientAccessor;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class ClientTickHandler {
    private final Queue<Integer> averageFps = new EvictingQueue<Integer>(200);

    public void onClientInitialize() {
        ClientTickEvents.START_CLIENT_TICK.register(minecraftClient -> {
            int currentFPS = ((MinecraftClientAccessor)minecraftClient).getCurrentFPS();
            this.averageFps.add(currentFPS);
        });
    }

    public int getAverageFps() {
        int actualAverageFPS = 0;
        Iterator iterator = this.averageFps.iterator();
        while (iterator.hasNext()) {
            int fps = (Integer)iterator.next();
            actualAverageFPS += fps;
        }
        return actualAverageFPS / this.averageFps.size();
    }

    public int getLowestFps() {
        int temp = -1;
        Iterator iterator = this.averageFps.iterator();
        while (iterator.hasNext()) {
            int fps = (Integer)iterator.next();
            if (temp != -1 && fps >= temp) continue;
            temp = fps;
        }
        return temp;
    }

    public int getHighestFps() {
        int temp = -1;
        Iterator iterator = this.averageFps.iterator();
        while (iterator.hasNext()) {
            int fps = (Integer)iterator.next();
            if (temp != -1 && fps <= temp) continue;
            temp = fps;
        }
        return temp;
    }
}

