/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.recipes.machines;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.steven.indrev.components.CraftingComponent;
import me.steven.indrev.components.FluidComponent;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.entries.InputEntry;
import me.steven.indrev.recipes.machines.entries.OutputEntry;
import me.steven.indrev.utils.FluidutilsKt;
import me.steven.indrev.utils.IRFluidTank;
import me.steven.indrev.utils.UtilsKt;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J$\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016R\"\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00070\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00070\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lme/steven/indrev/recipes/machines/IRRecipe;", "()V", "fluidInput", "", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "Lme/steven/indrev/utils/IRFluidAmount;", "getFluidInput", "()[Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "fluidOutput", "getFluidOutput", "canStart", "", "component", "Lme/steven/indrev/components/CraftingComponent;", "matches", "inv", "", "Lnet/minecraft/item/ItemStack;", "fluidVolume", "Lme/steven/indrev/utils/IRFluidTank;", "IRFluidRecipeSerializer", "indrev"})
public abstract class IRFluidRecipe
implements IRRecipe {
    @NotNull
    public abstract ResourceAmount<FluidVariant>[] getFluidInput();

    @NotNull
    public abstract ResourceAmount<FluidVariant>[] getFluidOutput();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull List<class_1799> inv, @NotNull List<IRFluidTank> fluidVolume) {
        Intrinsics.checkNotNullParameter(inv, (String)"inv");
        Intrinsics.checkNotNullParameter(fluidVolume, (String)"fluidVolume");
        if (!(this.getFluidInput().length == 0)) {
            boolean bl;
            if (((Collection)fluidVolume).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Iterable $this$all$iv = (Iterable)ArraysKt.getIndices((Object[])this.getFluidInput());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int index = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl3 = false;
                    IRFluidTank vol = fluidVolume.get(index);
                    if (!Intrinsics.areEqual((Object)vol.getResource(), (Object)this.getFluidInput()[index].resource())) return false;
                    if (vol.amount < this.getFluidInput()[index].amount()) return false;
                    boolean bl4 = true;
                    if (bl4) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
            if (!IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume)) return false;
            return true;
        }
        boolean bl = IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume);
        return bl;
    }

    @Override
    public boolean canStart(@NotNull CraftingComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        FluidComponent fluidComponent2 = component.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
        FluidComponent fluidComponent3 = fluidComponent2;
        int[] outputTankVolume = fluidComponent3.getOutputTanks();
        if (!(this.getFluidOutput().length == 0)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = (Iterable)ArraysKt.getIndices((Object[])this.getFluidOutput());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int index = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        IRFluidTank vol = fluidComponent3.get(outputTankVolume[index]);
                        if (!(!vol.isEmpty() && (!Intrinsics.areEqual((Object)vol.getResource(), (Object)this.getFluidOutput()[index].resource()) || vol.amount + this.getFluidOutput()[index].amount() > fluidComponent3.getLimit()))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        return IRRecipe.DefaultImpls.canStart(this, component);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="matches(Inventory, FluidVolume?)", imports={}), level=DeprecationLevel.ERROR)
    public boolean method_8115(@Nullable class_1263 inv, @Nullable class_1937 world) {
        return IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, world);
    }

    @Override
    public boolean matches(@NotNull class_1799 stack2, @NotNull List<IRFluidTank> fluidVolume) {
        return IRRecipe.DefaultImpls.matches((IRRecipe)this, stack2, fluidVolume);
    }

    @Override
    @NotNull
    public class_2960 method_8114() {
        return IRRecipe.DefaultImpls.getId(this);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="craft(Random)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8116(@Nullable class_1263 inv) {
        return IRRecipe.DefaultImpls.craft((IRRecipe)this, inv);
    }

    @Override
    @NotNull
    public List<class_1799> craft(@Nullable Random random) {
        return IRRecipe.DefaultImpls.craft((IRRecipe)this, random);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="output", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8110() {
        return IRRecipe.DefaultImpls.getOutput(this);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="input", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_2371<class_1856> method_8117() {
        return IRRecipe.DefaultImpls.getIngredients(this);
    }

    @Override
    public boolean method_31584() {
        return IRRecipe.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean method_8118() {
        return IRRecipe.DefaultImpls.isIgnoredInRecipeBook(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003Bc\u0012\\\u0010\u0004\u001aX\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aRd\u0010\u0004\u001aX\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe$IRFluidRecipeSerializer;", "T", "Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lnet/minecraft/recipe/RecipeSerializer;", "factory", "Lkotlin/Function6;", "Lnet/minecraft/util/Identifier;", "", "Lme/steven/indrev/recipes/machines/entries/InputEntry;", "Lme/steven/indrev/recipes/machines/entries/OutputEntry;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "Lme/steven/indrev/utils/IRFluidAmount;", "", "(Lkotlin/jvm/functions/Function6;)V", "read", "id", "json", "Lcom/google/gson/JsonObject;", "(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "buf", "Lnet/minecraft/network/PacketByteBuf;", "(Lnet/minecraft/util/Identifier;Lnet/minecraft/network/PacketByteBuf;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "write", "", "recipe", "(Lnet/minecraft/network/PacketByteBuf;Lme/steven/indrev/recipes/machines/IRFluidRecipe;)V", "indrev"})
    public static class IRFluidRecipeSerializer<T extends IRFluidRecipe>
    implements class_1865<T> {
        @NotNull
        private final Function6<class_2960, InputEntry[], OutputEntry[], ResourceAmount<FluidVariant>[], ResourceAmount<FluidVariant>[], Integer, T> factory;

        public IRFluidRecipeSerializer(@NotNull Function6<? super class_2960, ? super InputEntry[], ? super OutputEntry[], ? super ResourceAmount<FluidVariant>[], ? super ResourceAmount<FluidVariant>[], ? super Integer, ? extends T> factory) {
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            this.factory = factory;
        }

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int ticks = buf.readInt();
            int inputFluidsSize = buf.readInt();
            List inputFluids = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)inputFluidsSize);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int $noName_0 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                inputFluids.add(FluidutilsKt.fromPacket(buf));
            }
            int outputFluidsSize = buf.readInt();
            List outputFluids = new ArrayList();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)outputFluidsSize);
            boolean $i$f$forEach2 = false;
            Iterator $noName_0 = $this$forEach$iv2.iterator();
            while ($noName_0.hasNext()) {
                int element$iv;
                int $noName_02 = element$iv = ((IntIterator)$noName_0).nextInt();
                boolean bl = false;
                outputFluids.add(FluidutilsKt.fromPacket(buf));
            }
            int size = buf.readInt();
            List ingredients = new ArrayList();
            Iterable $this$forEach$iv3 = (Iterable)RangesKt.until((int)0, (int)size);
            boolean $i$f$forEach3 = false;
            Iterator $noName_02 = $this$forEach$iv3.iterator();
            while ($noName_02.hasNext()) {
                int element$iv;
                int $noName_03 = element$iv = ((IntIterator)$noName_02).nextInt();
                boolean bl = false;
                class_1856 ingredient = class_1856.method_8086((class_2540)buf);
                int count = buf.readInt();
                Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"ingredient");
                ingredients.add(new InputEntry(ingredient, count));
            }
            int outputSize = buf.readInt();
            List output = new ArrayList();
            Iterable $this$forEach$iv4 = (Iterable)RangesKt.until((int)0, (int)outputSize);
            boolean $i$f$forEach4 = false;
            Iterator $noName_03 = $this$forEach$iv4.iterator();
            while ($noName_03.hasNext()) {
                int element$iv;
                int $noName_04 = element$iv = ((IntIterator)$noName_03).nextInt();
                boolean bl = false;
                class_1799 stack2 = buf.method_10819();
                double chance = buf.readDouble();
                Intrinsics.checkNotNullExpressionValue((Object)stack2, (String)"stack");
                output.add(new OutputEntry(stack2, chance));
            }
            Collection $this$toTypedArray$iv = ingredients;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            InputEntry[] inputEntryArray = thisCollection$iv.toArray(new InputEntry[0]);
            if (inputEntryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $this$toTypedArray$iv = output;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            OutputEntry[] outputEntryArray = thisCollection$iv.toArray(new OutputEntry[0]);
            if (outputEntryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $this$toTypedArray$iv = inputFluids;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            ResourceAmount[] resourceAmountArray = thisCollection$iv.toArray(new ResourceAmount[0]);
            if (resourceAmountArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $this$toTypedArray$iv = outputFluids;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            ResourceAmount[] resourceAmountArray2 = thisCollection$iv.toArray(new ResourceAmount[0]);
            if (resourceAmountArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)inputEntryArray, (Object)outputEntryArray, (Object)resourceAmountArray, (Object)resourceAmountArray2, (Object)ticks));
        }

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull JsonObject json) {
            ResourceAmount<FluidVariant>[] resourceAmountArray;
            ResourceAmount<FluidVariant>[] resourceAmountArray2;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            InputEntry[] ingredients = IRRecipe.Companion.ingredientsFromElement(json.get("ingredients"));
            int ticks = json.get("processTime").getAsInt();
            OutputEntry[] output = IRRecipe.Companion.itemStacksFromElement(json.get("output"));
            JsonElement fluidInputJson = json.get("fluidInput");
            if (fluidInputJson == null) {
                boolean $i$f$emptyArray = false;
                resourceAmountArray2 = new ResourceAmount[]{};
            } else {
                resourceAmountArray2 = UtilsKt.getFluidFromJson(fluidInputJson);
            }
            ResourceAmount<FluidVariant>[] fluidInput = resourceAmountArray2;
            JsonElement fluidOutputJson = json.get("fluidOutput");
            if (fluidOutputJson == null) {
                boolean $i$f$emptyArray = false;
                resourceAmountArray = new ResourceAmount[]{};
            } else {
                resourceAmountArray = UtilsKt.getFluidFromJson(fluidOutputJson);
            }
            ResourceAmount<FluidVariant>[] fluidOutput = resourceAmountArray;
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)ingredients, (Object)output, fluidInput, fluidOutput, (Object)ticks));
        }

        public void write(@NotNull class_2540 buf, @NotNull T recipe) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
            buf.writeInt(recipe.getTicks());
            buf.writeInt(((IRFluidRecipe)recipe).getFluidInput().length);
            Object[] $this$forEach$iv = ((IRFluidRecipe)recipe).getFluidInput();
            boolean $i$f$forEach = false;
            for (ResourceAmount<FluidVariant> element$iv : $this$forEach$iv) {
                ResourceAmount<FluidVariant> fluidInput = element$iv;
                boolean bl = false;
                FluidutilsKt.toPacket(fluidInput, buf);
            }
            buf.writeInt(((IRFluidRecipe)recipe).getFluidOutput().length);
            $this$forEach$iv = ((IRFluidRecipe)recipe).getFluidOutput();
            $i$f$forEach = false;
            for (ResourceAmount<FluidVariant> element$iv : $this$forEach$iv) {
                ResourceAmount<FluidVariant> fluidOutput = element$iv;
                boolean bl = false;
                FluidutilsKt.toPacket(fluidOutput, buf);
            }
            buf.writeInt(recipe.getInput().length);
            $this$forEach$iv = recipe.getInput();
            $i$f$forEach = false;
            for (ResourceAmount<FluidVariant> element$iv : $this$forEach$iv) {
                ResourceAmount<FluidVariant> $dstr$ingredient$count = element$iv;
                boolean bl = false;
                class_1856 ingredient = $dstr$ingredient$count.component1();
                int count = $dstr$ingredient$count.component2();
                ingredient.method_8088(buf);
                buf.writeInt(count);
            }
            buf.writeInt(recipe.getOutputs().length);
            $this$forEach$iv = recipe.getOutputs();
            $i$f$forEach = false;
            for (ResourceAmount<FluidVariant> element$iv : $this$forEach$iv) {
                ResourceAmount<FluidVariant> $dstr$stack$chance = element$iv;
                boolean bl = false;
                class_1799 stack2 = $dstr$stack$chance.component1();
                double chance = $dstr$stack$chance.component2();
                buf.method_10793(stack2);
                buf.writeDouble(chance);
            }
        }
    }
}

