/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks.fluid;

import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blocks.machine.pipes.FluidPipeBlock;
import me.steven.indrev.config.IRConfig;
import me.steven.indrev.networks.EndpointData;
import me.steven.indrev.networks.Network;
import me.steven.indrev.networks.Node;
import me.steven.indrev.networks.ServoNetworkState;
import me.steven.indrev.networks.fluid.FluidNetworkState;
import me.steven.indrev.utils.FluidutilsKt;
import me.steven.indrev.utils.HelperextensionsKt;
import me.steven.indrev.utils.ReusableArrayDeque;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ;2\u00020\u0001:\u0001;B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006H\u0016J@\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110/H\u0002J\u0010\u00100\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016JB\u00101\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00062\u0006\u00102\u001a\u00020\n2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00104\u001a\u0002052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020-0,H\u0002JB\u00107\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00062\u0006\u00102\u001a\u00020\n2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00104\u001a\u0002052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020-0,H\u0002J\u0018\u00108\u001a\u00020#2\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010:H\u0002R,\u0010\f\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006<"}, d2={"Lme/steven/indrev/networks/fluid/FluidNetwork;", "Lme/steven/indrev/networks/Network;", "world", "Lnet/minecraft/server/world/ServerWorld;", "pipes", "", "Lnet/minecraft/util/math/BlockPos;", "containers", "", "Ljava/util/EnumSet;", "Lnet/minecraft/util/math/Direction;", "(Lnet/minecraft/server/world/ServerWorld;Ljava/util/Set;Ljava/util/Map;)V", "deques", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Ljava/util/EnumMap;", "Lme/steven/indrev/networks/EndpointData$Mode;", "Lme/steven/indrev/utils/ReusableArrayDeque;", "Lme/steven/indrev/networks/Node;", "lastTransferred", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "getLastTransferred", "()Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "setLastTransferred", "(Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;)V", "maxCableTransfer", "", "getMaxCableTransfer", "()J", "tier", "Lme/steven/indrev/api/machines/Tier;", "getTier", "()Lme/steven/indrev/api/machines/Tier;", "setTier", "(Lme/steven/indrev/api/machines/Tier;)V", "appendPipe", "", "block", "Lnet/minecraft/block/Block;", "blockPos", "getQueue", "pos", "data", "Lme/steven/indrev/networks/EndpointData;", "filter", "Lkotlin/Function1;", "", "nodes", "", "tick", "tickOutput", "dir", "queue", "state", "Lme/steven/indrev/networks/fluid/FluidNetworkState;", "fluidFilter", "tickRetriever", "updateLastTransferred", "extractable", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Companion", "indrev"})
public final class FluidNetwork
extends Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Tier tier;
    @NotNull
    private FluidVariant lastTransferred;
    @NotNull
    private final Object2ObjectOpenHashMap<class_2338, EnumMap<EndpointData.Mode, ReusableArrayDeque<Node>>> deques;
    @NotNull
    private static final FluidFilter NO_FLUID_FILTER = FluidNetwork::NO_FLUID_FILTER$lambda-4;

    public FluidNetwork(@NotNull class_3218 world, @NotNull Set<class_2338> pipes, @NotNull Map<class_2338, EnumSet<class_2350>> containers) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(pipes, (String)"pipes");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        super(Network.Type.Companion.getFLUID(), world, pipes, containers);
        this.tier = Tier.MK1;
        FluidVariant fluidVariant = FluidVariant.blank();
        Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"blank()");
        this.lastTransferred = fluidVariant;
        this.deques = new Object2ObjectOpenHashMap();
    }

    public /* synthetic */ FluidNetwork(class_3218 class_32182, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = (Set)new ObjectOpenHashSet();
        }
        if ((n & 4) != 0) {
            map = (Map)new Object2ObjectOpenHashMap();
        }
        this(class_32182, set, map);
    }

    @NotNull
    public final Tier getTier() {
        return this.tier;
    }

    public final void setTier(@NotNull Tier tier) {
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"<set-?>");
        this.tier = tier;
    }

    private final long getMaxCableTransfer() {
        return (long)(switch (WhenMappings.$EnumSwitchMapping$0[this.tier.ordinal()]) {
            case 1 -> IRConfig.INSTANCE.getCables().getFluidPipeMk1();
            case 2 -> IRConfig.INSTANCE.getCables().getFluidPipeMk2();
            case 3 -> IRConfig.INSTANCE.getCables().getFluidPipeMk3();
            default -> IRConfig.INSTANCE.getCables().getFluidPipeMk4();
        }) * FluidutilsKt.getBucket();
    }

    @NotNull
    public final FluidVariant getLastTransferred() {
        return this.lastTransferred;
    }

    public final void setLastTransferred(@NotNull FluidVariant fluidVariant) {
        Intrinsics.checkNotNullParameter((Object)fluidVariant, (String)"<set-?>");
        this.lastTransferred = fluidVariant;
    }

    @Override
    public void tick(@NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (world.method_8510() % (long)20 != 0L) {
            return;
        }
        FluidNetworkState state = (FluidNetworkState)Network.Type.Companion.getFLUID().getNetworkState(world);
        if (this.isQueueValid()) {
            Map<class_2338, EnumSet<class_2350>> $this$forEach$iv = this.getContainers();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<class_2338, EnumSet<class_2350>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_2338, EnumSet<class_2350>> element$iv;
                Map.Entry<class_2338, EnumSet<class_2350>> $dstr$pos$directions = element$iv = iterator.next();
                boolean bl = false;
                class_2338 pos = $dstr$pos$directions.getKey();
                EnumSet<class_2350> directions = $dstr$pos$directions.getValue();
                if (!HelperextensionsKt.isLoaded((class_1937)world, pos) || (List)this.getQueue().get((Object)pos) == null) continue;
                Iterable $this$forEach$iv2 = directions;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    List nodes;
                    EndpointData data;
                    class_2350 dir = (class_2350)element$iv2;
                    boolean bl2 = false;
                    ServoNetworkState servoNetworkState = state;
                    class_2338 class_23382 = pos.method_10093(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"pos.offset(dir)");
                    class_2338 class_23383 = class_23382;
                    class_23382 = dir.method_10153();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"dir.opposite");
                    if (ServoNetworkState.getEndpointData$default(servoNetworkState, class_23383, (class_2350)class_23382, false, 4, null) == null) continue;
                    Function1 filter2 = (Function1)new Function1<FluidVariant, Boolean>(this){
                        final /* synthetic */ FluidNetwork this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull FluidVariant v) {
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            return !this.this$0.getLastTransferred().isBlank() && Intrinsics.areEqual((Object)v, (Object)this.this$0.getLastTransferred());
                        }
                    };
                    ReusableArrayDeque<Node> deque = this.getQueue(pos, data, (Function1<? super FluidVariant, Boolean>)filter2, nodes);
                    if (data.getType() == EndpointData.Type.OUTPUT) {
                        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                        this.tickOutput(pos, dir, deque, state, (Function1<? super FluidVariant, Boolean>)filter2);
                    } else if (data.getType() == EndpointData.Type.RETRIEVER) {
                        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                        this.tickRetriever(pos, dir, deque, state, (Function1<? super FluidVariant, Boolean>)filter2);
                    }
                    deque.resetHead();
                }
            }
        }
        FluidVariant fluidVariant = FluidVariant.blank();
        Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"blank()");
        this.lastTransferred = fluidVariant;
    }

    private final ReusableArrayDeque<Node> getQueue(class_2338 pos, EndpointData data, Function1<? super FluidVariant, Boolean> filter2, List<Node> nodes) {
        Object this_$iv;
        boolean $i$f$apply;
        Object transform$iv;
        ReusableArrayDeque<Node> queue;
        EnumMap queuesByNodes = (EnumMap)this.deques.get((Object)pos);
        if (queuesByNodes == null) {
            queuesByNodes = new EnumMap(EndpointData.Mode.class);
            ((Map)this.deques).put(pos, queuesByNodes);
        }
        if ((queue = (ReusableArrayDeque<Node>)((Object)queuesByNodes.get((Object)data.getMode()))) == null) {
            ReusableArrayDeque<Node> reusableArrayDeque = queue = new ReusableArrayDeque<Node>((Collection)nodes);
            EndpointData.Mode mode = data.getMode();
            Intrinsics.checkNotNull((Object)((Object)mode));
            transform$iv = mode.getFluidSorter(this.getWorld(), data.getType(), (Function1<? super FluidVariant, Boolean>)((Function1)new Function1<FluidVariant, Boolean>(filter2){
                final /* synthetic */ Function1<FluidVariant, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FluidVariant it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)it);
                }
            }));
            $i$f$apply = false;
            transform$iv.invoke((Object)((ReusableArrayDeque)((Object)this_$iv)).getElementData());
            this_$iv = queuesByNodes;
            transform$iv = data.getMode();
            this_$iv.put(transform$iv, queue);
        }
        if (data.getMode() == EndpointData.Mode.ROUND_ROBIN || data.getMode() == EndpointData.Mode.RANDOM) {
            this_$iv = queue;
            EndpointData.Mode mode = data.getMode();
            Intrinsics.checkNotNull((Object)((Object)mode));
            transform$iv = mode.getFluidSorter(this.getWorld(), data.getType(), (Function1<? super FluidVariant, Boolean>)((Function1)new Function1<FluidVariant, Boolean>(filter2){
                final /* synthetic */ Function1<FluidVariant, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FluidVariant it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)it);
                }
            }));
            $i$f$apply = false;
            transform$iv.invoke((Object)((ReusableArrayDeque)((Object)this_$iv)).getElementData());
        }
        return queue;
    }

    private final void tickOutput(class_2338 pos, class_2350 dir, ReusableArrayDeque<Node> queue, FluidNetworkState state, Function1<? super FluidVariant, Boolean> fluidFilter2) {
        Storage<FluidVariant> extractable = FluidutilsKt.fluidStorageOf(this.getWorld(), pos, dir);
        long remaining = this.getMaxCableTransfer();
        this.updateLastTransferred(extractable);
        while (!((Collection)((Object)queue)).isEmpty() && remaining > 0L) {
            boolean input;
            Node node = queue.removeFirst();
            class_2338 targetPos = node.component2();
            class_2350 targetDir = node.component4();
            if (!HelperextensionsKt.isLoaded((class_1937)this.getWorld(), targetPos)) continue;
            ServoNetworkState servoNetworkState = state;
            class_2338 class_23382 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"targetPos.offset(targetDir)");
            class_2338 class_23383 = class_23382;
            class_23382 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"targetDir.opposite");
            EndpointData targetData = ServoNetworkState.getEndpointData$default(servoNetworkState, class_23383, (class_2350)class_23382, false, 4, null);
            boolean bl = input = targetData == null || targetData.getType() == EndpointData.Type.INPUT;
            if (!input) continue;
            Storage<FluidVariant> insertable = FluidutilsKt.fluidStorageOf(this.getWorld(), targetPos, targetDir);
            long moved = StorageUtil.move(extractable, insertable, arg_0 -> FluidNetwork.tickOutput$lambda-2(fluidFilter2, arg_0), (long)remaining, null);
            remaining -= moved;
        }
    }

    private final void tickRetriever(class_2338 pos, class_2350 dir, ReusableArrayDeque<Node> queue, FluidNetworkState state, Function1<? super FluidVariant, Boolean> fluidFilter2) {
        Storage<FluidVariant> insertable = FluidutilsKt.fluidStorageOf(this.getWorld(), pos, dir);
        long remaining = this.getMaxCableTransfer();
        while (!((Collection)((Object)queue)).isEmpty() && remaining > 0L) {
            boolean isRetriever;
            EndpointData targetData;
            Node node = queue.removeFirst();
            class_2338 targetPos = node.component2();
            class_2350 targetDir = node.component4();
            if (!HelperextensionsKt.isLoaded((class_1937)this.getWorld(), targetPos)) continue;
            ServoNetworkState servoNetworkState = state;
            class_2338 class_23382 = targetPos.method_10093(targetDir);
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"targetPos.offset(targetDir)");
            class_2338 class_23383 = class_23382;
            class_23382 = targetDir.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"targetDir.opposite");
            EndpointData endpointData = targetData = ServoNetworkState.getEndpointData$default(servoNetworkState, class_23383, (class_2350)class_23382, false, 4, null);
            boolean bl = isRetriever = (endpointData == null ? null : endpointData.getType()) == EndpointData.Type.RETRIEVER;
            if (isRetriever) continue;
            Storage<FluidVariant> extractable = FluidutilsKt.fluidStorageOf(this.getWorld(), targetPos, targetDir);
            this.updateLastTransferred(extractable);
            long moved = StorageUtil.move(extractable, insertable, arg_0 -> FluidNetwork.tickRetriever$lambda-3(fluidFilter2, arg_0), (long)remaining, null);
            remaining -= moved;
        }
    }

    private final void updateLastTransferred(Storage<FluidVariant> extractable) {
        ResourceAmount content;
        if (this.lastTransferred.isBlank() && (content = StorageUtil.findExtractableContent(extractable, null)) != null) {
            Object object = content.resource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"content.resource");
            this.lastTransferred = (FluidVariant)object;
        }
    }

    @Override
    public void appendPipe(@NotNull class_2248 block, @NotNull class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        FluidPipeBlock fluidPipeBlock = block instanceof FluidPipeBlock ? (FluidPipeBlock)block : null;
        if (fluidPipeBlock == null) {
            return;
        }
        FluidPipeBlock cable = fluidPipeBlock;
        this.tier = cable.getTier();
        super.appendPipe(block, blockPos);
    }

    private static final boolean tickOutput$lambda-2(Function1 $tmp0, FluidVariant p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    private static final boolean tickRetriever$lambda-3(Function1 $tmp0, FluidVariant p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    private static final boolean NO_FLUID_FILTER$lambda-4(FluidKey it) {
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/steven/indrev/networks/fluid/FluidNetwork$Companion;", "", "()V", "NO_FLUID_FILTER", "Lalexiil/mc/lib/attributes/fluid/filter/FluidFilter;", "indrev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            nArray[Tier.MK1.ordinal()] = 1;
            nArray[Tier.MK2.ordinal()] = 2;
            nArray[Tier.MK3.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

