/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.steven.indrev.networks.EndpointData;
import me.steven.indrev.networks.NetworkState;
import me.steven.indrev.networks.Node;
import me.steven.indrev.networks.client.ClientNetworkInfo;
import me.steven.indrev.networks.client.ClientServoNetworkInfo;
import me.steven.indrev.networks.client.node.ClientServoNodeInfo;
import me.steven.indrev.networks.energy.EnergyNetwork;
import me.steven.indrev.networks.factory.FactoriesKt;
import me.steven.indrev.networks.factory.NetworkFactory;
import me.steven.indrev.networks.fluid.FluidNetwork;
import me.steven.indrev.networks.fluid.FluidNetworkState;
import me.steven.indrev.networks.item.ItemNetwork;
import me.steven.indrev.networks.item.ItemNetworkState;
import me.steven.indrev.utils.AccessorextensionsKt;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 22\u00020\u0001:\u000223BE\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\fH\u0016J\u0018\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020!H\u0004J(\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0004J\b\u0010.\u001a\u00020/H\u0004J\b\u00100\u001a\u00020!H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H&R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lme/steven/indrev/networks/Network;", "", "type", "Lme/steven/indrev/networks/Network$Type;", "world", "Lnet/minecraft/server/world/ServerWorld;", "pipes", "", "Lnet/minecraft/util/math/BlockPos;", "containers", "", "Ljava/util/EnumSet;", "Lnet/minecraft/util/math/Direction;", "(Lme/steven/indrev/networks/Network$Type;Lnet/minecraft/server/world/ServerWorld;Ljava/util/Set;Ljava/util/Map;)V", "getContainers", "()Ljava/util/Map;", "getPipes", "()Ljava/util/Set;", "queue", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "", "Lme/steven/indrev/networks/Node;", "getQueue", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "state", "Lme/steven/indrev/networks/NetworkState;", "getState", "()Lme/steven/indrev/networks/NetworkState;", "getType", "()Lme/steven/indrev/networks/Network$Type;", "getWorld", "()Lnet/minecraft/server/world/ServerWorld;", "appendContainer", "", "blockPos", "direction", "appendPipe", "block", "Lnet/minecraft/block/Block;", "buildQueue", "find", "source", "count", "", "s", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "isQueueValid", "", "remove", "tick", "Companion", "Type", "indrev"})
public abstract class Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type<?> type;
    @NotNull
    private final class_3218 world;
    @NotNull
    private final Set<class_2338> pipes;
    @NotNull
    private final Map<class_2338, EnumSet<class_2350>> containers;
    @NotNull
    private final NetworkState<? extends Network> state;
    @NotNull
    private final Object2ObjectOpenHashMap<class_2338, List<Node>> queue;
    @NotNull
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public Network(@NotNull Type<?> type, @NotNull class_3218 world, @NotNull Set<class_2338> pipes, @NotNull Map<class_2338, EnumSet<class_2350>> containers) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(pipes, (String)"pipes");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        this.type = type;
        this.world = world;
        this.pipes = pipes;
        this.containers = containers;
        this.state = this.type.getNetworkState(this.world);
        this.queue = new Object2ObjectOpenHashMap(this.containers.size());
    }

    public /* synthetic */ Network(Type type, class_3218 class_32182, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = (Set)new ObjectOpenHashSet();
        }
        if ((n & 8) != 0) {
            map = (Map)new Object2ObjectOpenHashMap();
        }
        this(type, class_32182, set, map);
    }

    @NotNull
    public final Type<?> getType() {
        return this.type;
    }

    @NotNull
    public final class_3218 getWorld() {
        return this.world;
    }

    @NotNull
    public final Set<class_2338> getPipes() {
        return this.pipes;
    }

    @NotNull
    public final Map<class_2338, EnumSet<class_2350>> getContainers() {
        return this.containers;
    }

    @NotNull
    public final NetworkState<? extends Network> getState() {
        return this.state;
    }

    @NotNull
    protected final Object2ObjectOpenHashMap<class_2338, List<Node>> getQueue() {
        return this.queue;
    }

    protected final boolean isQueueValid() {
        if (this.queue.isEmpty() && !this.containers.isEmpty()) {
            this.buildQueue();
        }
        return !((Map)this.queue).isEmpty();
    }

    protected final void buildQueue() {
        this.queue.clear();
        Map<class_2338, EnumSet<class_2350>> $this$forEach$iv = this.containers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<class_2338, EnumSet<class_2350>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, EnumSet<class_2350>> element$iv;
            Map.Entry<class_2338, EnumSet<class_2350>> $dstr$pos$_u24__u24 = element$iv = iterator.next();
            boolean bl = false;
            class_2338 pos = $dstr$pos$_u24__u24.getKey();
            this.find(pos, pos, 0, new LongOpenHashSet());
        }
    }

    protected final void find(@NotNull class_2338 source, @NotNull class_2338 blockPos, int count, @NotNull LongOpenHashSet s2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        class_2350[] $this$forEach$iv = DIRECTIONS;
        boolean $i$f$forEach = false;
        class_2350[] class_2350Array = $this$forEach$iv;
        int n = 0;
        int n2 = class_2350Array.length;
        while (n < n2) {
            class_2350 element$iv = class_2350Array[n];
            ++n;
            class_2350 dir = element$iv;
            boolean bl = false;
            class_2338 offset = blockPos.method_10093(dir.method_10153());
            if (this.getPipes().contains(offset) && s2.add(offset.method_10063())) {
                Intrinsics.checkNotNullExpressionValue((Object)offset, (String)"offset");
                this.find(source, offset, count + 1, s2);
            }
            if (Intrinsics.areEqual((Object)source, (Object)offset) || !this.getContainers().containsKey(offset)) continue;
            EnumSet<class_2350> enumSet = this.getContainers().get(offset);
            Intrinsics.checkNotNull(enumSet);
            if (!enumSet.contains(dir)) continue;
            List list = (List)this.getQueue().computeIfAbsent((Object)source, arg_0 -> Network.find$lambda-2$lambda-1(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)offset, (String)"offset");
            list.add(new Node(source, offset, count, dir));
        }
    }

    public abstract void tick(@NotNull class_3218 var1);

    public void remove() {
        this.state.remove(this);
    }

    public void appendPipe(@NotNull class_2248 block, @NotNull class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.pipes.add(blockPos);
        this.state.set(blockPos, this);
    }

    public void appendContainer(@NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.containers.computeIfAbsent(blockPos, Network::appendContainer$lambda-3).add(direction);
        this.state.set(blockPos, this);
    }

    private static final ArrayList find$lambda-2$lambda-1(Network this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new ArrayList(this$0.containers.size());
    }

    private static final EnumSet appendContainer$lambda-3(class_2338 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EnumSet.noneOf(class_2350.class);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lme/steven/indrev/networks/Network$Companion;", "", "()V", "DIRECTIONS", "", "Lnet/minecraft/util/math/Direction;", "getDIRECTIONS", "()[Lnet/minecraft/util/math/Direction;", "[Lnet/minecraft/util/math/Direction;", "handleBreak", "", "T", "Lme/steven/indrev/networks/Network;", "state", "Lme/steven/indrev/networks/NetworkState;", "pos", "Lnet/minecraft/util/math/BlockPos;", "handleUpdate", "indrev"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2350[] getDIRECTIONS() {
            return DIRECTIONS;
        }

        public final <T extends Network> void handleBreak(@NotNull NetworkState<T> state, @NotNull class_2338 pos) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Network network = (Network)state.getNetworksByPos().get(pos.method_10063());
            if (network != null) {
                network.remove();
            }
            class_2350[] $this$forEach$iv = this.getDIRECTIONS();
            boolean $i$f$forEach = false;
            for (class_2350 element$iv : $this$forEach$iv) {
                class_2350 it = element$iv;
                boolean bl = false;
                class_2338 offset = pos.method_10093(it);
                Intrinsics.checkNotNullExpressionValue((Object)offset, (String)"offset");
                Companion.handleUpdate(state, offset);
            }
        }

        public final <T extends Network> void handleUpdate(@NotNull NetworkState<T> state, @NotNull class_2338 pos) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Network network = (Network)state.getNetworksByPos().get(pos.method_10063());
            if (network != null) {
                network.remove();
            }
            state.queueUpdate(pos.method_10063(), true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u0015*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lme/steven/indrev/networks/Network$Type;", "T", "Lme/steven/indrev/networks/Network;", "", "key", "", "(Ljava/lang/String;)V", "factory", "Lme/steven/indrev/networks/factory/NetworkFactory;", "getFactory", "()Lme/steven/indrev/networks/factory/NetworkFactory;", "getKey", "()Ljava/lang/String;", "createClientNetworkInfo", "Lme/steven/indrev/networks/client/ClientNetworkInfo;", "world", "Lnet/minecraft/server/world/ServerWorld;", "createEmpty", "(Lnet/minecraft/server/world/ServerWorld;)Lme/steven/indrev/networks/Network;", "getNetworkState", "Lme/steven/indrev/networks/NetworkState;", "Companion", "indrev"})
    public static abstract class Type<T extends Network> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String key;
        @NotNull
        private static final Type<EnergyNetwork> ENERGY = new Type<EnergyNetwork>(){
            @NotNull
            private final NetworkFactory<EnergyNetwork> factory;
            {
                this.factory = FactoriesKt.getENERGY_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<EnergyNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public EnergyNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new EnergyNetwork(world, null, null, 6, null);
            }

            @NotNull
            public NetworkState<EnergyNetwork> getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getEnergyNetworkState(world);
            }

            @Nullable
            public ClientNetworkInfo<?> createClientNetworkInfo(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return null;
            }
        };
        @NotNull
        private static final Type<FluidNetwork> FLUID = new Type<FluidNetwork>(){
            @NotNull
            private final NetworkFactory<FluidNetwork> factory;
            {
                this.factory = FactoriesKt.getFLUID_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<FluidNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public FluidNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new FluidNetwork(world, null, null, 6, null);
            }

            @NotNull
            public FluidNetworkState getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getFluidNetworkState(world);
            }

            @NotNull
            public ClientNetworkInfo<?> createClientNetworkInfo(@NotNull class_3218 world) {
                ClientServoNetworkInfo clientServoNetworkInfo;
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                FluidNetworkState state = this.getNetworkState(world);
                ClientServoNetworkInfo it = clientServoNetworkInfo = new ClientServoNetworkInfo();
                boolean bl = false;
                Map $this$forEach$iv = (Map)state.getEndpointData();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$pos$data = element$iv = iterator.next();
                    boolean bl2 = false;
                    Long pos = (Long)$dstr$pos$data.getKey();
                    Object2ObjectOpenHashMap data = (Object2ObjectOpenHashMap)$dstr$pos$data.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
                    ClientServoNodeInfo info = new ClientServoNodeInfo(pos, (Object2ObjectOpenHashMap<class_2350, EndpointData.Type>)new Object2ObjectOpenHashMap());
                    Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                    Map $this$forEach$iv2 = (Map)data;
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv2;
                        Map.Entry<K, V> $dstr$dir$endpointData = element$iv2 = iterator2.next();
                        boolean bl3 = false;
                        class_2350 dir = (class_2350)$dstr$dir$endpointData.getKey();
                        EndpointData endpointData = (EndpointData)$dstr$dir$endpointData.getValue();
                        Map map = (Map)info.getServos();
                        EndpointData.Type type = endpointData.getType();
                        map.put(dir, type);
                    }
                    ((Map)it.getPipes()).put(pos, info);
                }
                return clientServoNetworkInfo;
            }
        };
        @NotNull
        private static final Type<ItemNetwork> ITEM = new Type<ItemNetwork>(){
            @NotNull
            private final NetworkFactory<ItemNetwork> factory;
            {
                this.factory = FactoriesKt.getITEM_NET_FACTORY();
            }

            @NotNull
            public NetworkFactory<ItemNetwork> getFactory() {
                return this.factory;
            }

            @NotNull
            public ItemNetwork createEmpty(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new ItemNetwork(world, null, null, 6, null);
            }

            @NotNull
            public ItemNetworkState getNetworkState(@NotNull class_3218 world) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return AccessorextensionsKt.getItemNetworkState(world);
            }

            @NotNull
            public ClientNetworkInfo<?> createClientNetworkInfo(@NotNull class_3218 world) {
                ClientServoNetworkInfo clientServoNetworkInfo;
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                ItemNetworkState state = this.getNetworkState(world);
                ClientServoNetworkInfo it = clientServoNetworkInfo = new ClientServoNetworkInfo();
                boolean bl = false;
                Map $this$forEach$iv = (Map)state.getEndpointData();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$pos$data = element$iv = iterator.next();
                    boolean bl2 = false;
                    Long pos = (Long)$dstr$pos$data.getKey();
                    Object2ObjectOpenHashMap data = (Object2ObjectOpenHashMap)$dstr$pos$data.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
                    ClientServoNodeInfo info = new ClientServoNodeInfo(pos, (Object2ObjectOpenHashMap<class_2350, EndpointData.Type>)new Object2ObjectOpenHashMap());
                    Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                    Map $this$forEach$iv2 = (Map)data;
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv2;
                        Map.Entry<K, V> $dstr$dir$endpointData = element$iv2 = iterator2.next();
                        boolean bl3 = false;
                        class_2350 dir = (class_2350)$dstr$dir$endpointData.getKey();
                        EndpointData endpointData = (EndpointData)$dstr$dir$endpointData.getValue();
                        Map map = (Map)info.getServos();
                        EndpointData.Type type = endpointData.getType();
                        map.put(dir, type);
                    }
                    ((Map)it.getPipes()).put(pos, info);
                }
                return clientServoNetworkInfo;
            }
        };

        public Type(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public abstract NetworkFactory<T> getFactory();

        @NotNull
        public abstract T createEmpty(@NotNull class_3218 var1);

        @NotNull
        public abstract NetworkState<T> getNetworkState(@NotNull class_3218 var1);

        @Nullable
        public abstract ClientNetworkInfo<?> createClientNetworkInfo(@NotNull class_3218 var1);

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lme/steven/indrev/networks/Network$Type$Companion;", "", "()V", "ENERGY", "Lme/steven/indrev/networks/Network$Type;", "Lme/steven/indrev/networks/energy/EnergyNetwork;", "getENERGY", "()Lme/steven/indrev/networks/Network$Type;", "FLUID", "Lme/steven/indrev/networks/fluid/FluidNetwork;", "getFLUID", "ITEM", "Lme/steven/indrev/networks/item/ItemNetwork;", "getITEM", "valueOf", "string", "", "indrev"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Type<EnergyNetwork> getENERGY() {
                return ENERGY;
            }

            @NotNull
            public final Type<FluidNetwork> getFLUID() {
                return FLUID;
            }

            @NotNull
            public final Type<ItemNetwork> getITEM() {
                return ITEM;
            }

            @NotNull
            public final Type<?> valueOf(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                return switch (string) {
                    case "indrev_networks" -> this.getENERGY();
                    case "indrev_fluid_networks" -> this.getFLUID();
                    case "indrev_item_networks" -> this.getITEM();
                    default -> throw new IllegalArgumentException("Unknown network type " + string);
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

