/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.components;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.steven.indrev.blockentities.BaseBlockEntity;
import me.steven.indrev.blockentities.MachineBlockEntity;
import me.steven.indrev.blockentities.crafters.CraftingMachineBlockEntity;
import me.steven.indrev.components.CraftingComponent;
import me.steven.indrev.components.GuiSyncableComponentKt;
import me.steven.indrev.components.InventoryComponent;
import me.steven.indrev.inventories.IRInventory;
import me.steven.indrev.registry.IRItemRegistry;
import me.steven.indrev.utils.HelperextensionsKt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/steven/indrev/components/TemperatureComponent;", "", "blockEntity", "Lme/steven/indrev/blockentities/BaseBlockEntity;", "heatingSpeed", "", "optimalRange", "Lkotlin/ranges/IntRange;", "limit", "", "(Lme/steven/indrev/blockentities/BaseBlockEntity;DLkotlin/ranges/IntRange;I)V", "cooling", "", "getCooling", "()Z", "setCooling", "(Z)V", "getLimit", "()I", "getOptimalRange", "()Lkotlin/ranges/IntRange;", "temperature", "getTemperature", "()D", "setTemperature", "(D)V", "ticks", "isFullEfficiency", "readNbt", "", "tag", "Lnet/minecraft/nbt/NbtCompound;", "tick", "shouldHeatUp", "writeNbt", "indrev"})
public final class TemperatureComponent {
    @NotNull
    private final BaseBlockEntity blockEntity;
    private final double heatingSpeed;
    @NotNull
    private final IntRange optimalRange;
    private final int limit;
    private boolean cooling;
    private double temperature;
    private int ticks;

    public TemperatureComponent(@NotNull BaseBlockEntity blockEntity, double heatingSpeed, @NotNull IntRange optimalRange, int limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)optimalRange, (String)"optimalRange");
        this.blockEntity = blockEntity;
        this.heatingSpeed = heatingSpeed;
        this.optimalRange = optimalRange;
        this.limit = limit;
        this.cooling = true;
        this.temperature = 25.0;
        GuiSyncableComponentKt.trackInt(this.blockEntity, 2, (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return (int)this.getTemperature();
            }
        }));
        GuiSyncableComponentKt.trackInt(this.blockEntity, 3, (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return this.getLimit();
            }
        }));
    }

    @NotNull
    public final IntRange getOptimalRange() {
        return this.optimalRange;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final boolean getCooling() {
        return this.cooling;
    }

    public final void setCooling(boolean bl) {
        this.cooling = bl;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(double d) {
        this.temperature = d;
    }

    public final void readNbt(@Nullable class_2487 tag) {
        boolean bl;
        double d;
        class_2487 class_24872 = tag;
        this.temperature = class_24872 == null ? 0.0 : (d = class_24872.method_10574("Temperature"));
        class_2487 class_24873 = tag;
        this.cooling = class_24873 == null ? false : (bl = class_24873.method_10577("Cooling"));
    }

    @NotNull
    public final class_2487 writeNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10549("Temperature", this.temperature);
        tag.method_10556("Cooling", this.cooling);
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFullEfficiency() {
        InventoryComponent inventoryComponent;
        MachineBlockEntity machine;
        BaseBlockEntity baseBlockEntity = this.blockEntity;
        MachineBlockEntity machineBlockEntity = machine = baseBlockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)baseBlockEntity : null;
        InventoryComponent inventoryComponent2 = inventoryComponent = machineBlockEntity == null ? null : machineBlockEntity.getInventoryComponent();
        if (this.cooling) {
            boolean bl;
            InventoryComponent inventoryComponent3 = inventoryComponent;
            if (inventoryComponent3 == null) {
                bl = false;
            } else {
                IRInventory iRInventory = inventoryComponent3.getInventory();
                if (iRInventory == null) {
                    bl = false;
                } else {
                    class_1799 class_17992 = iRInventory.getCoolerStack();
                    if (class_17992 == null) {
                        bl = false;
                    } else {
                        if (class_17992.method_7960()) {
                            return false;
                        }
                        bl = false;
                    }
                }
            }
            if (bl) return false;
        }
        IntRange intRange = this.optimalRange;
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = (int)this.temperature;
        if (n > n3) return false;
        if (n3 > n2) return false;
        return true;
    }

    public final void tick(boolean shouldHeatUp) {
        boolean isHeatingUp;
        IRInventory inv;
        IRInventory iRInventory;
        int n = this.ticks;
        this.ticks = n + 1;
        BaseBlockEntity baseBlockEntity = this.blockEntity;
        MachineBlockEntity machine = baseBlockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)baseBlockEntity : null;
        class_1937 class_19372 = this.blockEntity.method_10997();
        Intrinsics.checkNotNull((Object)class_19372);
        Random random = class_19372.field_9229;
        MachineBlockEntity machineBlockEntity = machine;
        if (machineBlockEntity == null) {
            iRInventory = null;
        } else {
            InventoryComponent inventoryComponent = machineBlockEntity.getInventoryComponent();
            iRInventory = inventoryComponent == null ? null : inventoryComponent.getInventory();
        }
        IRInventory iRInventory2 = inv = iRInventory;
        Object object = iRInventory2 == null ? null : iRInventory2.getCoolerStack();
        if (object == null) {
            object = class_1799.field_8037;
        }
        class_1799 class_17992 = object;
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"inv?.coolerStack ?: ItemStack.EMPTY");
        class_1799 coolerStack = HelperextensionsKt.component1(class_17992);
        class_1792 coolerItem = HelperextensionsKt.component2(class_17992);
        boolean bl = isHeatingUp = shouldHeatUp || machine != null && Intrinsics.areEqual((Object)coolerItem, (Object)IRItemRegistry.INSTANCE.getHEAT_COIL()) && machine.use(16L);
        if (this.cooling) {
            int n2;
            BaseBlockEntity baseBlockEntity2 = this.blockEntity;
            CraftingMachineBlockEntity craftingMachineBlockEntity = baseBlockEntity2 instanceof CraftingMachineBlockEntity ? (CraftingMachineBlockEntity)baseBlockEntity2 : null;
            if (craftingMachineBlockEntity == null) {
                n2 = 0;
            } else {
                int n3;
                CraftingComponent<T>[] craftingComponentArray = craftingMachineBlockEntity.getCraftingComponents();
                n2 = craftingComponentArray == null ? 0 : (n3 = craftingComponentArray.length);
            }
            int modifier = n2;
            this.temperature -= this.heatingSpeed / (double)(isHeatingUp ? 3 + modifier : 1);
            if (coolerStack.method_7963() && this.ticks % 120 == 0) {
                coolerStack.method_7970(1, random, null);
            }
            if (coolerStack.method_7919() >= coolerStack.method_7936()) {
                coolerStack.method_7934(1);
            }
            if (this.temperature <= (double)((float)this.optimalRange.getFirst() + ((float)2 * random.nextFloat() - 1.0f) * (float)10)) {
                this.cooling = false;
            }
        } else if (isHeatingUp) {
            this.temperature += this.heatingSpeed;
            double n4 = (double)(this.optimalRange.getLast() + this.optimalRange.getFirst()) / 2.0;
            if (this.temperature >= n4 + (double)(((float)2 * random.nextFloat() - 1.0f) * (float)15)) {
                this.cooling = true;
            }
        } else if (this.temperature > 35.0) {
            this.temperature -= this.heatingSpeed / 1.5;
        } else if (this.ticks % 15 == 0) {
            this.temperature = RangesKt.coerceIn((double)(this.temperature + (double)(((float)2 * random.nextFloat() - 1.0f) / (float)2)), (double)20.0, (double)35.0);
        }
    }
}

