/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev;

import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class WCustomTabPanel
extends WPanel {
    private static final int TAB_PADDING = 4;
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 25;
    private static final int PANEL_PADDING = 8;
    private static final int ICON_SIZE = 16;
    private final WBox tabRibbon = new WBox(Axis.HORIZONTAL).setSpacing(1);
    private final List<WTab> tabWidgets = new ArrayList<WTab>();
    private final WCardPanel mainPanel = new WCardPanel();

    public WCustomTabPanel() {
        this.add((WWidget)this.tabRibbon, 0, 0);
        this.add((WWidget)this.mainPanel, 8, 33);
    }

    public void add(WWidget widget, int x, int y) {
        this.children.add(widget);
        widget.setParent((WPanel)this);
        widget.setLocation(x, y);
        this.expandToFit(widget);
    }

    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        return super.setBackgroundPainter(BackgroundPainter.createLightDarkVariants((BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/panel_light.png")).setPadding(0).setTopPadding(-25), (BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/panel_dark.png")).setPadding(8).setTopPadding(-25)));
    }

    public WPanel setForceBackgroundPainter(BackgroundPainter painter) {
        return super.setBackgroundPainter(painter);
    }

    public void add(Tab tab) {
        WTab tabWidget = new WTab(tab);
        if (this.tabWidgets.isEmpty()) {
            tabWidget.selected = true;
        }
        this.tabWidgets.add(tabWidget);
        this.tabRibbon.add((WWidget)tabWidget, 28, 29);
        this.mainPanel.add(tab.getWidget());
    }

    public void add(WWidget widget, Consumer<Tab.Builder> configurator) {
        Tab.Builder builder = new Tab.Builder(widget);
        configurator.accept(builder);
        this.add(builder.build());
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.tabRibbon.setSize(x, 25);
    }

    @Environment(value=EnvType.CLIENT)
    public void addPainters() {
        super.addPainters();
    }

    private final class WTab
    extends WWidget {
        private final Tab data;
        boolean selected = false;

        WTab(Tab data) {
            this.data = data;
        }

        public boolean canFocus() {
            return true;
        }

        @Environment(value=EnvType.CLIENT)
        public InputResult onClick(int x, int y, int button2) {
            super.onClick(x, y, button2);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            for (WTab tab : WCustomTabPanel.this.tabWidgets) {
                tab.selected = tab == this;
            }
            WCustomTabPanel.this.mainPanel.setSelectedCard(this.data.getWidget());
            WCustomTabPanel.this.layout();
            return InputResult.PROCESSED;
        }

        @Environment(value=EnvType.CLIENT)
        public void onKeyPressed(int ch, int key, int modifiers) {
            if (WTab.isActivationKey((int)ch)) {
                this.onClick(0, 0, 0);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            class_327 renderer = class_310.method_1551().field_1772;
            class_2561 title = this.data.getTitle();
            Icon icon = this.data.getIcon();
            if (title != null) {
                int width = 28 + renderer.method_27525((class_5348)title);
                if (icon == null) {
                    width = Math.max(28, width - 16);
                }
                if (this.width != width) {
                    this.setSize(width, this.height);
                    this.getParent().layout();
                }
            }
            (this.selected ? Painters.SELECTED_TAB : Painters.UNSELECTED_TAB).paintBackground(matrices, x, y, (WWidget)this);
            if (this.isFocused()) {
                (this.selected ? Painters.SELECTED_TAB_FOCUS_BORDER : Painters.UNSELECTED_TAB_FOCUS_BORDER).paintBackground(matrices, x, y, (WWidget)this);
            }
            int iconX = 6;
            if (title != null) {
                HorizontalAlignment align;
                int titleX = icon != null ? iconX + 16 + 1 : 0;
                Objects.requireNonNull(renderer);
                int titleY = (this.height - 4 - 9) / 2 + 1;
                int width = icon != null ? this.width - iconX - 16 : this.width;
                HorizontalAlignment horizontalAlignment = align = icon != null ? HorizontalAlignment.LEFT : HorizontalAlignment.CENTER;
                int color = LibGui.isDarkMode() ? 0xBCBCBC : (this.selected ? 0x404040 : 0xEEEEEE);
                ScreenDrawing.drawString((class_4587)matrices, (class_5481)title.method_30937(), (HorizontalAlignment)align, (int)(x + titleX), (int)(y + titleY), (int)width, (int)color);
            }
            if (icon != null) {
                icon.paint(matrices, x + iconX, y + (this.height - 4 - 16) / 2 + 1, 16);
            }
        }

        public void addTooltip(TooltipBuilder tooltip) {
            this.data.addTooltip(tooltip);
        }
    }

    public static class Tab {
        private final class_2561 title;
        private final Icon icon;
        private final WWidget widget;
        private final Consumer<TooltipBuilder> tooltip;

        public Tab(class_2561 title, Icon icon, WWidget widget, Consumer<TooltipBuilder> tooltip) {
            if (title == null && icon == null) {
                throw new IllegalArgumentException("A tab must have a title or an icon");
            }
            this.title = title;
            this.icon = icon;
            this.widget = Objects.requireNonNull(widget, "widget");
            this.tooltip = tooltip;
        }

        public class_2561 getTitle() {
            return this.title;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public WWidget getWidget() {
            return this.widget;
        }

        public void addTooltip(TooltipBuilder tooltip) {
            if (this.tooltip != null) {
                this.tooltip.accept(tooltip);
            }
        }

        public static final class Builder {
            @Nullable
            private class_2561 title;
            @Nullable
            private Icon icon;
            private final WWidget widget;
            private final List<class_2561> tooltip = new ArrayList<class_2561>();

            public Builder(WWidget widget) {
                this.widget = Objects.requireNonNull(widget, "widget");
            }

            public Builder title(class_2561 title) {
                this.title = Objects.requireNonNull(title, "title");
                return this;
            }

            public Builder icon(Icon icon) {
                this.icon = Objects.requireNonNull(icon, "icon");
                return this;
            }

            public Builder tooltip(class_2561 ... lines) {
                Objects.requireNonNull(lines, "lines");
                Collections.addAll(this.tooltip, lines);
                return this;
            }

            public Builder tooltip(Collection<? extends class_2561> lines) {
                Objects.requireNonNull(lines, "lines");
                this.tooltip.addAll(lines);
                return this;
            }

            public Tab build() {
                Consumer<TooltipBuilder> tooltip = null;
                if (!this.tooltip.isEmpty()) {
                    tooltip = new Consumer<TooltipBuilder>(){

                        @Override
                        @Environment(value=EnvType.CLIENT)
                        public void accept(TooltipBuilder builder) {
                            builder.add(tooltip.toArray(new class_2561[0]));
                        }
                    };
                }
                return new Tab(this.title, this.icon, this.widget, tooltip);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static final class Painters {
        static final BackgroundPainter SELECTED_TAB = BackgroundPainter.createLightDarkVariants((BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("indrev", "textures/gui/selected_light.png")).setTopPadding(2), (BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/tab/selected_dark.png")).setTopPadding(2));
        static final BackgroundPainter UNSELECTED_TAB = BackgroundPainter.createLightDarkVariants((BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("indrev", "textures/gui/unselected_light.png")), (BackgroundPainter)BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/tab/unselected_dark.png")));
        static final BackgroundPainter SELECTED_TAB_FOCUS_BORDER = BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/tab/focus.png")).setTopPadding(2);
        static final BackgroundPainter UNSELECTED_TAB_FOCUS_BORDER = BackgroundPainter.createNinePatch((class_2960)new class_2960("libgui", "textures/widget/tab/focus.png"));

        Painters() {
        }
    }
}

